/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.registry;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.registry.IRegistryConstants;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;

public abstract class AbstractBuildExtension
implements IRegistryConstants {
    private final String fIdAttribute;
    private final String fNameAttribute;
    private final String fDescriptionAttribute;

    protected AbstractBuildExtension(IConfigurationElement pluginConfigurationElement) {
        ValidationHelper.validateNotNull("pluginConfigurationElement", pluginConfigurationElement);
        this.fIdAttribute = pluginConfigurationElement.getAttribute("id");
        ValidationHelper.validateNotNull("id", this.fIdAttribute);
        ValidationHelper.validateNotEmpty("id", this.fIdAttribute.trim());
        this.fNameAttribute = pluginConfigurationElement.getAttribute("name");
        ValidationHelper.validateNotNull("name", this.fNameAttribute);
        ValidationHelper.validateNotEmpty("name", this.fNameAttribute.trim());
        this.fDescriptionAttribute = pluginConfigurationElement.getAttribute("description");
    }

    public String getNameAttribute() {
        return this.fNameAttribute;
    }

    public String getDescriptionAttribute() {
        return this.fDescriptionAttribute;
    }

    public String getIdAttribute() {
        return this.fIdAttribute;
    }

    public int hashCode() {
        return this.fIdAttribute.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractBuildExtension other = (AbstractBuildExtension)obj;
        return !(this.fIdAttribute == null ? other.fIdAttribute != null : !this.fIdAttribute.equals(other.fIdAttribute));
    }

    protected void processGenericProperties(IConfigurationElement pluginConfigurationElement, List<IBuildProperty> genericProperties, boolean forTemplate) {
        IConfigurationElement[] pluginElements;
        IConfigurationElement[] iConfigurationElementArray = pluginElements = pluginConfigurationElement.getChildren("genericProperty");
        int n = pluginElements.length;
        int n2 = 0;
        while (n2 < n) {
            String wellKnown;
            String scheduleOverride;
            String label;
            String required;
            String defaultValue;
            IConfigurationElement pluginElement = iConfigurationElementArray[n2];
            String name = pluginElement.getAttribute("name");
            ValidationHelper.validateNotNull("name", name);
            ValidationHelper.validateNotEmpty("name", name.trim());
            IBuildProperty property = BuildItemFactory.createBuildProperty();
            property.setName(name);
            String description = this.getAttributeIfNonEmpty(pluginElement, "description");
            if (description != null) {
                property.setDescription(description);
            }
            if ((defaultValue = this.getAttributeIfNonEmpty(pluginElement, "defaultValue")) != null) {
                property.setValue(defaultValue);
            }
            if ((required = this.getAttributeIfNonEmpty(pluginElement, "required")) != null) {
                property.setRequired(Boolean.valueOf(required));
            }
            if ((label = this.getAttributeIfNonEmpty(pluginElement, "label")) != null) {
                property.setLabel(label);
            }
            if ((scheduleOverride = this.getAttributeIfNonEmpty(pluginElement, "scheduleOverride")) != null) {
                property.setScheduleOverride(Boolean.valueOf(scheduleOverride));
            }
            if ((wellKnown = this.getAttributeIfNonEmpty(pluginElement, "wellKnown")) != null) {
                property.setWellKnown(Boolean.valueOf(wellKnown));
            }
            if (forTemplate) {
                property.setGenericEditAllowed(true);
            } else {
                String genericEditAllowed = pluginElement.getAttribute("genericEditAllowed");
                ValidationHelper.validateNotNull("genericEditAllowed", genericEditAllowed);
                ValidationHelper.validateNotEmpty("genericEditAllowed", genericEditAllowed.trim());
                property.setGenericEditAllowed(Boolean.valueOf(genericEditAllowed));
                String kind = pluginElement.getAttribute("kind");
                if (kind != null && kind.trim().length() > 0) {
                    property.setKind(kind);
                }
            }
            genericProperties.add(property);
            ++n2;
        }
    }

    private String getAttributeIfNonEmpty(IConfigurationElement pluginElement, String attrName) {
        String attrValue = pluginElement.getAttribute(attrName);
        if (attrValue != null && attrValue.trim().length() > 0) {
            return attrValue;
        }
        return null;
    }
}

