/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.registry;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.registry.AbstractBuildExtension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;

public abstract class AbstractBuildConfigurationElementExtension
extends AbstractBuildExtension {
    private final List<IBuildProperty> fGenericProperties = new ArrayList<IBuildProperty>();
    private final Map<String, IConfigurationProperty> fConfigurationProperties = new HashMap<String, IConfigurationProperty>();

    public AbstractBuildConfigurationElementExtension(IConfigurationElement pluginConfigurationElement) {
        super(pluginConfigurationElement);
        this.processGenericProperties(pluginConfigurationElement, this.fGenericProperties, false);
        this.processConfigurationProperties(pluginConfigurationElement);
    }

    private void processConfigurationProperties(IConfigurationElement pluginConfigurationElement) {
        IConfigurationElement[] pluginElements;
        IConfigurationElement[] iConfigurationElementArray = pluginElements = pluginConfigurationElement.getChildren("configurationProperty");
        int n = pluginElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement pluginElement = iConfigurationElementArray[n2];
            String name = pluginElement.getAttribute("name");
            ValidationHelper.validateNotNull("name", name);
            ValidationHelper.validateNotEmpty("name", name.trim());
            String defaultValue = pluginElement.getAttribute("defaultValue");
            IConfigurationProperty property = BuildItemFactory.createConfigurationProperty();
            property.setName(name);
            if (defaultValue != null && defaultValue.trim().length() > 0) {
                property.setValue(defaultValue.trim());
            }
            this.fConfigurationProperties.put(property.getName(), property);
            ++n2;
        }
    }

    public String getElementIdAttribute() {
        return this.getIdAttribute();
    }

    public IBuildProperty[] getGenericProperties() {
        return this.fGenericProperties.toArray(new IBuildProperty[this.fGenericProperties.size()]);
    }

    public IConfigurationProperty[] getConfigurationProperties() {
        return this.fConfigurationProperties.values().toArray(new IConfigurationProperty[this.fConfigurationProperties.size()]);
    }

    public IConfigurationProperty getConfigurationProperty(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        return this.fConfigurationProperties.get(propertyName);
    }

    public String getConfigurationPropertyDefaultValue(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        return this.fConfigurationProperties.get(propertyName).getValue();
    }
}

