/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.model.dto.impl;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.BuildResultSearchCriteria;
import com.ibm.team.build.internal.common.model.dto.DtoPackage;
import com.ibm.team.build.internal.common.model.dto.IBuildResultSearchCriteria;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributorHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class BuildResultSearchCriteriaImpl
extends EObjectImpl
implements BuildResultSearchCriteria {
    public static final int BUILD_DEFINITION_CRITERIA_FLAG = 1;
    public static final int PROCESS_AREA_CRITERIA_FLAG = 2;
    public static final int PROJECT_AREA_CRITERIA_FLAG = 4;
    public static final int TAG_CRITERIA_FLAG = 8;
    public static final int CONTRIBUTOR_CRITERIA_FLAG = 16;
    public static final int QUERY_BY_TAGS_AND_BUILD_DEFINITIONS_FLAGS = 9;
    public static final int QUERY_BY_TAG_AND_PROJECT_AREA_FLAGS = 12;
    public static final int QUERY_BY_CONTRIBUTOR_AND_PROJECT_AREA_FLAGS = 20;
    protected int ALL_FLAGS = 0;
    protected static final int BUILD_DEFINITION_CRITERIA_FLAGS_EDEFAULT = 0;
    protected int buildDefinitionCriteriaFlags = 0;
    protected static final int BUILD_DEFINITION_CRITERIA_FLAGS_ESETFLAG = 1;
    protected static final boolean OPTIONAL_PERSONAL_BUILD_FILTERED_EDEFAULT = false;
    protected static final int OPTIONAL_PERSONAL_BUILD_FILTERED_EFLAG = 2;
    protected static final int OPTIONAL_PERSONAL_BUILD_FILTERED_ESETFLAG = 4;
    protected static final boolean OPTIONAL_MY_PERSONAL_BUILDS_FILTERED_EDEFAULT = false;
    protected static final int OPTIONAL_MY_PERSONAL_BUILDS_FILTERED_EFLAG = 8;
    protected static final int OPTIONAL_MY_PERSONAL_BUILDS_FILTERED_ESETFLAG = 16;
    protected EList optionalBuildDefinitions;
    protected EList optionalTags;
    protected EList optionalBuildEngines;
    protected EList optionalContributors;
    protected EList optionalProcessAreas;
    protected EList optionalBuildStates;
    protected EList optionalProjectAreas;

    protected BuildResultSearchCriteriaImpl() {
    }

    protected EClass eStaticClass() {
        return DtoPackage.Literals.BUILD_RESULT_SEARCH_CRITERIA;
    }

    @Override
    public int getBuildDefinitionCriteriaFlags() {
        return this.buildDefinitionCriteriaFlags;
    }

    @Override
    public void setBuildDefinitionCriteriaFlags(int newBuildDefinitionCriteriaFlags) {
        int oldBuildDefinitionCriteriaFlags = this.buildDefinitionCriteriaFlags;
        this.buildDefinitionCriteriaFlags = newBuildDefinitionCriteriaFlags;
        boolean oldBuildDefinitionCriteriaFlagsESet = (this.ALL_FLAGS & 1) != 0;
        this.ALL_FLAGS |= 1;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldBuildDefinitionCriteriaFlags, this.buildDefinitionCriteriaFlags, !oldBuildDefinitionCriteriaFlagsESet));
        }
    }

    @Override
    public void unsetBuildDefinitionCriteriaFlags() {
        int oldBuildDefinitionCriteriaFlags = this.buildDefinitionCriteriaFlags;
        boolean oldBuildDefinitionCriteriaFlagsESet = (this.ALL_FLAGS & 1) != 0;
        this.buildDefinitionCriteriaFlags = 0;
        this.ALL_FLAGS &= 0xFFFFFFFE;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 0, oldBuildDefinitionCriteriaFlags, 0, oldBuildDefinitionCriteriaFlagsESet));
        }
    }

    @Override
    public boolean isSetBuildDefinitionCriteriaFlags() {
        return (this.ALL_FLAGS & 1) != 0;
    }

    @Override
    public boolean isOptionalPersonalBuildFiltered() {
        return (this.ALL_FLAGS & 2) != 0;
    }

    @Override
    public void setOptionalPersonalBuildFiltered(boolean newOptionalPersonalBuildFiltered) {
        boolean oldOptionalPersonalBuildFiltered;
        boolean bl = oldOptionalPersonalBuildFiltered = (this.ALL_FLAGS & 2) != 0;
        this.ALL_FLAGS = newOptionalPersonalBuildFiltered ? (this.ALL_FLAGS |= 2) : (this.ALL_FLAGS &= 0xFFFFFFFD);
        boolean oldOptionalPersonalBuildFilteredESet = (this.ALL_FLAGS & 4) != 0;
        this.ALL_FLAGS |= 4;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldOptionalPersonalBuildFiltered, newOptionalPersonalBuildFiltered, !oldOptionalPersonalBuildFilteredESet));
        }
    }

    @Override
    public void unsetOptionalPersonalBuildFiltered() {
        boolean oldOptionalPersonalBuildFiltered = (this.ALL_FLAGS & 2) != 0;
        boolean oldOptionalPersonalBuildFilteredESet = (this.ALL_FLAGS & 4) != 0;
        this.ALL_FLAGS &= 0xFFFFFFFD;
        this.ALL_FLAGS &= 0xFFFFFFFB;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 1, oldOptionalPersonalBuildFiltered, false, oldOptionalPersonalBuildFilteredESet));
        }
    }

    @Override
    public boolean isSetOptionalPersonalBuildFiltered() {
        return (this.ALL_FLAGS & 4) != 0;
    }

    @Override
    public boolean isOptionalMyPersonalBuildsFiltered() {
        return (this.ALL_FLAGS & 8) != 0;
    }

    @Override
    public void setOptionalMyPersonalBuildsFiltered(boolean newOptionalMyPersonalBuildsFiltered) {
        boolean oldOptionalMyPersonalBuildsFiltered;
        boolean bl = oldOptionalMyPersonalBuildsFiltered = (this.ALL_FLAGS & 8) != 0;
        this.ALL_FLAGS = newOptionalMyPersonalBuildsFiltered ? (this.ALL_FLAGS |= 8) : (this.ALL_FLAGS &= 0xFFFFFFF7);
        boolean oldOptionalMyPersonalBuildsFilteredESet = (this.ALL_FLAGS & 0x10) != 0;
        this.ALL_FLAGS |= 0x10;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldOptionalMyPersonalBuildsFiltered, newOptionalMyPersonalBuildsFiltered, !oldOptionalMyPersonalBuildsFilteredESet));
        }
    }

    @Override
    public void unsetOptionalMyPersonalBuildsFiltered() {
        boolean oldOptionalMyPersonalBuildsFiltered = (this.ALL_FLAGS & 8) != 0;
        boolean oldOptionalMyPersonalBuildsFilteredESet = (this.ALL_FLAGS & 0x10) != 0;
        this.ALL_FLAGS &= 0xFFFFFFF7;
        this.ALL_FLAGS &= 0xFFFFFFEF;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 2, oldOptionalMyPersonalBuildsFiltered, false, oldOptionalMyPersonalBuildsFilteredESet));
        }
    }

    @Override
    public boolean isSetOptionalMyPersonalBuildsFiltered() {
        return (this.ALL_FLAGS & 0x10) != 0;
    }

    @Override
    public List getOptionalBuildDefinitions() {
        if (this.optionalBuildDefinitions == null) {
            this.optionalBuildDefinitions = new EObjectResolvingEList.Unsettable(IBuildDefinitionHandle.class, (InternalEObject)this, 3);
        }
        return this.optionalBuildDefinitions;
    }

    @Override
    public void unsetOptionalBuildDefinitions() {
        if (this.optionalBuildDefinitions != null) {
            ((InternalEList.Unsettable)this.optionalBuildDefinitions).unset();
        }
    }

    @Override
    public boolean isSetOptionalBuildDefinitions() {
        return this.optionalBuildDefinitions != null && ((InternalEList.Unsettable)this.optionalBuildDefinitions).isSet();
    }

    @Override
    public List getOptionalTags() {
        if (this.optionalTags == null) {
            this.optionalTags = new EDataTypeUniqueEList.Unsettable(String.class, (InternalEObject)this, 4);
        }
        return this.optionalTags;
    }

    @Override
    public void unsetOptionalTags() {
        if (this.optionalTags != null) {
            ((InternalEList.Unsettable)this.optionalTags).unset();
        }
    }

    @Override
    public boolean isSetOptionalTags() {
        return this.optionalTags != null && ((InternalEList.Unsettable)this.optionalTags).isSet();
    }

    @Override
    public List getOptionalBuildEngines() {
        if (this.optionalBuildEngines == null) {
            this.optionalBuildEngines = new EObjectResolvingEList.Unsettable(IBuildEngineHandle.class, (InternalEObject)this, 5);
        }
        return this.optionalBuildEngines;
    }

    @Override
    public void unsetOptionalBuildEngines() {
        if (this.optionalBuildEngines != null) {
            ((InternalEList.Unsettable)this.optionalBuildEngines).unset();
        }
    }

    @Override
    public boolean isSetOptionalBuildEngines() {
        return this.optionalBuildEngines != null && ((InternalEList.Unsettable)this.optionalBuildEngines).isSet();
    }

    @Override
    public List getOptionalContributors() {
        if (this.optionalContributors == null) {
            this.optionalContributors = new EObjectResolvingEList.Unsettable(IContributorHandle.class, (InternalEObject)this, 6);
        }
        return this.optionalContributors;
    }

    @Override
    public void unsetOptionalContributors() {
        if (this.optionalContributors != null) {
            ((InternalEList.Unsettable)this.optionalContributors).unset();
        }
    }

    @Override
    public boolean isSetOptionalContributors() {
        return this.optionalContributors != null && ((InternalEList.Unsettable)this.optionalContributors).isSet();
    }

    @Override
    public List getOptionalProcessAreas() {
        if (this.optionalProcessAreas == null) {
            this.optionalProcessAreas = new EObjectResolvingEList.Unsettable(IProcessAreaHandle.class, (InternalEObject)this, 7);
        }
        return this.optionalProcessAreas;
    }

    @Override
    public void unsetOptionalProcessAreas() {
        if (this.optionalProcessAreas != null) {
            ((InternalEList.Unsettable)this.optionalProcessAreas).unset();
        }
    }

    @Override
    public boolean isSetOptionalProcessAreas() {
        return this.optionalProcessAreas != null && ((InternalEList.Unsettable)this.optionalProcessAreas).isSet();
    }

    @Override
    public List getOptionalBuildStates() {
        if (this.optionalBuildStates == null) {
            this.optionalBuildStates = new EDataTypeEList.Unsettable(String.class, (InternalEObject)this, 8);
        }
        return this.optionalBuildStates;
    }

    @Override
    public void unsetOptionalBuildStates() {
        if (this.optionalBuildStates != null) {
            ((InternalEList.Unsettable)this.optionalBuildStates).unset();
        }
    }

    @Override
    public boolean isSetOptionalBuildStates() {
        return this.optionalBuildStates != null && ((InternalEList.Unsettable)this.optionalBuildStates).isSet();
    }

    @Override
    public List getOptionalProjectAreas() {
        if (this.optionalProjectAreas == null) {
            this.optionalProjectAreas = new EObjectResolvingEList.Unsettable(IProjectAreaHandle.class, (InternalEObject)this, 9);
        }
        return this.optionalProjectAreas;
    }

    @Override
    public void unsetOptionalProjectAreas() {
        if (this.optionalProjectAreas != null) {
            ((InternalEList.Unsettable)this.optionalProjectAreas).unset();
        }
    }

    @Override
    public boolean isSetOptionalProjectAreas() {
        return this.optionalProjectAreas != null && ((InternalEList.Unsettable)this.optionalProjectAreas).isSet();
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return new Integer(this.getBuildDefinitionCriteriaFlags());
            }
            case 1: {
                return this.isOptionalPersonalBuildFiltered() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return this.isOptionalMyPersonalBuildsFiltered() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.getOptionalBuildDefinitions();
            }
            case 4: {
                return this.getOptionalTags();
            }
            case 5: {
                return this.getOptionalBuildEngines();
            }
            case 6: {
                return this.getOptionalContributors();
            }
            case 7: {
                return this.getOptionalProcessAreas();
            }
            case 8: {
                return this.getOptionalBuildStates();
            }
            case 9: {
                return this.getOptionalProjectAreas();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setBuildDefinitionCriteriaFlags((Integer)newValue);
                return;
            }
            case 1: {
                this.setOptionalPersonalBuildFiltered((Boolean)newValue);
                return;
            }
            case 2: {
                this.setOptionalMyPersonalBuildsFiltered((Boolean)newValue);
                return;
            }
            case 3: {
                this.getOptionalBuildDefinitions().clear();
                this.getOptionalBuildDefinitions().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getOptionalTags().clear();
                this.getOptionalTags().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getOptionalBuildEngines().clear();
                this.getOptionalBuildEngines().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getOptionalContributors().clear();
                this.getOptionalContributors().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getOptionalProcessAreas().clear();
                this.getOptionalProcessAreas().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getOptionalBuildStates().clear();
                this.getOptionalBuildStates().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getOptionalProjectAreas().clear();
                this.getOptionalProjectAreas().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.unsetBuildDefinitionCriteriaFlags();
                return;
            }
            case 1: {
                this.unsetOptionalPersonalBuildFiltered();
                return;
            }
            case 2: {
                this.unsetOptionalMyPersonalBuildsFiltered();
                return;
            }
            case 3: {
                this.unsetOptionalBuildDefinitions();
                return;
            }
            case 4: {
                this.unsetOptionalTags();
                return;
            }
            case 5: {
                this.unsetOptionalBuildEngines();
                return;
            }
            case 6: {
                this.unsetOptionalContributors();
                return;
            }
            case 7: {
                this.unsetOptionalProcessAreas();
                return;
            }
            case 8: {
                this.unsetOptionalBuildStates();
                return;
            }
            case 9: {
                this.unsetOptionalProjectAreas();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.isSetBuildDefinitionCriteriaFlags();
            }
            case 1: {
                return this.isSetOptionalPersonalBuildFiltered();
            }
            case 2: {
                return this.isSetOptionalMyPersonalBuildsFiltered();
            }
            case 3: {
                return this.isSetOptionalBuildDefinitions();
            }
            case 4: {
                return this.isSetOptionalTags();
            }
            case 5: {
                return this.isSetOptionalBuildEngines();
            }
            case 6: {
                return this.isSetOptionalContributors();
            }
            case 7: {
                return this.isSetOptionalProcessAreas();
            }
            case 8: {
                return this.isSetOptionalBuildStates();
            }
            case 9: {
                return this.isSetOptionalProjectAreas();
            }
        }
        return super.eIsSet(featureID);
    }

    public int getDefinitionCriteriaFlag() {
        return this.buildDefinitionCriteriaFlags;
    }

    @Override
    public IBuildDefinitionHandle[] getBuildDefinitionHandles() {
        List definitionList = this.getOptionalBuildDefinitions();
        IBuildDefinitionHandle[] buildDefinitionHandles = new IBuildDefinitionHandle[definitionList.size()];
        int i = 0;
        while (i < definitionList.size()) {
            buildDefinitionHandles[i] = (IBuildDefinitionHandle)definitionList.get(i);
            ++i;
        }
        return buildDefinitionHandles;
    }

    @Override
    public IBuildEngineHandle[] getBuildEngineHandles() {
        List engineList = this.getOptionalBuildEngines();
        IBuildEngineHandle[] buildEngineHandles = new IBuildEngineHandle[engineList.size()];
        int i = 0;
        while (i < engineList.size()) {
            buildEngineHandles[i] = (IBuildEngineHandle)engineList.get(i);
            ++i;
        }
        return buildEngineHandles;
    }

    @Override
    public String[] getBuildStates() {
        List buildStatesList = this.getOptionalBuildStates();
        String[] buildStates = new String[buildStatesList.size()];
        int i = 0;
        while (i < buildStatesList.size()) {
            buildStates[i] = (String)buildStatesList.get(i);
            ++i;
        }
        return buildStates;
    }

    @Override
    public IContributorHandle[] getContributors() {
        List contributorList = this.getOptionalContributors();
        IContributorHandle[] contributorHandles = new IContributorHandle[contributorList.size()];
        int i = 0;
        while (i < contributorList.size()) {
            contributorHandles[i] = (IContributorHandle)contributorList.get(i);
            ++i;
        }
        return contributorHandles;
    }

    @Override
    public boolean includePersonalBuilds() {
        return this.isOptionalPersonalBuildFiltered();
    }

    @Override
    public boolean includeMyPersonalBuilds() {
        return this.isOptionalMyPersonalBuildsFiltered();
    }

    @Override
    public IProcessAreaHandle[] getProcessAreaHandles() {
        List processAreaList = this.getOptionalProcessAreas();
        IProcessAreaHandle[] processAreaHandles = new IProcessAreaHandle[processAreaList.size()];
        int i = 0;
        while (i < processAreaList.size()) {
            processAreaHandles[i] = (IProcessAreaHandle)processAreaList.get(i);
            ++i;
        }
        return processAreaHandles;
    }

    @Override
    public IProjectAreaHandle[] getProjectAreaHandles() {
        List projectAreaList = this.getOptionalProjectAreas();
        IProjectAreaHandle[] projectAreaHandles = new IProjectAreaHandle[projectAreaList.size()];
        int i = 0;
        while (i < projectAreaList.size()) {
            projectAreaHandles[i] = (IProjectAreaHandle)projectAreaList.get(i);
            ++i;
        }
        return projectAreaHandles;
    }

    @Override
    public String[] getTags() {
        List tagList = this.getOptionalTags();
        String[] tags = new String[tagList.size()];
        int i = 0;
        while (i < tagList.size()) {
            tags[i] = (String)tagList.get(i);
            ++i;
        }
        return tags;
    }

    @Override
    public boolean isBuildEnginesSet() {
        return this.isSetOptionalBuildEngines();
    }

    @Override
    public boolean isBuildStatesSet() {
        return this.isSetOptionalBuildStates();
    }

    @Override
    public IBuildResultSearchCriteria forDefinitions(List<? extends IBuildDefinitionHandle> definitionHandles) {
        ValidationHelper.validateNotNull("definitionHandles", definitionHandles);
        ValidationHelper.validateNotNullElements("definitionHandles", definitionHandles.toArray());
        this.getOptionalBuildDefinitions().clear();
        this.getOptionalBuildDefinitions().addAll(definitionHandles);
        this.flag(1);
        return this;
    }

    @Override
    public IBuildResultSearchCriteria forEngine(IBuildEngineHandle engineHandle) {
        ValidationHelper.validateNotNull("engineHandle", engineHandle);
        this.getOptionalBuildEngines().clear();
        this.getOptionalBuildEngines().add(engineHandle);
        return this;
    }

    @Override
    public IBuildResultSearchCriteria inState(BuildState ... buildStates) {
        ValidationHelper.validateNotNull("buildStates", (Object[])buildStates);
        ValidationHelper.validateNotNullElements("buildStates", (Object[])buildStates);
        this.getOptionalBuildStates().clear();
        BuildState[] buildStateArray = buildStates;
        int n = buildStates.length;
        int n2 = 0;
        while (n2 < n) {
            BuildState buildState = buildStateArray[n2];
            this.getOptionalBuildStates().add(buildState.name());
            ++n2;
        }
        return this;
    }

    @Override
    public IBuildResultSearchCriteria withMember(IContributorHandle member) {
        ValidationHelper.validateNotNull("member", member);
        this.getOptionalContributors().clear();
        this.getOptionalContributors().add(member);
        this.flag(16);
        return this;
    }

    @Override
    public IBuildResultSearchCriteria inQueue() {
        return this.inState(BuildState.NOT_STARTED, BuildState.IN_PROGRESS);
    }

    @Override
    public IBuildResultSearchCriteria includePersonalBuilds(boolean shouldShowPersonalBuilds) {
        this.setOptionalPersonalBuildFiltered(shouldShowPersonalBuilds);
        return this;
    }

    @Override
    public IBuildResultSearchCriteria includeMyPersonalBuilds(boolean includeMyPersonalBuilds) {
        this.setOptionalMyPersonalBuildsFiltered(includeMyPersonalBuilds);
        return this;
    }

    @Override
    public IBuildResultSearchCriteria inProcessAreas(List<? extends IProcessAreaHandle> processAreaHandles) {
        ValidationHelper.validateNotNull("processAreaHandles", processAreaHandles);
        ValidationHelper.validateNotNullElements("processAreaHandles", processAreaHandles.toArray());
        this.getOptionalProcessAreas().addAll(processAreaHandles);
        this.flag(2);
        return this;
    }

    @Override
    public IBuildResultSearchCriteria inProjectArea(IProjectAreaHandle projectAreaHandle) {
        return this.inProjectAreas(Collections.singletonList(projectAreaHandle));
    }

    @Override
    public IBuildResultSearchCriteria inProjectAreas(List<? extends IProjectAreaHandle> projectAreaHandles) {
        ValidationHelper.validateNotNull("projectAreaHandless", projectAreaHandles);
        ValidationHelper.validateNotNullElements("projectAreaHandles", projectAreaHandles.toArray());
        this.getOptionalProjectAreas().addAll(projectAreaHandles);
        this.flag(4);
        return this;
    }

    @Override
    public IBuildResultSearchCriteria withTag(String tag) {
        this.getOptionalTags().clear();
        this.getOptionalTags().add(tag);
        this.flag(8);
        return this;
    }

    private void flag(int flags) {
        this.setBuildDefinitionCriteriaFlags(this.getBuildDefinitionCriteriaFlags() | flags);
    }

    public static IBuildResultSearchCriteria builder() {
        return new BuildResultSearchCriteriaImpl(){

            private IBuildResultSearchCriteria create() {
                return new BuildResultSearchCriteriaImpl().includePersonalBuilds(true);
            }

            @Override
            public void setBuildDefinitionCriteriaFlags(int newBuildDefinitionCriteriaFlags) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setOptionalPersonalBuildFiltered(boolean newOptionalPersonalBuildFiltered) {
                throw new UnsupportedOperationException();
            }

            @Override
            public IBuildResultSearchCriteria forDefinitions(List<? extends IBuildDefinitionHandle> definitions) {
                return this.create().forDefinitions(definitions);
            }

            @Override
            public IBuildResultSearchCriteria forEngine(IBuildEngineHandle engine) {
                return this.create().forEngine(engine);
            }

            @Override
            public IBuildResultSearchCriteria inState(BuildState ... state) {
                return this.create().inState(state);
            }

            @Override
            public IBuildResultSearchCriteria withMember(IContributorHandle contributor) {
                return this.create().withMember(contributor);
            }

            @Override
            public IBuildResultSearchCriteria inQueue() {
                return this.create().inQueue();
            }

            @Override
            public IBuildResultSearchCriteria includePersonalBuilds(boolean shouldShowPersonalBuilds) {
                return this.create().includePersonalBuilds(shouldShowPersonalBuilds);
            }

            @Override
            public IBuildResultSearchCriteria inProcessAreas(List<? extends IProcessAreaHandle> processAreaHandles) {
                return this.create().inProcessAreas(processAreaHandles);
            }

            @Override
            public IBuildResultSearchCriteria inProjectArea(IProjectAreaHandle projectAreaHandle) {
                return this.create().inProjectArea(projectAreaHandle);
            }

            @Override
            public IBuildResultSearchCriteria inProjectAreas(List<? extends IProjectAreaHandle> projectAreaHandles) {
                return this.create().inProjectAreas(projectAreaHandles);
            }

            @Override
            public IBuildResultSearchCriteria withTag(String tag) {
                return this.create().withTag(tag);
            }
        };
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (buildDefinitionCriteriaFlags: ");
        if ((this.ALL_FLAGS & 1) != 0) {
            result.append(this.buildDefinitionCriteriaFlags);
        } else {
            result.append("<unset>");
        }
        result.append(", optionalPersonalBuildFiltered: ");
        if ((this.ALL_FLAGS & 4) != 0) {
            result.append((this.ALL_FLAGS & 2) != 0);
        } else {
            result.append("<unset>");
        }
        result.append(", optionalMyPersonalBuildsFiltered: ");
        if ((this.ALL_FLAGS & 0x10) != 0) {
            result.append((this.ALL_FLAGS & 8) != 0);
        } else {
            result.append("<unset>");
        }
        result.append(", optionalTags: ");
        result.append(this.optionalTags);
        result.append(", optionalBuildStates: ");
        result.append(this.optionalBuildStates);
        result.append(')');
        return result.toString();
    }
}

