/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.logging;

import com.ibm.team.build.common.logging.ILiveLogMessage;
import com.ibm.team.build.common.logging.LiveLogMessageFactory;
import com.ibm.team.build.common.logging.LiveLogTransportInterface;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class LiveLogTransportJSON
implements LiveLogTransportInterface {
    private static final String LIVE_LOG_MESSAGE = "LiveLogMessage=";
    private static final String FIELD_BUILD_RESULT_UUID = "buuid";
    private static final String FIELD_PROPERTIES = "properties";
    private static final String FIELD_LEVEL = "level";
    private static final String FIELD_MESSAGE = "message";
    private static final String FIELD_MESSAGE_ID = "messageId";
    private static final String FIELD_FORMAT = "format";
    private static final String FIELD_TIMESTAMP = "timestamp";

    @Override
    public byte[] marshal(ILiveLogMessage message) {
        return message == null ? null : LiveLogTransportJSON.marshalJSON(message).getBytes(UTF8);
    }

    @Override
    public ILiveLogMessage demarshal(byte[] message) {
        return message == null ? null : LiveLogTransportJSON.demarshalJSON(new InputStreamReader((InputStream)new ByteArrayInputStream(message), UTF8));
    }

    public static String marshalJSON(ILiveLogMessage message) {
        String result = null;
        JSONObject json = new JSONObject();
        json.put((Object)FIELD_BUILD_RESULT_UUID, (Object)message.getBuildResult().getItemId().getUuidValue());
        json.put((Object)FIELD_TIMESTAMP, (Object)message.getTimestamp());
        if (message.getMessageId() != null) {
            json.put((Object)FIELD_MESSAGE_ID, (Object)message.getMessageId());
        }
        if (message.getFormat() != null) {
            json.put((Object)FIELD_FORMAT, (Object)message.getFormat());
        }
        if (message != null) {
            json.put((Object)FIELD_MESSAGE, (Object)message.getMessage());
        }
        json.put((Object)FIELD_LEVEL, (Object)message.getLevel().toString());
        LiveLogTransportJSON.marshalJSONProperties(json, FIELD_PROPERTIES, message.getProperties());
        result = LIVE_LOG_MESSAGE + json.toString(true);
        return result;
    }

    private static void marshalJSONProperties(JSONObject parent, String string, Map<String, Object> props) {
        if (props != null && !props.isEmpty()) {
            JSONObject json = new JSONObject();
            for (String key : props.keySet()) {
                Object value = props.get(key);
                if (value instanceof Map) {
                    LiveLogTransportJSON.marshalJSONProperties(json, key, (Map)value);
                    continue;
                }
                json.put((Object)key, value);
            }
            parent.put((Object)string, (Object)json);
        }
    }

    public static ILiveLogMessage demarshalJSON(Reader marshaled) {
        ILiveLogMessage result = null;
        try {
            int i = 0;
            while (i < LIVE_LOG_MESSAGE.length()) {
                if (LIVE_LOG_MESSAGE.charAt(i) != marshaled.read()) {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
            JSONObject json = JSONObject.parse((Reader)marshaled);
            String bruuid = (String)json.get((Object)FIELD_BUILD_RESULT_UUID);
            IBuildResultHandle br = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)bruuid), null);
            result = LiveLogMessageFactory.getInstance().createLiveLogMessage(br);
            result.setTimestamp((Long)json.get((Object)FIELD_TIMESTAMP));
            result.setFormat((String)json.get((Object)FIELD_FORMAT));
            result.setMessageId((String)json.get((Object)FIELD_MESSAGE_ID));
            result.setMessage((String)json.get((Object)FIELD_MESSAGE));
            result.setLevel(ILiveLogMessage.Level.valueOf((String)json.get((Object)FIELD_LEVEL)));
            LiveLogTransportJSON.demarshalJSONProperties(result.getProperties(), (JSONObject)json.get((Object)FIELD_PROPERTIES));
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    private static void demarshalJSONProperties(Map<String, Object> props, JSONObject json) {
        if (json != null && !json.isEmpty()) {
            for (String key : json.keySet()) {
                Object value = json.get((Object)key);
                if (value != null && value instanceof JSONObject) {
                    HashMap<String, Object> nestedProps = new HashMap<String, Object>();
                    LiveLogTransportJSON.demarshalJSONProperties(nestedProps, (JSONObject)value);
                    props.put(key, nestedProps);
                    continue;
                }
                props.put(key, value);
            }
        }
    }
}

