/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.logging;

import com.ibm.team.build.common.logging.ILiveLogMessage;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.logging.LiveLogTransportJSON;
import java.util.HashMap;
import java.util.Map;

public class LiveLogMessage
implements ILiveLogMessage {
    private long timestamp = System.currentTimeMillis();
    private String messageId = "";
    private String format = null;
    private ILiveLogMessage.Level state = ILiveLogMessage.Level.INFO;
    private String message = "";
    private IBuildResultHandle fBuildResult;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public LiveLogMessage(IBuildResultHandle buildToLog, String message) {
        this(buildToLog, ILiveLogMessage.Level.INFO, message);
    }

    public LiveLogMessage(IBuildResultHandle buildToLog, ILiveLogMessage.Level state, String message) {
        this(buildToLog, state, null, message);
    }

    public LiveLogMessage(IBuildResultHandle buildToLog) {
        this(buildToLog, ILiveLogMessage.Level.INFO, null, null);
    }

    public LiveLogMessage(IBuildResultHandle buildToLog, ILiveLogMessage.Level state, String messageId, String message) {
        this.fBuildResult = buildToLog;
        this.state = state;
        this.messageId = messageId;
        this.message = message;
        this.populateContext();
    }

    @Override
    public final long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public final String getMessageId() {
        return this.messageId;
    }

    @Override
    public final String getFormat() {
        return this.format;
    }

    @Override
    public final ILiveLogMessage.Level getLevel() {
        return this.state;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String msg) {
        this.message = msg;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public void setLevel(ILiveLogMessage.Level state) {
        this.state = state;
    }

    private void populateContext() {
    }

    private void populateProperty(String string) {
        String[] tokens = string.split("/");
        Map<String, Object> map = this.properties;
        int i = 0;
        while (i < tokens.length) {
            String[] subTokens;
            String token = tokens[i];
            HashMap<String, Object> nextMap = (HashMap<String, Object>)map.get(token);
            if (nextMap == null) {
                nextMap = new HashMap<String, Object>();
                map.put(token, nextMap);
            }
            if ((subTokens = token.split("=")).length == 2) {
                String key = subTokens[0];
                String value = subTokens[1];
                nextMap.put(key, value);
            }
            map = nextMap;
            ++i;
        }
    }

    public String toString() {
        return LiveLogTransportJSON.marshalJSON(this);
    }

    protected String resolveVar(Map<String, Object> props, String var) {
        String result = (String)props.get(var);
        if (result == null) {
            for (String key : props.keySet()) {
                if (props.get(key) instanceof Map) {
                    String value = this.resolveVar((Map)props.get(key), var);
                    if (value == null) continue;
                    result = value;
                    break;
                }
                if (!key.equals(var)) continue;
                result = props.get(var).toString();
                break;
            }
        }
        return result;
    }

    public ILiveLogMessage render() {
        return this;
    }

    protected static ILiveLogMessage render(LiveLogMessage srcMsg, String message) {
        LiveLogMessage result = new LiveLogMessage(srcMsg.getBuildResult());
        if (srcMsg != null) {
            result.format = "literal";
            result.timestamp = srcMsg.timestamp;
            result.message = message;
            result.properties = null;
            result.state = srcMsg.state;
        }
        return result;
    }

    @Override
    public IBuildResultHandle getBuildResult() {
        return this.fBuildResult;
    }
}

