/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.iterator;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractItemQueryIterator<T extends IItemHandle> {
    public static Object[] EMPTY_PARAMETERS = new Object[0];
    protected IItemQuery fQuery;
    protected Object[] fQueryParams;
    protected Iterator fHandleIterator;
    private boolean bUseCommittedQuery = true;

    public AbstractItemQueryIterator() {
        this.fHandleIterator = new LinkedList().iterator();
    }

    public AbstractItemQueryIterator(IItemQuery query, Object[] queryParams) throws IllegalArgumentException {
        ValidationHelper.validateNotNull("query", query);
        ValidationHelper.validateNotNull("queryParams", queryParams);
        ValidationHelper.validateNotNullElements("queryParams", queryParams);
        this.fQuery = query;
        this.fQueryParams = queryParams;
    }

    public boolean hasNext(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        this.updatePosition(progressMonitor);
        return this.fHandleIterator.hasNext();
    }

    public T next(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        this.updatePosition(progressMonitor);
        return (T)((IItemHandle)this.fHandleIterator.next());
    }

    public List<T> next(int numHandles, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        LinkedList<T> handles = new LinkedList<T>();
        int count = 0;
        while (count < numHandles && this.hasNext(progressMonitor)) {
            handles.add(this.next(progressMonitor));
            ++count;
        }
        return handles;
    }

    public abstract int size(IProgressMonitor var1) throws TeamRepositoryException;

    public void setCommitted(boolean committed) {
        this.bUseCommittedQuery = committed;
    }

    protected abstract void updatePosition(IProgressMonitor var1) throws TeamRepositoryException;

    protected boolean hasQueryExecuted() {
        return this.fHandleIterator != null;
    }

    protected boolean isCommitted() {
        return this.bUseCommittedQuery;
    }
}

