/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.helper;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.team.build.common.model.IBuildScheduleEntry;
import java.util.Date;
import java.util.Locale;

public class BuildScheduleHelper {
    public static final TimeZone TZ_GMT = TimeZone.getTimeZone((String)"GMT");

    static {
        new BuildScheduleHelper();
    }

    private BuildScheduleHelper() {
    }

    public static TimeZone getTimeZone(IBuildScheduleEntry scheduleEntry, TimeZone defaultTimeZone) {
        TimeZone timeZone;
        String timeZoneID = scheduleEntry.getTimeZoneID();
        if (timeZoneID != null && timeZoneID.length() > 0 && timeZoneID.equals((timeZone = TimeZone.getTimeZone((String)timeZoneID)).getID())) {
            return timeZone;
        }
        return defaultTimeZone;
    }

    public static String getDays(IBuildScheduleEntry scheduleEntry) {
        return String.valueOf(scheduleEntry.isBuildOnMonday() ? "M" : "-") + (scheduleEntry.isBuildOnTuesday() ? "T" : "-") + (scheduleEntry.isBuildOnWednesday() ? "W" : "-") + (scheduleEntry.isBuildOnThursday() ? "T" : "-") + (scheduleEntry.isBuildOnFriday() ? "F" : "-") + (scheduleEntry.isBuildOnSaturday() ? "S" : "-") + (scheduleEntry.isBuildOnSunday() ? "S" : "-");
    }

    public static String getShortTimeZoneName(TimeZone timeZone, boolean ignoreDST, Locale locale) {
        DateFormat zoneFormat = DateFormat.getPatternInstance((String)(ignoreDST ? "v" : "V"), (Locale)locale);
        zoneFormat.setTimeZone(timeZone);
        return zoneFormat.format(new Date());
    }
}

