/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.events;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.common.events.BuildResultEvent;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.repository.common.IChangeEvent;

public class BuildResultChangeEvent
extends BuildResultEvent {
    public static final String KEY_OLD_BUILD_STATUS = "build.IBuildResult.status.old";
    public static final String KEY_OLD_BUILD_STATE = "build.IBuildResult.state.old";

    public BuildResultChangeEvent(IChangeEvent changeEvent, boolean isLookbackEvent) {
        super(changeEvent, isLookbackEvent);
    }

    public BuildStatus getOldBuildStatus() {
        String value = this.getChangeEvent().getStringExtension(KEY_OLD_BUILD_STATUS);
        if (value instanceof String) {
            return BuildStatus.valueOf(value);
        }
        return null;
    }

    public BuildState getOldBuildState() {
        String value = this.getChangeEvent().getStringExtension(KEY_OLD_BUILD_STATE);
        if (value instanceof String) {
            return BuildState.valueOf(value);
        }
        return null;
    }

    public boolean isStateTransition() {
        return this.getChangeEvent().getStringExtension(KEY_OLD_BUILD_STATE) != null;
    }

    public boolean isStatusTransition() {
        return this.getChangeEvent().getStringExtension(KEY_OLD_BUILD_STATUS) != null;
    }

    public static void setBuildResultChangeStateExtensions(IChangeEvent event, IBuildResult oldState, IBuildResult newState) {
        ValidationHelper.validateNotNull("event", event);
        if (newState != null) {
            if (oldState == null) {
                if (newState.getState() == BuildState.IN_PROGRESS) {
                    BuildResultChangeEvent.setStateExtension(event, KEY_OLD_BUILD_STATE, BuildState.NOT_STARTED.name());
                    if (newState.getStatus() != BuildStatus.OK) {
                        BuildResultChangeEvent.setStateExtension(event, KEY_OLD_BUILD_STATUS, BuildStatus.OK.name());
                    }
                }
            } else {
                if (oldState.getStatus() != newState.getStatus()) {
                    BuildResultChangeEvent.setStateExtension(event, KEY_OLD_BUILD_STATUS, oldState.getStatus().name());
                }
                if (oldState.getState() != newState.getState()) {
                    BuildResultChangeEvent.setStateExtension(event, KEY_OLD_BUILD_STATE, oldState.getState().name());
                }
            }
        }
    }
}

