/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.common.logging;

import com.ibm.team.build.common.logging.ILiveLogMessage;
import com.ibm.team.build.common.logging.LiveLogTransportInterface;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.logging.LiveLogMessage;
import com.ibm.team.build.internal.common.logging.LiveLogTransportJSON;
import com.ibm.team.repository.common.UUID;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LiveLogMessageFactory {
    private static final LiveLogMessageFactory INSTANCE = new LiveLogMessageFactory();
    private static final String TOPIC_PREFIX = "build/";
    private final Map<UUID, String> fBuildUuidToTopic = new ConcurrentHashMap<UUID, String>();

    public static final LiveLogMessageFactory getInstance() {
        return INSTANCE;
    }

    private LiveLogMessageFactory() {
    }

    public ILiveLogMessage createLiveLogMessage(IBuildResultHandle br) {
        LiveLogMessage message = new LiveLogMessage(br);
        return message;
    }

    public LiveLogTransportInterface getTransportInterface() {
        return new LiveLogTransportJSON();
    }

    public String generateTopicFromBuild(IBuildResultHandle buildResult) {
        String topic = this.fBuildUuidToTopic.get(buildResult.getItemId());
        if (topic == null || topic.isEmpty()) {
            topic = TOPIC_PREFIX + buildResult.getItemId().getUuidValue();
            this.fBuildUuidToTopic.put(buildResult.getItemId(), topic);
        }
        return topic;
    }

    public UUID extractBuildUuidFromTopic(String topic) {
        String uuidst = topic.substring(TOPIC_PREFIX.length());
        return UUID.valueOf((String)uuidst);
    }
}

