/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.common.logging;

import com.ibm.team.build.common.logging.Messages;
import com.ibm.team.build.common.model.IBuildResultHandle;
import java.util.Comparator;
import java.util.Map;

public interface ILiveLogMessage {
    public static final String LITERAL_FORMAT = "literal";

    public long getTimestamp();

    public String getMessageId();

    public String getFormat();

    public Level getLevel();

    public String getMessage();

    public void setMessage(String var1);

    public IBuildResultHandle getBuildResult();

    public Map<String, Object> getProperties();

    public void setTimestamp(long var1);

    public void setFormat(String var1);

    public void setMessageId(String var1);

    public void setLevel(Level var1);

    public static enum Level {
        ERROR(Messages.ILiveLogMessage_LevelERROR),
        WARNING(Messages.ILiveLogMessage_LevelWARNING),
        INFO(Messages.ILiveLogMessage_LevelINFO),
        DEBUG(Messages.ILiveLogMessage_LevelDEBUG),
        VERBOSE(Messages.ILiveLogMessage_LevelVERBOSE),
        STATUS(Messages.ILiveLogMessage_LevelSTATUS, false);

        private final String nameLiteral;
        private final boolean isUserSelectable;

        private Level(String nameLiteral) {
            this.nameLiteral = nameLiteral;
            this.isUserSelectable = true;
        }

        private Level(String nameLiteral, boolean isUserSelectable) {
            this.nameLiteral = nameLiteral;
            this.isUserSelectable = isUserSelectable;
        }

        public String getNameLiteral() {
            return this.nameLiteral;
        }

        public boolean isUserSelectable() {
            return this.isUserSelectable;
        }

        public static Level fromString(String s) {
            Level result = DEBUG;
            Level[] levelArray = Level.values();
            int n = levelArray.length;
            int n2 = 0;
            while (n2 < n) {
                Level l = levelArray[n2];
                if (l.getNameLiteral().equals(s)) {
                    result = l;
                    break;
                }
                ++n2;
            }
            return result;
        }
    }

    public static class LevelComparator
    implements Comparator<Level> {
        @Override
        public int compare(Level o1, Level o2) {
            if (o1.equals((Object)o2)) {
                return 0;
            }
            switch (o1) {
                case DEBUG: {
                    return -1;
                }
                case VERBOSE: {
                    if (o2.equals((Object)Level.DEBUG)) {
                        return 1;
                    }
                    return -1;
                }
                case INFO: {
                    if (o2.equals((Object)Level.DEBUG) || o2.equals((Object)Level.VERBOSE)) {
                        return 1;
                    }
                    return -1;
                }
                case WARNING: {
                    if (o2.equals((Object)Level.DEBUG) || o2.equals((Object)Level.VERBOSE) || o2.equals((Object)Level.INFO)) {
                        return 1;
                    }
                    return -1;
                }
                case ERROR: {
                    return 1;
                }
            }
            return 1;
        }
    }
}

