/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.common.buildengine;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.buildengine.IBuildEngineTemplate;
import com.ibm.team.build.common.model.BuildPhase;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.common.registry.BuildEngineConfigurationElementExtension;
import com.ibm.team.build.internal.common.registry.BuildEngineConfigurationElementExtensionManager;
import com.ibm.team.build.internal.common.registry.BuildEngineTemplateExtensionManager;

public class BuildEngineConfigurationRegistry {
    private static final BuildEngineConfigurationRegistry fRegistry = new BuildEngineConfigurationRegistry();

    protected BuildEngineConfigurationRegistry() {
    }

    public static BuildEngineConfigurationRegistry getInstance() {
        return fRegistry;
    }

    public IBuildEngineTemplate[] getBuildEngineTemplates() {
        return BuildEngineTemplateExtensionManager.getInstance().getBuildEngineTemplates();
    }

    public IBuildEngineTemplate getBuildEngineTemplate(String templateId) {
        return BuildEngineTemplateExtensionManager.getInstance().getBuildEngineTemplate(templateId);
    }

    public IBuildConfigurationElement[] getBuildEngineConfigurationElements() {
        BuildEngineConfigurationElementExtension[] extensions = BuildEngineConfigurationElementExtensionManager.getInstance().getBuildEngineConfigurationElements();
        IBuildConfigurationElement[] elements = new IBuildConfigurationElement[extensions.length];
        int i = 0;
        while (i < extensions.length) {
            elements[i] = this.createBuildEngineConfigurationElement(extensions[i]);
            ++i;
        }
        return elements;
    }

    public IBuildConfigurationElement getBuildEngineConfigurationElement(String elementId) {
        IBuildConfigurationElement element = null;
        BuildEngineConfigurationElementExtension extension = BuildEngineConfigurationElementExtensionManager.getInstance().getBuildEngineConfigurationElement(elementId);
        if (extension != null) {
            element = this.createBuildEngineConfigurationElement(extension);
        }
        return element;
    }

    private IBuildConfigurationElement createBuildEngineConfigurationElement(BuildEngineConfigurationElementExtension extension) {
        IConfigurationProperty[] configurationProperties;
        IBuildConfigurationElement element = BuildItemFactory.createBuildConfigurationElement();
        element.setElementId(extension.getElementIdAttribute());
        element.setName(extension.getNameAttribute());
        element.setBuildPhase(BuildPhase.UNSPECIFIED);
        element.setDescription(extension.getDescriptionAttribute());
        IConfigurationProperty[] iConfigurationPropertyArray = configurationProperties = extension.getConfigurationProperties();
        int n = configurationProperties.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationProperty property = iConfigurationPropertyArray[n2];
            element.getConfigurationProperties().add(property);
            ++n2;
        }
        return element;
    }
}

