/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.client.iterator;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.iterator.AbstractItemQueryIterator;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import org.eclipse.core.runtime.IProgressMonitor;

public final class ItemQueryIterator<T extends IItemHandle>
extends AbstractItemQueryIterator<T> {
    public static int MAX_PAGE_SIZE = 512;
    private ITeamBuildClient fBuildClient;
    private IItemQueryPage fQueryPage;
    private int fQueryPageSize;

    public ItemQueryIterator() {
        this.fQueryPage = IItemQueryPage.EMPTY_RESULT;
    }

    public ItemQueryIterator(ITeamBuildClient buildClient, IItemQuery query, Object[] queryParams) throws IllegalArgumentException {
        this(buildClient, query, queryParams, MAX_PAGE_SIZE);
    }

    public ItemQueryIterator(ITeamBuildClient buildClient, IItemQuery query, Object[] queryParams, int queryPageSize) throws IllegalArgumentException {
        super(query, queryParams);
        ValidationHelper.validateNotNull((String)"buildClient", (Object)buildClient);
        this.fQueryPageSize = queryPageSize;
        this.fBuildClient = buildClient;
    }

    public int size(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        this.updatePosition(progressMonitor);
        return this.fQueryPage.getResultSize();
    }

    protected synchronized void updatePosition(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        if (!this.hasQueryExecuted()) {
            this.fQueryPage = this.isCommitted() ? this.queryItems(this.fQuery, this.fQueryParams, this.fQueryPageSize, progressMonitor) : this.uncommittedQueryItems(this.fQuery, this.fQueryParams, this.fQueryPageSize, progressMonitor);
            this.fHandleIterator = this.fQueryPage.getItemHandles().iterator();
        }
        while (!this.fHandleIterator.hasNext() && this.fQueryPage.hasNext()) {
            this.fQueryPage = this.fetchPage(this.fQueryPage, this.fQueryPageSize, progressMonitor);
            this.fHandleIterator = this.fQueryPage.getItemHandles().iterator();
        }
    }

    private IItemQueryPage fetchPage(IItemQueryPage queryPage, int queryPageSize, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (IItemQueryPage)this.fBuildClient.fetchPage(queryPage.getToken(), queryPage.getNextStartPosition(), queryPageSize, progressMonitor);
    }

    private IItemQueryPage queryItems(IItemQuery itemQuery, Object[] queryParams, int queryPageSize, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return this.fBuildClient.queryItems(itemQuery, queryParams, queryPageSize, progressMonitor);
    }

    private IItemQueryPage uncommittedQueryItems(IItemQuery itemQuery, Object[] queryParams, int queryPageSize, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return this.fBuildClient.uncommittedQueryItems(itemQuery, queryParams, queryPageSize, progressMonitor);
    }
}

