/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.client;

import com.ibm.team.build.common.model.IBuildRequestHandle;
import com.ibm.team.build.internal.client.ITeamBuildScmClient;
import com.ibm.team.build.internal.common.ITeamBuildScmService;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IIncomingChangesResponse;
import com.ibm.team.build.internal.common.model.dto.IPostBuildDeliverResponse;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import org.eclipse.core.runtime.IProgressMonitor;

public class TeamBuildScmClient
implements ITeamBuildScmClient {
    private IClientLibraryContext clientLibraryContext;
    private static final String REQUESTHANDLEARG = "requestHandle";

    public TeamBuildScmClient(IClientLibraryContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.clientLibraryContext = context;
    }

    private ITeamBuildScmService getTeamBuildScmService() throws TeamRepositoryException {
        return (ITeamBuildScmService)this.clientLibraryContext.getServiceInterface(ITeamBuildScmService.class);
    }

    @Override
    public IIncomingChangesResponse incomingChanges(IItemHandle itemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        IRepositoryProgressMonitor progressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
        ITeamBuildScmService service = this.getTeamBuildScmService();
        return service.incomingChanges(itemHandle, (IRepositoryProgressMonitorHandle)progressMonitor);
    }

    @Override
    public IPostBuildDeliverResponse autoDeliverPostBuildParticipant(IBuildRequestHandle requestHandle, boolean ignoreTriggerPolicy, boolean verbose, IProgressMonitor monitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)REQUESTHANDLEARG, (Object)requestHandle);
        ThreadCheck.checkLongOpsAllowed();
        IRepositoryProgressMonitor progressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
        ITeamBuildScmService service = this.getTeamBuildScmService();
        return service.autoDeliverPostBuildParticipant(requestHandle, ignoreTriggerPolicy, verbose, (IRepositoryProgressMonitorHandle)progressMonitor);
    }
}

