/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.client;

import com.ibm.team.build.client.ITeamBuildRequestClient;
import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.common.TeamBuildStateException;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildRequestHandle;
import com.ibm.team.build.common.model.IBuildRequestParams;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.AbstractTeamBuildClient;
import com.ibm.team.build.internal.client.Messages;
import com.ibm.team.build.internal.common.ITeamBuildRequestService;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.advice.IItemsResponse;
import com.ibm.team.process.common.advice.IObjectsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;

public class TeamBuildRequestClient
extends AbstractTeamBuildClient
implements ITeamBuildRequestClient {
    private ITeamBuildRequestService getService() {
        return (ITeamBuildRequestService)this.getContext().getServiceInterface(ITeamBuildRequestService.class);
    }

    public TeamBuildRequestClient(IClientLibraryContext context) {
        super(context);
    }

    @Override
    public IBuildRequest getNextRequest(final IBuildEngineHandle buildEngineHandle, final String[] properties, final IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"buildEngineHandle", (Object)buildEngineHandle);
        ValidationHelper.validateNotNullElements((String)"properties", (Object[])properties);
        return (IBuildRequest)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class GetNextRequestRunnable
                extends ProcessRunnable {
                    public IBuildRequest fBuildRequest;
                    private final /* synthetic */ IBuildEngineHandle val$buildEngineHandle;
                    private final /* synthetic */ String[] val$properties;

                    GetNextRequestRunnable(IBuildEngineHandle iBuildEngineHandle, String[] stringArray) {
                        this.val$buildEngineHandle = iBuildEngineHandle;
                        this.val$properties = stringArray;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IItemsResponse response = TeamBuildRequestClient.this.getService().getNextRequest(this.val$buildEngineHandle, this.val$properties);
                        if (response.getClientItems().length > 0) {
                            this.fBuildRequest = (IBuildRequest)response.getClientItems()[0];
                        }
                        return response.getOperationReport();
                    }
                }
                GetNextRequestRunnable runnable = new GetNextRequestRunnable(buildEngineHandle, properties);
                IProcessClientService processService = (IProcessClientService)TeamBuildRequestClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.TeamBuildRequestClient_GET_NEXT_REQUEST_OPERATION_NAME, progressMonitor);
                return (IBuildRequest)TeamBuildRequestClient.this.addToItemManager((IItem)runnable.fBuildRequest);
            }
        });
    }

    @Override
    public IBuildRequest claimRequest(final IBuildRequestHandle buildRequestHandle, final IBuildEngineHandle buildEngineHandle, final String[] properties, final IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"buildRequestHandle", (Object)buildRequestHandle);
        ValidationHelper.validateNotNull((String)"buildEngineHandle", (Object)buildEngineHandle);
        ValidationHelper.validateNotNullElements((String)"properties", (Object[])properties);
        return (IBuildRequest)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class GetNextRequestRunnable
                extends ProcessRunnable {
                    public IBuildRequest fBuildRequest;
                    private final /* synthetic */ IBuildRequestHandle val$buildRequestHandle;
                    private final /* synthetic */ IBuildEngineHandle val$buildEngineHandle;
                    private final /* synthetic */ String[] val$properties;

                    GetNextRequestRunnable(IBuildRequestHandle iBuildRequestHandle, IBuildEngineHandle iBuildEngineHandle, String[] stringArray) {
                        this.val$buildRequestHandle = iBuildRequestHandle;
                        this.val$buildEngineHandle = iBuildEngineHandle;
                        this.val$properties = stringArray;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IItemsResponse response = TeamBuildRequestClient.this.getService().claimRequest(this.val$buildRequestHandle, this.val$buildEngineHandle, this.val$properties);
                        if (response.getClientItems().length > 0) {
                            this.fBuildRequest = (IBuildRequest)response.getClientItems()[0];
                        }
                        return response.getOperationReport();
                    }
                }
                GetNextRequestRunnable runnable = new GetNextRequestRunnable(buildRequestHandle, buildEngineHandle, properties);
                IProcessClientService processService = (IProcessClientService)TeamBuildRequestClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.TeamBuildRequestClient_GET_NEXT_REQUEST_OPERATION_NAME, progressMonitor);
                return (IBuildRequest)TeamBuildRequestClient.this.addToItemManager((IItem)runnable.fBuildRequest);
            }
        });
    }

    @Override
    public IBuildRequest requestBuild(IBuildDefinitionHandle buildDefinitionHandle, boolean allowDuplicateRequests, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return this.requestBuild(buildDefinitionHandle, null, null, allowDuplicateRequests, progressMonitor);
    }

    @Override
    public IBuildRequest requestBuild(IBuildDefinitionHandle buildDefinitionHandle, IBuildProperty[] buildProperties, boolean allowDuplicateRequests, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return this.requestBuild(buildDefinitionHandle, buildProperties, null, allowDuplicateRequests, progressMonitor);
    }

    @Override
    public IBuildRequest requestBuild(IBuildDefinitionHandle buildDefinitionHandle, IBuildProperty[] newOrModifiedBuildProperties, IBuildProperty[] deletedBuildProperties, boolean allowDuplicateRequests, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        return this.requestBuild(buildDefinitionHandle, newOrModifiedBuildProperties, deletedBuildProperties, allowDuplicateRequests, false, progressMonitor);
    }

    @Override
    public IBuildRequest requestBuild(final IBuildDefinitionHandle buildDefinitionHandle, final IBuildProperty[] newOrModifiedBuildProperties, final IBuildProperty[] deletedBuildProperties, final boolean allowDuplicateRequests, final boolean personalBuild, final IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"buildDefinitionHandle", (Object)buildDefinitionHandle);
        ValidationHelper.validateNotNullElements((String)"newOrModifiedBuildProperties", (Object[])newOrModifiedBuildProperties);
        ValidationHelper.validateNotNullElements((String)"deletedBuildProperties", (Object[])deletedBuildProperties);
        return (IBuildRequest)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class RequestBuildRunnable
                extends ProcessRunnable {
                    public IBuildRequest fBuildRequest;
                    private final /* synthetic */ IBuildDefinitionHandle val$buildDefinitionHandle;
                    private final /* synthetic */ IBuildProperty[] val$newOrModifiedBuildProperties;
                    private final /* synthetic */ IBuildProperty[] val$deletedBuildProperties;
                    private final /* synthetic */ boolean val$allowDuplicateRequests;
                    private final /* synthetic */ boolean val$personalBuild;

                    RequestBuildRunnable(IBuildDefinitionHandle iBuildDefinitionHandle, IBuildProperty[] iBuildPropertyArray, IBuildProperty[] iBuildPropertyArray2, boolean bl, boolean bl2) {
                        this.val$buildDefinitionHandle = iBuildDefinitionHandle;
                        this.val$newOrModifiedBuildProperties = iBuildPropertyArray;
                        this.val$deletedBuildProperties = iBuildPropertyArray2;
                        this.val$allowDuplicateRequests = bl;
                        this.val$personalBuild = bl2;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IItemsResponse response = TeamBuildRequestClient.this.getService().requestBuild(this.val$buildDefinitionHandle, this.val$newOrModifiedBuildProperties, this.val$deletedBuildProperties, this.val$allowDuplicateRequests, this.val$personalBuild);
                        this.fBuildRequest = (IBuildRequest)response.getFirstClientItem();
                        return response.getOperationReport();
                    }
                }
                RequestBuildRunnable runnable = new RequestBuildRunnable(buildDefinitionHandle, newOrModifiedBuildProperties, deletedBuildProperties, allowDuplicateRequests, personalBuild);
                IProcessClientService processService = (IProcessClientService)TeamBuildRequestClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.TeamBuildRequestClient_REQUEST_BUILD_OPERATION_NAME, progressMonitor);
                return (IBuildRequest)TeamBuildRequestClient.this.addToItemManager((IItem)runnable.fBuildRequest);
            }
        });
    }

    @Override
    public IBuildRequest requestBuild(final IBuildRequestParams params, final IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"params", (Object)params);
        return (IBuildRequest)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class RequestBuildRunnable
                extends ProcessRunnable {
                    public IBuildRequest fBuildRequest;
                    private final /* synthetic */ IBuildRequestParams val$params;

                    RequestBuildRunnable(IBuildRequestParams iBuildRequestParams) {
                        this.val$params = iBuildRequestParams;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IItemsResponse response = TeamBuildRequestClient.this.getService().requestBuild2(this.val$params);
                        this.fBuildRequest = (IBuildRequest)response.getFirstClientItem();
                        return response.getOperationReport();
                    }
                }
                RequestBuildRunnable runnable = new RequestBuildRunnable(params);
                IProcessClientService processService = (IProcessClientService)TeamBuildRequestClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.TeamBuildRequestClient_REQUEST_BUILD_OPERATION_NAME, progressMonitor);
                return (IBuildRequest)TeamBuildRequestClient.this.addToItemManager((IItem)runnable.fBuildRequest);
            }
        });
    }

    @Override
    public IBuildRequest requestAndStartBuild(final IBuildDefinitionHandle buildDefinitionHandle, final IBuildEngineHandle buildEngineHandle, final IProgressMonitor progressMonitor) throws TeamRepositoryException, TeamBuildException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"buildDefinitionHandle", (Object)buildDefinitionHandle);
        ValidationHelper.validateNotNull((String)"buildEngineHandle", (Object)buildEngineHandle);
        return (IBuildRequest)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class RequestAndStartBuildRunnable
                extends ProcessRunnable {
                    public IBuildRequest fBuildRequest;
                    private final /* synthetic */ IBuildDefinitionHandle val$buildDefinitionHandle;
                    private final /* synthetic */ IBuildEngineHandle val$buildEngineHandle;

                    RequestAndStartBuildRunnable(IBuildDefinitionHandle iBuildDefinitionHandle, IBuildEngineHandle iBuildEngineHandle) {
                        this.val$buildDefinitionHandle = iBuildDefinitionHandle;
                        this.val$buildEngineHandle = iBuildEngineHandle;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IItemsResponse response = TeamBuildRequestClient.this.getService().requestAndStartBuild(this.val$buildDefinitionHandle, this.val$buildEngineHandle);
                        this.fBuildRequest = (IBuildRequest)response.getFirstClientItem();
                        return response.getOperationReport();
                    }
                }
                RequestAndStartBuildRunnable runnable = new RequestAndStartBuildRunnable(buildDefinitionHandle, buildEngineHandle);
                IProcessClientService processService = (IProcessClientService)TeamBuildRequestClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.TeamBuildRequestClient_REQUEST_BUILD_OPERATION_NAME, progressMonitor);
                return (IBuildRequest)TeamBuildRequestClient.this.addToItemManager((IItem)runnable.fBuildRequest);
            }
        });
    }

    @Override
    public IBuildRequest cancelPendingRequest(final IBuildRequestHandle buildRequestHandle, final String[] properties, final IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"buildRequestHandle", (Object)buildRequestHandle);
        ValidationHelper.validateNotNullElements((String)"properties", (Object[])properties);
        return (IBuildRequest)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class CancelPendingRequestRunnable
                extends ProcessRunnable {
                    public IBuildRequest fCanceledRequest;
                    private final /* synthetic */ IBuildRequestHandle val$buildRequestHandle;
                    private final /* synthetic */ String[] val$properties;

                    CancelPendingRequestRunnable(IBuildRequestHandle iBuildRequestHandle, String[] stringArray) {
                        this.val$buildRequestHandle = iBuildRequestHandle;
                        this.val$properties = stringArray;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IItemsResponse response = TeamBuildRequestClient.this.getService().cancelPendingRequest(this.val$buildRequestHandle, this.val$properties);
                        this.fCanceledRequest = (IBuildRequest)response.getClientItems()[0];
                        return response.getOperationReport();
                    }
                }
                CancelPendingRequestRunnable runnable = new CancelPendingRequestRunnable(buildRequestHandle, properties);
                IProcessClientService processService = (IProcessClientService)TeamBuildRequestClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.TeamBuildRequestClient_CANCEL_BUILD_REQUEST_OPERATION_NAME, progressMonitor);
                return (IBuildRequest)TeamBuildRequestClient.this.addToItemManager((IItem)runnable.fCanceledRequest);
            }
        });
    }

    @Override
    public IBuildResult makeBuildComplete(final IBuildResultHandle buildResultHandle, final boolean buildNotNecessary, final String[] properties, final IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"buildResultHandle", (Object)buildResultHandle);
        ValidationHelper.validateNotNullElements((String)"properties", (Object[])properties);
        return (IBuildResult)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class CompleteBuildRunnable
                extends ProcessRunnable {
                    public IBuildResult fCompleteBuild;
                    private final /* synthetic */ IBuildResultHandle val$buildResultHandle;
                    private final /* synthetic */ boolean val$buildNotNecessary;
                    private final /* synthetic */ String[] val$properties;

                    CompleteBuildRunnable(IBuildResultHandle iBuildResultHandle, boolean bl, String[] stringArray) {
                        this.val$buildResultHandle = iBuildResultHandle;
                        this.val$buildNotNecessary = bl;
                        this.val$properties = stringArray;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IItemsResponse response = TeamBuildRequestClient.this.getService().makeBuildComplete(this.val$buildResultHandle, this.val$buildNotNecessary, this.val$properties);
                        if (response.getClientItems().length > 0) {
                            this.fCompleteBuild = (IBuildResult)response.getClientItems()[0];
                        }
                        return response.getOperationReport();
                    }
                }
                CompleteBuildRunnable runnable = new CompleteBuildRunnable(buildResultHandle, buildNotNecessary, properties);
                IProcessClientService processService = (IProcessClientService)TeamBuildRequestClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.TeamBuildRequestClient_COMPLETE_BUILD_OPERATION_NAME, progressMonitor);
                IBuildResult completedBuild = runnable.fCompleteBuild;
                if (completedBuild == null) {
                    TeamBuildRequestClient.this.deleteFromItemManager((IItemHandle)buildResultHandle);
                } else {
                    completedBuild = (IBuildResult)TeamBuildRequestClient.this.addToItemManager((IItem)completedBuild);
                }
                return completedBuild;
            }
        });
    }

    @Override
    public IBuildResult makeBuildCompleteWithStatus(final IBuildResultHandle buildResultHandle, final BuildStatus buildStatus, final String[] properties, final IProgressMonitor progressMonitor) throws TeamRepositoryException, TeamBuildStateException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"buildResultHandle", (Object)buildResultHandle);
        ValidationHelper.validateNotNull((String)"buildStatus", (Object)buildStatus);
        ValidationHelper.validateNotNullElements((String)"properties", (Object[])properties);
        return (IBuildResult)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class CompleteBuildRunnable
                extends ProcessRunnable {
                    public IBuildResult fCompleteBuild;
                    private final /* synthetic */ IBuildResultHandle val$buildResultHandle;
                    private final /* synthetic */ BuildStatus val$buildStatus;
                    private final /* synthetic */ String[] val$properties;

                    CompleteBuildRunnable(IBuildResultHandle iBuildResultHandle, BuildStatus buildStatus, String[] stringArray) {
                        this.val$buildResultHandle = iBuildResultHandle;
                        this.val$buildStatus = buildStatus;
                        this.val$properties = stringArray;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IItemsResponse response = TeamBuildRequestClient.this.getService().makeBuildCompleteWithStatus(this.val$buildResultHandle, this.val$buildStatus.name(), this.val$properties);
                        this.fCompleteBuild = (IBuildResult)response.getClientItems()[0];
                        return response.getOperationReport();
                    }
                }
                CompleteBuildRunnable runnable = new CompleteBuildRunnable(buildResultHandle, buildStatus, properties);
                IProcessClientService processService = (IProcessClientService)TeamBuildRequestClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.TeamBuildRequestClient_COMPLETE_BUILD_OPERATION_NAME, progressMonitor);
                IBuildResult completedBuild = runnable.fCompleteBuild;
                return (IBuildResult)TeamBuildRequestClient.this.addToItemManager((IItem)completedBuild);
            }
        });
    }

    @Override
    public IBuildResult makeBuildIncomplete(final IBuildResultHandle buildResultHandle, final String[] properties, final IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"buildResultHandle", (Object)buildResultHandle);
        ValidationHelper.validateNotNullElements((String)"properties", (Object[])properties);
        return (IBuildResult)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class AbandonBuildRunnable
                extends ProcessRunnable {
                    public IBuildResult fIncompleteBuild;
                    private final /* synthetic */ IBuildResultHandle val$buildResultHandle;
                    private final /* synthetic */ String[] val$properties;

                    AbandonBuildRunnable(IBuildResultHandle iBuildResultHandle, String[] stringArray) {
                        this.val$buildResultHandle = iBuildResultHandle;
                        this.val$properties = stringArray;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IItemsResponse response = TeamBuildRequestClient.this.getService().makeBuildIncomplete(this.val$buildResultHandle, this.val$properties);
                        this.fIncompleteBuild = (IBuildResult)response.getFirstClientItem();
                        return response.getOperationReport();
                    }
                }
                AbandonBuildRunnable runnable = new AbandonBuildRunnable(buildResultHandle, properties);
                IProcessClientService processService = (IProcessClientService)TeamBuildRequestClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.TeamBuildRequestClient_ABANDON_BUILD_OPERATION_NAME, progressMonitor);
                return (IBuildResult)TeamBuildRequestClient.this.addToItemManager((IItem)runnable.fIncompleteBuild);
            }
        });
    }

    @Override
    public IBuildRequest getNextRequest(final String buildDefinitionId, final IBuildEngineHandle buildEngineHandle, final String[] properties, final IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotEmpty((String)"buildDefinitionId", (String)buildDefinitionId);
        ValidationHelper.validateNotNull((String)"buildEngineHandle", (Object)buildEngineHandle);
        ValidationHelper.validateNotNullElements((String)"properties", (Object[])properties);
        return (IBuildRequest)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class GetNextRequestRunnable
                extends ProcessRunnable {
                    public IBuildRequest fBuildRequest;
                    private final /* synthetic */ String val$buildDefinitionId;
                    private final /* synthetic */ IBuildEngineHandle val$buildEngineHandle;
                    private final /* synthetic */ String[] val$properties;

                    GetNextRequestRunnable(String string, IBuildEngineHandle iBuildEngineHandle, String[] stringArray) {
                        this.val$buildDefinitionId = string;
                        this.val$buildEngineHandle = iBuildEngineHandle;
                        this.val$properties = stringArray;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IItemsResponse response = TeamBuildRequestClient.this.getService().getNextRequestByBuildDefinition(this.val$buildDefinitionId, this.val$buildEngineHandle, this.val$properties);
                        if (response.getClientItems().length > 0) {
                            this.fBuildRequest = (IBuildRequest)response.getClientItems()[0];
                        }
                        return response.getOperationReport();
                    }
                }
                GetNextRequestRunnable runnable = new GetNextRequestRunnable(buildDefinitionId, buildEngineHandle, properties);
                IProcessClientService processService = (IProcessClientService)TeamBuildRequestClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.TeamBuildRequestClient_GET_NEXT_REQUEST_OPERATION_NAME, progressMonitor);
                return (IBuildRequest)TeamBuildRequestClient.this.addToItemManager((IItem)runnable.fBuildRequest);
            }
        });
    }

    @Override
    public IBuildResult startBuild(final IBuildRequestHandle buildRequestHandle, final String[] properties, final IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"buildRequestHandle", (Object)buildRequestHandle);
        ValidationHelper.validateNotNullElements((String)"properties", (Object[])properties);
        return (IBuildResult)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class StartBuildRunnable
                extends ProcessRunnable {
                    public IBuildResult fStartedBuild;
                    private final /* synthetic */ IBuildRequestHandle val$buildRequestHandle;
                    private final /* synthetic */ String[] val$properties;

                    StartBuildRunnable(IBuildRequestHandle iBuildRequestHandle, String[] stringArray) {
                        this.val$buildRequestHandle = iBuildRequestHandle;
                        this.val$properties = stringArray;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IItemsResponse response = TeamBuildRequestClient.this.getService().startBuild(this.val$buildRequestHandle, this.val$properties);
                        this.fStartedBuild = (IBuildResult)response.getFirstClientItem();
                        return response.getOperationReport();
                    }
                }
                StartBuildRunnable runnable = new StartBuildRunnable(buildRequestHandle, properties);
                IProcessClientService processService = (IProcessClientService)TeamBuildRequestClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.TeamBuildRequestClient_START_BUILD_OPERATION_NAME, progressMonitor);
                return (IBuildResult)TeamBuildRequestClient.this.addToItemManager((IItem)runnable.fStartedBuild);
            }
        });
    }

    @Override
    public IBuildProperty[] getSecretsForBuildRequest(final IBuildRequestHandle buildRequestHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"buildRequestHandle", (Object)buildRequestHandle);
        return (IBuildProperty[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class GetSecretsRunnable
                extends ProcessRunnable {
                    public IBuildProperty[] secrets = new IBuildProperty[0];
                    private final /* synthetic */ IBuildRequestHandle val$buildRequestHandle;

                    GetSecretsRunnable(IBuildRequestHandle iBuildRequestHandle) {
                        this.val$buildRequestHandle = iBuildRequestHandle;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IObjectsResponse response = TeamBuildRequestClient.this.getService().getSecretsFromBuildRequest(this.val$buildRequestHandle);
                        Object[] clientObjects = response.getClientObjects();
                        this.secrets = new IBuildProperty[clientObjects.length];
                        int i = 0;
                        while (i < clientObjects.length) {
                            this.secrets[i] = (IBuildProperty)clientObjects[i];
                            ++i;
                        }
                        return response.getOperationReport();
                    }
                }
                GetSecretsRunnable runnable = new GetSecretsRunnable(buildRequestHandle);
                IProcessClientService processService = (IProcessClientService)TeamBuildRequestClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.TeamBuildRequestClient_START_BUILD_OPERATION_NAME, monitor);
                return runnable.secrets;
            }
        });
    }
}

