/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.client;

import com.ibm.team.build.client.iterator.IBuildResultRecordIterator;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildAverageData;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.AbstractTeamBuildClient;
import com.ibm.team.build.internal.client.BuildRecordEventManager;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.client.Messages;
import com.ibm.team.build.internal.client.iterator.BuildResultRecordIterator;
import com.ibm.team.build.internal.common.ITeamBuildService;
import com.ibm.team.build.internal.common.helper.TagsHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.BuildDefinitionStatusRecord;
import com.ibm.team.build.internal.common.model.dto.BuildEngineStatusRecord;
import com.ibm.team.build.internal.common.model.dto.BuildResultRecord;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.common.model.dto.IBuildEngineStatusRecord;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.common.model.dto.IBuildResultSearchCriteria;
import com.ibm.team.build.internal.common.model.dto.IBuildResultStatusTrend;
import com.ibm.team.build.internal.common.model.dto.IBuildScheduleRecord;
import com.ibm.team.build.internal.common.model.dto.IInProgressBuild;
import com.ibm.team.build.internal.common.model.dto.InProgressBuild;
import com.ibm.team.build.internal.common.model.dto.impl.BuildDefinitionStatusRecordImpl;
import com.ibm.team.build.internal.common.model.dto.impl.BuildEngineStatusRecordImpl;
import com.ibm.team.build.internal.common.model.dto.impl.BuildResultRecordImpl;
import com.ibm.team.build.internal.common.model.dto.impl.InProgressBuildImpl;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.IItemsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQueryPage;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class TeamBuildRecordClient
extends AbstractTeamBuildClient
implements ITeamBuildRecordClient {
    public TeamBuildRecordClient(IClientLibraryContext context) {
        super(context);
    }

    @Override
    public IBuildDefinitionStatusRecord[] getBuildDefinitionStatusRecords(final IBuildDefinitionHandle[] handles, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"handles", (Object[])handles);
        return (IBuildDefinitionStatusRecord[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildDefinitionStatusRecord[] records;
                IBuildDefinitionStatusRecord[] iBuildDefinitionStatusRecordArray = records = TeamBuildRecordClient.this.getService().getBuildDefinitionStatusRecordsForDefinitions(handles);
                int n = records.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildDefinitionStatusRecord record = iBuildDefinitionStatusRecordArray[n2];
                    TeamBuildRecordClient.this.processBuildDefinitionStatusRecord(record);
                    ++n2;
                }
                BuildRecordEventManager.getInstance().notifyRecordsReceived(records);
                return records;
            }
        });
    }

    @Override
    public IBuildDefinitionStatusRecord[] getBuildDefinitionStatusRecords(final String[] buildDefinitionIds, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"buildDefinitionIds", (Object[])buildDefinitionIds);
        ValidationHelper.validateNotNullElements((String)"buildDefinitionIds", (Object[])buildDefinitionIds);
        return (IBuildDefinitionStatusRecord[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildDefinitionStatusRecord[] records;
                IBuildDefinitionStatusRecord[] iBuildDefinitionStatusRecordArray = records = TeamBuildRecordClient.this.getService().getBuildDefinitionStatusRecordsById(buildDefinitionIds);
                int n = records.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildDefinitionStatusRecord record = iBuildDefinitionStatusRecordArray[n2];
                    TeamBuildRecordClient.this.processBuildDefinitionStatusRecord(record);
                    ++n2;
                }
                BuildRecordEventManager.getInstance().notifyRecordsReceived(records);
                return records;
            }
        });
    }

    @Override
    public IBuildDefinitionStatusRecord[] getBuildDefinitionStatusRecords(final IProcessAreaHandle[] processAreaHandles, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"processAreaHandles", (Object[])processAreaHandles);
        ValidationHelper.validateNotNullElements((String)"processAreaHandles", (Object[])processAreaHandles);
        return (IBuildDefinitionStatusRecord[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildDefinitionStatusRecord[] records;
                IBuildDefinitionStatusRecord[] iBuildDefinitionStatusRecordArray = records = TeamBuildRecordClient.this.getService().getBuildDefinitionStatusRecords(processAreaHandles);
                int n = records.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildDefinitionStatusRecord record = iBuildDefinitionStatusRecordArray[n2];
                    TeamBuildRecordClient.this.processBuildDefinitionStatusRecord(record);
                    ++n2;
                }
                BuildRecordEventManager.getInstance().notifyRecordsReceived(records);
                return records;
            }
        });
    }

    @Override
    public IBuildDefinitionStatusRecord[] getBuildDefinitionStatusRecords(final IContributor contributor, final IProjectAreaHandle[] connectedProjectAreas, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"contributor", (Object)contributor);
        return (IBuildDefinitionStatusRecord[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildDefinitionStatusRecord[] records;
                IBuildDefinitionStatusRecord[] iBuildDefinitionStatusRecordArray = records = TeamBuildRecordClient.this.getService().getBuildDefinitionStatusRecordsForContributor(contributor, connectedProjectAreas);
                int n = records.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildDefinitionStatusRecord record = iBuildDefinitionStatusRecordArray[n2];
                    TeamBuildRecordClient.this.processBuildDefinitionStatusRecord(record);
                    ++n2;
                }
                BuildRecordEventManager.getInstance().notifyRecordsReceived(records);
                return records;
            }
        });
    }

    @Override
    public IBuildDefinitionStatusRecord[] getBuildDefinitionStatusRecords(final IProjectAreaHandle[] projectAreas, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"projectAreas", (Object[])projectAreas);
        ValidationHelper.validateNotNullElements((String)"projectAreas", (Object[])projectAreas);
        return (IBuildDefinitionStatusRecord[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildDefinitionStatusRecord[] records;
                IBuildDefinitionStatusRecord[] iBuildDefinitionStatusRecordArray = records = TeamBuildRecordClient.this.getService().getBuildDefinitionStatusRecordsForProjectAreas(projectAreas);
                int n = records.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildDefinitionStatusRecord record = iBuildDefinitionStatusRecordArray[n2];
                    TeamBuildRecordClient.this.processBuildDefinitionStatusRecord(record);
                    ++n2;
                }
                BuildRecordEventManager.getInstance().notifyRecordsReceived(records);
                return records;
            }
        });
    }

    @Override
    public IBuildEngineStatusRecord[] getBuildEngineStatusRecords(final IProjectAreaHandle[] projectAreaHandles, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"projectAreaHandles", (Object[])projectAreaHandles);
        ValidationHelper.validateNotNullElements((String)"projectAreaHandles", (Object[])projectAreaHandles);
        return (IBuildEngineStatusRecord[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildEngineStatusRecord[] records;
                IBuildEngineStatusRecord[] iBuildEngineStatusRecordArray = records = TeamBuildRecordClient.this.getService().getBuildEngineStatusRecords(projectAreaHandles);
                int n = records.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildEngineStatusRecord record = iBuildEngineStatusRecordArray[n2];
                    TeamBuildRecordClient.this.processBuildEngineStatusRecord(record);
                    ++n2;
                }
                return records;
            }
        });
    }

    @Override
    public IBuildEngineStatusRecord getBuildEngineStatusRecord(final IBuildEngineHandle buildEngineHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"buildEngineHandle", (Object)buildEngineHandle);
        return (IBuildEngineStatusRecord)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildEngineStatusRecord record = TeamBuildRecordClient.this.getService().getBuildEngineStatusRecord(buildEngineHandle);
                TeamBuildRecordClient.this.processBuildEngineStatusRecord(record);
                return record;
            }
        });
    }

    @Override
    public IBuildResultRecord[] getBuildResultRecords(final IBuildResultHandle[] resultHandles, final String[] properties, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"resultHandles", (Object[])resultHandles);
        ValidationHelper.validateNotNullElements((String)"resultHandles", (Object[])resultHandles);
        ValidationHelper.validateNotNullElements((String)"properties", (Object[])properties);
        return (IBuildResultRecord[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildResultRecord[] records = TeamBuildRecordClient.this.getService().getBuildResultRecordsForBuildResults(resultHandles, properties);
                LinkedList<IBuildResultRecord> nonNullRecords = new LinkedList<IBuildResultRecord>();
                IBuildResultRecord[] iBuildResultRecordArray = records;
                int n = records.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildResultRecord record = iBuildResultRecordArray[n2];
                    if (record != null) {
                        TeamBuildRecordClient.this.processBuildResultRecord(record);
                        nonNullRecords.add(record);
                    }
                    ++n2;
                }
                BuildRecordEventManager.getInstance().notifyRecordsReceived(nonNullRecords.toArray(new IBuildResultRecord[nonNullRecords.size()]));
                return records;
            }
        });
    }

    @Override
    public IBuildResultRecordIterator getBuildResultRecords(final IProjectAreaHandle projectAreaHandle, final BuildState[] buildStates, final String[] properties, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"projectAreaHandle", (Object)projectAreaHandle);
        ValidationHelper.validateNotNullElements((String)"properties", (Object[])properties);
        return (IBuildResultRecordIterator)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IItemQueryPage queryPage = TeamBuildRecordClient.this.getService().getQueryPageForBuildResultsForProjectArea(projectAreaHandle, TeamBuildRecordClient.this.getBuildStateNames(buildStates));
                return new BuildResultRecordIterator(TeamBuildRecordClient.this.getRepository(), queryPage, properties);
            }
        });
    }

    @Override
    public IBuildResultRecordIterator getBuildResultRecords(final IBuildDefinitionHandle[] buildDefinitionHandles, final BuildState[] buildStates, final String[] properties, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"buildDefinitionHandles", (Object[])buildDefinitionHandles);
        ValidationHelper.validateNotNullElements((String)"buildDefinitionHandles", (Object[])buildDefinitionHandles);
        ValidationHelper.validateNotNullElements((String)"properties", (Object[])properties);
        return (IBuildResultRecordIterator)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IItemQueryPage queryPage = TeamBuildRecordClient.this.getService().getQueryPageForBuildResultsForBuildDefinitions(buildDefinitionHandles, TeamBuildRecordClient.this.getBuildStateNames(buildStates));
                return new BuildResultRecordIterator(TeamBuildRecordClient.this.getRepository(), queryPage, properties);
            }
        });
    }

    @Override
    public IBuildResultRecordIterator getBuildResultRecords(final IProcessAreaHandle[] processAreaHandles, final BuildState[] buildStates, final String[] properties, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"processAreaHandles", (Object[])processAreaHandles);
        ValidationHelper.validateNotNullElements((String)"processAreaHandles", (Object[])processAreaHandles);
        ValidationHelper.validateNotNullElements((String)"properties", (Object[])properties);
        return (IBuildResultRecordIterator)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IItemQueryPage queryPage = TeamBuildRecordClient.this.getService().getQueryPageForBuildResultsForProcessAreas(processAreaHandles, TeamBuildRecordClient.this.getBuildStateNames(buildStates));
                return new BuildResultRecordIterator(TeamBuildRecordClient.this.getRepository(), queryPage, properties);
            }
        });
    }

    @Override
    public IBuildResultRecord getBuildResultRecord(final IBuildResultHandle buildResultHandle, final String[] properties, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"buildResultHandle", (Object)buildResultHandle);
        ValidationHelper.validateNotNullElements((String)"properties", (Object[])properties);
        return (IBuildResultRecord)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildResultRecord record = TeamBuildRecordClient.this.getService().getBuildResultRecord(buildResultHandle, properties);
                TeamBuildRecordClient.this.processBuildResultRecord(record);
                BuildRecordEventManager.getInstance().notifyRecordsReceived(new IBuildResultRecord[]{record});
                return record;
            }
        });
    }

    @Override
    public IBuildResultStatusTrend getBuildResultStatusTrend(final IBuildResultHandle buildResultHandle, final int maxResultCount, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"buildResultHandle", (Object)buildResultHandle);
        return (IBuildResultStatusTrend)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return TeamBuildRecordClient.this.getService().getBuildResultStatusTrend(buildResultHandle, maxResultCount);
            }
        });
    }

    @Override
    public IBuildResultStatusTrend[] getBuildResultStatusTrends(final IBuildResultHandle buildResultHandle, final int maxResultCount, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"buildResultHandle", (Object)buildResultHandle);
        return (IBuildResultStatusTrend[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return TeamBuildRecordClient.this.getService().getBuildResultStatusTrends(buildResultHandle, maxResultCount);
            }
        });
    }

    @Override
    public IBuildResultRecordIterator getBuildResultRecords(final String tag, final IProjectAreaHandle[] projectAreaHandles, final String[] properties, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"projectAreaHandles", (Object[])projectAreaHandles);
        ValidationHelper.validateNotNullElements((String)"projectAreaHandles", (Object[])projectAreaHandles);
        ValidationHelper.validateNotEmpty((String)"tag", (String)tag);
        TagsHelper.validateOnlyOneTag((String)"tag", (String)tag);
        return (IBuildResultRecordIterator)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IItemQueryPage queryPage = TeamBuildRecordClient.this.getService().getQueryPageForBuildResultsWithTag(tag, projectAreaHandles);
                return new BuildResultRecordIterator(TeamBuildRecordClient.this.getRepository(), queryPage, properties);
            }
        });
    }

    @Override
    public IBuildResultRecordIterator getBuildResultRecords(final String tag, final IBuildDefinitionHandle[] definitionHandles, final String[] properties, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotEmpty((String)"tag", (String)tag);
        TagsHelper.validateOnlyOneTag((String)"tag", (String)tag);
        return (IBuildResultRecordIterator)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IItemQueryPage queryPage = TeamBuildRecordClient.this.getService().getQueryPageForBuildResultsWithTagForBuildDefinitions(tag, definitionHandles);
                return new BuildResultRecordIterator(TeamBuildRecordClient.this.getRepository(), queryPage, properties);
            }
        });
    }

    @Override
    public IBuildScheduleRecord[] getBuildScheduleRecords(final IBuildDefinitionHandle buildDefinitionHandle, final String[] timeZoneIDs, final Timestamp dstAdjustmentDate, IProgressMonitor progressMonitor) throws TeamRepositoryException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"buildDefinitionHandle", (Object)buildDefinitionHandle);
        ValidationHelper.validateNotEmpty((String)"timeZoneIDs", (Object[])timeZoneIDs);
        return (IBuildScheduleRecord[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return TeamBuildRecordClient.this.getService().getBuildScheduleRecords(buildDefinitionHandle, timeZoneIDs, dstAdjustmentDate);
            }
        });
    }

    @Override
    public IItem[] save(final IBuildDefinition buildDefinition, final IBuildEngineHandle[] buildEngineHandles, final int[] isSupported, final IBuildEngine[] newBuildEngines, final IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"buildDefinition", (Object)buildDefinition);
        ValidationHelper.validateNotNullElements((String)"buildEngineHandles", (Object[])buildEngineHandles);
        ValidationHelper.validateNotNull((String)"isSupported", (Object)isSupported);
        ValidationHelper.validateNotNullElements((String)"newBuildEngines", (Object[])newBuildEngines);
        return (IItem[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class SaveBuildItemsRunnable
                extends ProcessRunnable {
                    public IItem[] fSavedItems;
                    private final /* synthetic */ IBuildDefinition val$buildDefinition;
                    private final /* synthetic */ IBuildEngineHandle[] val$buildEngineHandles;
                    private final /* synthetic */ int[] val$isSupported;
                    private final /* synthetic */ IBuildEngine[] val$newBuildEngines;

                    SaveBuildItemsRunnable(IBuildDefinition iBuildDefinition, IBuildEngineHandle[] iBuildEngineHandleArray, int[] nArray, IBuildEngine[] iBuildEngineArray) {
                        this.val$buildDefinition = iBuildDefinition;
                        this.val$buildEngineHandles = iBuildEngineHandleArray;
                        this.val$isSupported = nArray;
                        this.val$newBuildEngines = iBuildEngineArray;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IItemsResponse response = TeamBuildRecordClient.this.getService(ITeamBuildService.class).saveBuildDefinition(this.val$buildDefinition, this.val$buildEngineHandles, this.val$isSupported, this.val$newBuildEngines);
                        this.fSavedItems = response.getClientItems();
                        return response.getOperationReport();
                    }
                }
                SaveBuildItemsRunnable runnable = new SaveBuildItemsRunnable(buildDefinition, buildEngineHandles, isSupported, newBuildEngines);
                IProcessClientService processService = (IProcessClientService)TeamBuildRecordClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.TeamBuildRecordClient_SAVE_BUILD_DEFINITION_PROCESS_RUNNABLE_NAME, progressMonitor);
                List savedItems = TeamBuildRecordClient.this.addToItemManager(runnable.fSavedItems, progressMonitor);
                return savedItems.toArray(new IItem[savedItems.size()]);
            }
        });
    }

    private void processBuildResultRecord(IBuildResultRecord record) throws TeamRepositoryException {
        IItem sharedItem = this.addToItemManager((IItem)((BuildResultRecord)record).getInternalBuildDefinition());
        ((BuildResultRecordImpl)record).setBuildDefinition((IBuildDefinition)sharedItem);
        ((BuildResultRecord)record).setInternalBuildDefinition(null);
        sharedItem = this.addToItemManager((IItem)((BuildResultRecord)record).getInternalBuildAverageData());
        ((BuildResultRecordImpl)record).setBuildAverageData((IBuildAverageData)sharedItem);
        ((BuildResultRecord)record).setInternalBuildDefinition(null);
        sharedItem = this.addToItemManager((IItem)((BuildResultRecord)record).getInternalBuildEngine());
        ((BuildResultRecordImpl)record).setBuildEngine((IBuildEngine)sharedItem);
        ((BuildResultRecord)record).setInternalBuildEngine(null);
        sharedItem = this.addToItemManager((IItem)((BuildResultRecord)record).getInternalBuildResult());
        ((BuildResultRecordImpl)record).setBuildResult((IBuildResult)sharedItem);
        ((BuildResultRecord)record).setInternalBuildResult(null);
        sharedItem = this.addToItemManager((IItem)((BuildResultRecord)record).getInternalRequestor());
        ((BuildResultRecordImpl)record).setRequestor((IContributor)sharedItem);
        ((BuildResultRecord)record).setInternalRequestor(null);
        List buildRequests = ((BuildResultRecord)record).getInternalBuildRequests();
        ArrayList<IBuildRequest> sharedRequests = new ArrayList<IBuildRequest>(buildRequests.size());
        for (Object object : buildRequests) {
            sharedItem = this.addToItemManager((IItem)((IBuildRequest)object));
            sharedRequests.add((IBuildRequest)sharedItem);
        }
        ((BuildResultRecordImpl)record).setBuildRequests(sharedRequests);
        ((BuildResultRecord)record).getInternalBuildRequests().clear();
    }

    private void processBuildDefinitionStatusRecord(IBuildDefinitionStatusRecord record) throws TeamRepositoryException {
        IItem sharedItem = this.addToItemManager((IItem)((BuildDefinitionStatusRecord)record).getInternalBuildDefinition());
        ((BuildDefinitionStatusRecordImpl)record).setBuildDefinition((IBuildDefinition)sharedItem);
        ((BuildDefinitionStatusRecord)record).setInternalBuildDefinition(null);
    }

    private void processBuildEngineStatusRecord(IBuildEngineStatusRecord record) throws TeamRepositoryException {
        IInProgressBuild[] inProgressBuilds;
        IItem sharedItem = this.addToItemManager((IItem)((BuildEngineStatusRecord)record).getInternalBuildEngine());
        ((BuildEngineStatusRecordImpl)record).setBuildEngine((IBuildEngine)sharedItem);
        ((BuildEngineStatusRecord)record).setInternalBuildEngine(null);
        IInProgressBuild[] iInProgressBuildArray = inProgressBuilds = record.getInProgressBuilds();
        int n = inProgressBuilds.length;
        int n2 = 0;
        while (n2 < n) {
            IInProgressBuild build = iInProgressBuildArray[n2];
            sharedItem = this.addToItemManager((IItem)((InProgressBuild)build).getInternalBuildDefinition());
            ((InProgressBuildImpl)build).setBuildDefinition((IBuildDefinition)sharedItem);
            ((InProgressBuild)build).setInternalBuildDefinition(null);
            ++n2;
        }
    }

    private String[] getBuildStateNames(BuildState[] buildStates) {
        String[] buildStateNames = null;
        if (buildStates != null && buildStates.length > 0) {
            buildStateNames = new String[buildStates.length];
            int i = 0;
            while (i < buildStates.length) {
                buildStateNames[i] = buildStates[i].name();
                ++i;
            }
        }
        return buildStateNames;
    }

    private ITeamBuildService getService() {
        return (ITeamBuildService)this.getContext().getServiceInterface(ITeamBuildService.class);
    }

    @Override
    public IBuildResultRecordIterator getBuildResultRecords(final IBuildResultSearchCriteria buildQueryCriteria, final String[] properties, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"buildQueryCriteria", (Object)buildQueryCriteria);
        return (IBuildResultRecordIterator)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IItemQueryPage queryPage = TeamBuildRecordClient.this.getService().getQueryPageForBuildResultsFromBuildQueryCriteria(buildQueryCriteria);
                return new BuildResultRecordIterator(TeamBuildRecordClient.this.getRepository(), queryPage, properties);
            }
        });
    }
}

