/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.PatternSyntaxException;

public class ProxyHelper {
    protected static final String HTTP_PROTOCOL = "http:";
    protected static final String HTTPS_PROTOCOL = "https:";
    protected static final String NONPROXYHOST_SEPARATOR = "\\|";
    protected static final String WILDCARD_CHARACTER = "*";

    public static String getProxyHost(String repositoryAddress) {
        if (ProxyHelper.isANoProxyHost(repositoryAddress)) {
            return null;
        }
        if (repositoryAddress.startsWith(HTTPS_PROTOCOL)) {
            return System.getProperty("https.proxyHost");
        }
        return System.getProperty("http.proxyHost");
    }

    public static String getProxyType(String repositoryAddress) {
        if (repositoryAddress.startsWith(HTTPS_PROTOCOL)) {
            return "https";
        }
        if (repositoryAddress.startsWith(HTTP_PROTOCOL)) {
            return "http";
        }
        return null;
    }

    public static int getProxyPort(String repositoryAddress) {
        int port = 0;
        String portString = null;
        portString = repositoryAddress.startsWith(HTTPS_PROTOCOL) ? System.getProperty("https.proxyPort", "443") : System.getProperty("http.proxyPort", "80");
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return port;
    }

    public static String getProxyUser(String repositoryAddress, String defaultUsername) {
        String proxyUser = defaultUsername;
        String propertyKey = "https.proxyUser";
        if (repositoryAddress.startsWith(HTTP_PROTOCOL)) {
            propertyKey = "http.proxyUser";
        }
        if ((proxyUser = defaultUsername != null ? System.getProperty(propertyKey, defaultUsername) : System.getProperty(propertyKey)) != null && proxyUser.length() == 0) {
            proxyUser = null;
        }
        return proxyUser;
    }

    public static String getProxyPassword(String repositoryAddress, String defaultPassword) {
        String proxyPassword = defaultPassword;
        String propertyKey = "https.proxyPassword";
        if (repositoryAddress.startsWith(HTTP_PROTOCOL)) {
            propertyKey = "http.proxyPassword";
        }
        if ((proxyPassword = defaultPassword != null ? System.getProperty(propertyKey, defaultPassword) : System.getProperty(propertyKey)) != null && proxyPassword.length() == 0) {
            proxyPassword = null;
        }
        return proxyPassword;
    }

    public static String getNoProxyHosts(String repositoryAddress) {
        String noProxyHost = null;
        noProxyHost = repositoryAddress.startsWith(HTTPS_PROTOCOL) ? System.getProperty("https.nonProxyHosts") : System.getProperty("http.nonProxyHosts");
        if (noProxyHost != null && (noProxyHost = noProxyHost.trim()).isEmpty()) {
            noProxyHost = null;
        }
        return noProxyHost;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isANoProxyHost(String repositoryAddress) {
        String[] noProxyHosts;
        String noProxyHostsStr = ProxyHelper.getNoProxyHosts(repositoryAddress);
        if (noProxyHostsStr == null) {
            return false;
        }
        URI repoURI = null;
        try {
            repoURI = new URI(repositoryAddress);
        }
        catch (URISyntaxException exp) {
            return false;
        }
        String host = repoURI.getHost();
        String[] stringArray = noProxyHosts = noProxyHostsStr.split(NONPROXYHOST_SEPARATOR);
        int n = noProxyHosts.length;
        int n2 = 0;
        while (n2 < n) {
            String noProxyHost = stringArray[n2];
            int noProxyHostLen = (noProxyHost = noProxyHost.trim()).length();
            if (noProxyHostLen != 0) {
                if (noProxyHost.contains(WILDCARD_CHARACTER)) {
                    String escapedNoProxyHost = noProxyHost.replace(".", "\\.");
                    escapedNoProxyHost = escapedNoProxyHost.replace(WILDCARD_CHARACTER, ".*");
                    try {
                        if (host.matches(escapedNoProxyHost)) {
                            return true;
                        }
                    }
                    catch (PatternSyntaxException exp) {}
                } else if ((noProxyHostLen == host.length() || noProxyHost.length() < host.length() && noProxyHost.startsWith(".")) && host.regionMatches(true, host.length() - noProxyHostLen, noProxyHost, 0, noProxyHostLen)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }
}

