/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2013. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.structure.GroupProvider"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.util.Assert"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.shared.ui.Move"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.Create"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.structure.GroupElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.model.FieldTag"); //$NON-NLS-1$

(function() {
var Assert						= com.ibm.jdojo.util.Assert;
var PlanItem					= com.ibm.team.apt.client.PlanItem;
var Move						= com.ibm.team.apt.shared.ui.Move;
var Create						= com.ibm.team.apt.shared.ui.Create;
var GroupElement				= com.ibm.team.apt.ui.structure.GroupElement;

var Progress					= com.ibm.team.apt.ui.model.FieldTag.PROGRESS;
var Duration					= com.ibm.team.apt.ui.model.FieldTag.DURATION;
var Priority					= com.ibm.team.apt.ui.model.FieldTag.PRIORITY;
var FieldTag					= com.ibm.team.apt.ui.model.FieldTag;

dojo.declare("com.ibm.team.apt.shared.ui.structure.GroupProvider", null, { //$NON-NLS-1$

	__funcGetPlan: null,
	__viewModel: null,
	__plan: null,

	constructor: function(funcGetPlan, options) {
		this.__funcGetPlan= funcGetPlan;
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	inputChanged: function(viewModel, planModel) {
		this.__viewModel= viewModel;
		this.__plan= planModel;
	},

	loadOptions: function(optionsStore) {
	},

	storeOptions: function(readAccessor) {
	},

	getEntryComparator: function() {
		return function(e1, e2, forceResort, readAccessor) {
			var element1= e1.getElement();
			var element2= e2.getElement();
			var isGroup1= element1 instanceof GroupElement;
			var isGroup2= element2 instanceof GroupElement;

			if (!isGroup1 && !isGroup2) {
				// this default implementation only compares GroupElements 
				return undefined;
			} else if (isGroup1 != isGroup2) {
				// put groups at the end of the list
				return isGroup1 - isGroup2;
			} else {
				return element1.compareTo(element2);  
			}
		};
	},

	onBeginRebuild: function() {
	},

	onEndRebuild: function() {
	},

	/**
	 * Returns the attributes required by this GroupProvider to determine the groups an element belongs to
	 */
	getDependantAttributes: function() {
		return [];
	},

	getDefaultGroupIds: function() {
		return [];
	},

	isElementIncluded: function(elementInfo) {
		return undefined;
	},

	getGroupsIds: function(elementInfo) {
		return []; 
	},

	isPrimaryGroup: function(groupIdPath, elementInfo) {
		return false; 
	},

	getGroupElement: function(groupIdPath) {
		throw new Error("getGroupElement not implemented"); //$NON-NLS-1$
	},

	getElementsToExpandInitially: function(readAccessor) {
		var rootEntry= readAccessor.getRootEntry(null);
		return rootEntry != null ? readAccessor.getChildren(rootEntry) : [];
	},

	calculateLocationMarker: function(entry, elementInfo) {
	},
	
	// ---- item move policy -----------------------------------------------------------------------------------------------
	
	canMove: function(request, readAccessor) {
		var sourceElement= request.sourceElement;

		if (sourceElement instanceof PlanItem) {
			var n= readAccessor.getEntryNavigator(true);
			
			var sourceGroup= null;
			var sourceEntry= request.sourceEntry || n.findPrimaryEntry(sourceElement);
			if (sourceEntry != null) {
				var groupEntry= n.parentEntryOfType(sourceEntry, com.ibm.team.apt.ui.structure.GroupElement);
				if (groupEntry != null) {
					sourceGroup= groupEntry.getElement();
				}
			}

			var targetGroupEntry= n.parentEntryOfType(request.targetEntry, com.ibm.team.apt.ui.structure.GroupElement);
			var targetGroup= targetGroupEntry != null ? targetGroupEntry.getElement() : null;

			if (targetGroup != null && (sourceGroup == null || !sourceGroup.equals(targetGroup))) {
				if (targetGroup.canAdopt(sourceElement, targetGroupEntry, null)) {
					return new Move.Response(request.targetEntry, request.location, {
						group: targetGroup,
						groupEntry: targetGroupEntry,
						element: sourceElement
					});
				}
			}
		}
		
		return null;
	},

	move: function(response, updateAccessor) {
		response.info.group.adopt(response.info.element, response.info.groupEntry, null);
	},
	
	canCreate: function(request, readAccessor) {
		var n= readAccessor.getEntryNavigator(true);
		var groupEntry= n.parentEntryOfType(request.targetEntry, com.ibm.team.apt.ui.structure.GroupElement);
			
		if (groupEntry != null) {
			return new Create.Response(request.targetEntry, {
				groupEntry: groupEntry
			});
		}
		return null;	
	},
	
	create: function(response, updateAccessor) {
		var groupEntry= response.info.groupEntry;
		if (groupEntry) {
			groupEntry.getElement().adopt(response.newItem, groupEntry, null);
		}
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	_getPlan: function() {
		return this.__plan;
	},

	_getViewModel: function() {
		return this.__viewModel;
	},
	

	__sentinel: null // terminates this class definition
});


})();
