/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.model.EntrySorter"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.Move"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.Create"); //$NON-NLS-1$

(function() {

var PlanItem					= com.ibm.team.apt.client.PlanItem;
var Move						= com.ibm.team.apt.shared.ui.Move;
var Create						= com.ibm.team.apt.shared.ui.Create;

dojo.declare("com.ibm.team.apt.shared.ui.model.EntrySorter", null, { //$NON-NLS-1$

	__viewModel: null,
	__plan: null,
	__comparator: null,

	constructor: function(options) {
	},

	// ---- api ------------------------------------------------------------------------------------------------------------
	
	getDependantAttributes: function() {
		return [];
	},
	
	inputChanged: function(viewModel, planModel) {
		this.__viewModel= viewModel;
		this.__plan= planModel;
	},
	
	loadOptions: function(optionsStore) {
	},

	storeOptions: function(readAccessor) {
	},

	isSorterProperty: function(property) {
		var result= false;
		var i;
		var attributes= this.getDependantAttributes();
		for(i= 0; !result && attributes && i < attributes.length; i++) {
			result|= attributes[i].getId() === property;			
		}
		return result;
	},
	
	setComparator: function(comparator) {
		this.__comparator= comparator;
	},
	
	sort: function(entries, readAccessor, forceResort) {
		var comparator= this.__comparator;
		var _self= this;
		entries.sort(function(e1, e2) {
			if (comparator) {
				var result= comparator(e1, e2, forceResort, readAccessor);
			}
			if (result != undefined && result != 0) {
				return result;
			}
			return _self._compare(e1, e2, forceResort, readAccessor);
		});
	},
	
	// ---- item move policy -----------------------------------------------------------------------------------------------
	
	canMove: function(request, readAccessor) {
		var sourceElement= request.sourceElement;
		var targetElement= request.targetEntry.getElement();

		if (sourceElement instanceof PlanItem && targetElement instanceof PlanItem && !sourceElement.equals(targetElement)) {
			if (request.location == Move.Before || request.location == Move.After) {
				return new Move.Response(request.targetEntry, request.location, {
					toMove: sourceElement,
					siblingEntry: request.targetEntry,
					location: request.location
				});
			}
		}

		return null;
	},

	move: function(response, updateAccessor) {
		var toMove= response.info.toMove;
		var siblingEntry= response.info.siblingEntry;
		var location= response.info.location;
		
		this.__doMoveWithRetry(toMove, siblingEntry, location, updateAccessor);
	},
	
	canCreate: function(request, readAccessor) {
		if (request.location == Create.Before || request.location == Create.After) {
			return new Create.Response(request.targetEntry, {
				// TODO this assumes equality on the Create and Move location values
				location: request.location
			});
		} else if (request.location == Create.Child){
			var n= readAccessor.getEntryNavigator(true);
			var children= n.childEntries(request.targetEntry);
			if (children.length == 0)
				return null;
			
			return new Create.Response(children[0], {
				// TODO this assumes equality on the Create and Move location values
				location: Create.Before
			});
		}

		return null;
	},
	
	create: function(response, updateAccessor) {		
		this.__doMoveWithRetry(response.newItem, response.targetEntry, response.info.location, updateAccessor);
	},

	// ---- spi ------------------------------------------------------------------------------------------------------------
	
	_compare: function(e1, e2, forceResort, readAccessor) {
		return e1.getOwnIndex() - e2.getOwnIndex();
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	_getPlan: function() {
		return this.__plan;
	},

	_getViewModel: function() {
		return this.__viewModel;
	},
	
	__doMoveWithRetry: function(toMove, siblingEntry, location, updateAccessor) {
		if (!this.__doMove(toMove, siblingEntry, location, updateAccessor)) {
			// see defect 70477: the deltaBuilder might still be connected, in which case we cannot see the adopted item
			// in the new group. give it a second try after updating the view model, but be very defensive -> if something changed
			// in the meantime, we just give up
			
			var viewModel= siblingEntry.getModel();
			
			var token= viewModel.addPostUpdateRunnable(dojo.hitch(this, function(updateAccessor) {
				viewModel.removePostUpdateRunnable(token);
				this.__doMove(toMove, siblingEntry, location, updateAccessor);
			}), false);
		}
	},

	__doMove: function(element, siblingEntry, location, updateAccessor) {
		var n= updateAccessor.getEntryNavigator(false);

		var groupEntry= n.parentEntryOfType(siblingEntry, com.ibm.team.apt.ui.structure.GroupElement);
		if (groupEntry == null)
			groupEntry= updateAccessor.getRootEntry(null);
		
		var entryToMove= n.findFirstEntryInSubtree(element, groupEntry);

		if (entryToMove == null)
			return false;
		
		var newIndex= n.index(siblingEntry) + (location == Move.After ? 1 : 0);
		
		if (newIndex < 0)
			newIndex= 0;
		
		var allSiblingCount= n.siblingEntries(siblingEntry).length;
		if (newIndex > allSiblingCount) 
			newIndex= allSiblingCount;

		updateAccessor.move(entryToMove, newIndex);
		return true;
	},
	
	__sentinel: null // terminates this class definition
});


})();
