/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.model.EntryFilter"); //$NON-NLS-1$

(function() {

var FilterType = {
	All: "ALL", //$NON-NLS-1$
	Regular: "REGULAR", //$NON-NLS-1$
	Post: "POST", //$NON-NLS-1$
	Transient: "TRANSIENT", //$NON-NLS-1$
	Tags: "TAGS" //$NON-NLS-1$
};

dojo.declare("com.ibm.team.apt.shared.ui.model.EntryFilter", null, { //$NON-NLS-1$

	__getPlanFn: null,

	constructor: function(getPlanFn, options) {
		this.__getPlanFn= getPlanFn;
	},
	
	getDependantAttributes: function() {
		return [];
	},
	
	// ---- api ------------------------------------------------------------------------------------------------------------

	isFilterType: function(filterType) {
		return filterType == FilterType.Regular;
	},

	isFilterProperty: function(entry, property) {
		var result= false;
		var i;
		var attributes= this.getDependantAttributes();
		for(i= 0; !result && attributes && i < attributes.length; i++) {
			result|= attributes[i].getId() === property;			
		}
		return result;
	},

	select: function(entry, readAccessor) {
		return true;
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	_getPlan: function() {
		return this.__getPlanFn();
	},

	__sentinel: null // terminates this class definition
});

com.ibm.team.apt.shared.ui.model.EntryFilter.FilterType= FilterType;

})();
