/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.structure.TreeViewMode"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.util.Assert"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanModel"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.shared.ui.Move"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.Create"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.structure.GroupElement"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.model.PrimaryLocationTag"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.structure.ViewModeTransformer"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.internal.structure.CommonViewMode"); //$NON-NLS-1$

(function() {
var Assert						= com.ibm.jdojo.util.Assert;

var PlanElement					= com.ibm.team.apt.client.PlanElement;
var PlanItem					= com.ibm.team.apt.client.PlanItem;
var PlanModel					= com.ibm.team.apt.client.PlanModel;

var Move						= com.ibm.team.apt.shared.ui.Move;
var Create						= com.ibm.team.apt.shared.ui.Create;

var GroupElement				= com.ibm.team.apt.ui.structure.GroupElement;

var ViewModeTransformer			= com.ibm.team.apt.ui.structure.ViewModeTransformer;
var CommonViewMode				= com.ibm.team.apt.shared.ui.internal.structure.CommonViewMode;
var PrimaryLocationTag 			= com.ibm.team.apt.ui.model.PrimaryLocationTag.INSTANCE;

var DeltaKind 					= ViewModeTransformer.DeltaKind;

dojo.declare("com.ibm.team.apt.shared.ui.internal.structure.TreeViewMode", CommonViewMode, { //$NON-NLS-1$

	constructor: function(funcGetPlan, groupProvider, options) {
	},

	// ---- TreeViewMode implementation ------------------------------------------------------------------------------------

	onBeginRebuild: function() {
		this.inherited(arguments);
	},

	getViewAttributes: function() {
		return this.inherited(arguments).concat( [ PlanItem.PRIMARY_ITEM ]);
	},

	_addPlanElements: function(planElements, updateAccessor) {
		// during rebuild, we own the model -> it won't be modified while we query it
		dojo.forEach(planElements, function(planElement) {
			if (this._isElementInitiallyIncluded(planElement)) {
				var path= [];
				while (planElement != null && !(planElement instanceof PlanModel)) {
					var elementInfo= this.__elementInfos[planElement.getUuid()];
					Assert.isNotNull(elementInfo);
					path.unshift(elementInfo);
					planElement= planElement.getParent();
				}

				this.__doAddElement(path, updateAccessor);
			}
		}, this);
	},

	computeDeltaKind: function(delta, readAccessor) {
		if (delta.affectsAttribute(PlanItem.PRIMARY_ITEM))
			return DeltaKind.Refresh;
		
		return this.inherited(arguments);
	},
	processPlanChanged: function(delta, updateAccessor) {
		return true;
	},

	processElementAdded: function(delta, updateAccessor) {
		this.inherited(arguments);
		this.__doAddElement(this._getElementInfoPath(delta, true), updateAccessor);
		return true;
	},

	processElementMoved: function(removeDelta, addDelta, updateAccessor) {
		this.inherited(arguments);
		this.__recomputeSubtree(removeDelta, addDelta, updateAccessor);
		return true;
	},

	processElementRemoved: function(delta, updateAccessor) {
		this.inherited(arguments);
		this.__doRemoveElement(this._getElementInfoPath(delta, false), updateAccessor);
		return true;
	},

	processElementChanged: function(delta, updateAccessor) {
		this.inherited(arguments);
		var visitChildren= true;
		var needsUpdate= false;
		
		if (delta.isContentChange()) {
			var oldElementInfo= this._getElementInfo(delta, false);
			var newElementInfo= this._getElementInfo(delta, true);
			var isStructuralChange= dojo.some(delta.getAttributeDeltas(), function(attributeDelta) {
				return !!this.__structureAttributes[attributeDelta.getAttribute().getId()];
			}, this) && !oldElementInfo.equals(newElementInfo);

			// if the primary item state changes, computeDeltaKind requested a refresh
			Assert.isTrue(newElementInfo.getValue(PlanItem.PRIMARY_ITEM) == oldElementInfo.getValue(PlanItem.PRIMARY_ITEM));

			if (!newElementInfo.getValue(PlanItem.PRIMARY_ITEM)) {
				// see defect 70414 -> recomputeSubtree fails, as there'sno primary location for auxiliary items
				isStructuralChange= false;
			}

			// TODO write down the case where we could see a certain attribute deltas,
			// but the values are not actually changed. I can't remember why the following if was required
			if (isStructuralChange) {
				this.processElementMoved(delta, delta, updateAccessor);
				visitChildren= false;
			}
			
			needsUpdate= true;
		}

		if (delta.affectsAttribute(PlanElement.PLANCHECK_REPORT)) {
			needsUpdate= true;
		}

		if (needsUpdate) {
			var updatedAttributes= dojo.map(delta.getAttributeDeltas(), function(attributeDelta) {
				return attributeDelta.getAttribute().getId();
			});
			

			dojo.forEach(updateAccessor.getElementEntries(delta.getPlanElement()), function(entry) {
				updateAccessor.update(entry, updatedAttributes);
			});
		}

		return visitChildren;
	},

	canMove: function(request, readAccessor) {
		if (request.sourceElement instanceof PlanItem && request.sourceEntry != null && !request.sourceEntry.hasTag(PrimaryLocationTag)) {
			return Move.Response.DENY;
		}

		var sourceElement= request.sourceElement;
		if (sourceElement instanceof PlanItem) {
			var n= readAccessor.getEntryNavigator(true);
			if (request.location == Move.Demote) {
				if (request.sourceEntry != null) {
					var newParentEntry= n.predecessorEntry(request.sourceEntry);
					if (newParentEntry != null && newParentEntry.getElement() instanceof PlanItem) {

						return this.__checkParentLoop(new Move.Response(request.targetEntry, request.location, {
							parent: newParentEntry.getElement(),
							child: sourceElement
						}));
					}
				}
			} else if (request.location == Move.Promote) {
				if (request.sourceEntry != null) {
					var currentParentEntry= n.parentEntry(request.sourceEntry);
					if (currentParentEntry.getElement() instanceof PlanItem) {
						var newParentEntry= n.parentEntry(currentParentEntry);
						var newParentElement= newParentEntry.getElement();
						if (!(newParentElement instanceof PlanItem))
							newParentElement= sourceElement.getPlanModel();

						// add all visible successor entries as child of the item to promote
						// do not use Array.splice as currentSiblings is a Java array on the rich client
						var siblingsToMove= [];
						var currentSiblings= n.siblings(request.sourceEntry);
						for (var i= n.index(request.sourceEntry) + 1; i < currentSiblings.length; i++) {
							siblingsToMove.push(currentSiblings[i]);
						}

						return this.__checkParentLoop(new Move.Response(request.targetEntry, request.location, {
							parent: newParentElement,
							parentEntry: newParentEntry,
							child: sourceElement,
							childTargetIndex: n.index(currentParentEntry) + 1,
							moveChildren: siblingsToMove
						}));
					}
				}
			} else {
				var targetElement= request.targetEntry.getElement();
				if (targetElement instanceof PlanItem) {
					if (request.location == Move.Child) {
						return this.__checkParentLoop(new Move.Response(request.targetEntry, request.location, {
							parent: targetElement,
							child: sourceElement
						}));
					} else if (!sourceElement.getParent().equals(targetElement.getParent())) {
						return this.__checkParentLoop(new Move.Response(request.targetEntry, request.location, {
							parent: targetElement.getParent(),
							child: sourceElement
						}));
					}
				}
			}
		}
		
		return null;
	},

	move: function(response, updateAccessor) {
		if (response.location == Move.Promote) {
			response.info.child.moveTo(response.info.parent);
			var n= updateAccessor.getEntryNavigator(true);
			var toMove= n.findFirstEntryInSubtree(response.info.child, response.info.parentEntry);
			if (toMove != null) {
				updateAccessor.move(toMove, response.info.childTargetIndex);
			}
			
			for (var i= 0; i < response.info.moveChildren.length; i++) {
				response.info.moveChildren[i].moveTo(response.info.child);
			}
		} else {
			response.info.child.moveTo(response.info.parent);
		}
	},
	
	canCreate: function(request, readAccessor) {
		var n= readAccessor.getEntryNavigator(true);
		
		var parentElement= n.parentElement(request.targetEntry);
		if (parentElement instanceof PlanItem) {
			return new Create.Response(request.targetEntry, {
				parentElement: parentElement
			});
		}
		
		return null;
	},
	
	create: function(response, updateAccessor) {
		response.newItem.moveTo(response.info.parentElement);
	},

	// ---- Implementation: Tree support  ----------------------------------------------------------------------------------
	
	__checkParentLoop: function(response) {
		
		var toCheck= response.info.child; 
		var newParent= response.info.parent;
		
		if (toCheck.equals(newParent))
			return Move.Response.DENY;
		
		while (!(newParent instanceof PlanModel)) {
			if (toCheck.equals(newParent))
				return Move.Response.DENY;
			
			newParent= newParent.getParent();
		}

		return response;
	},

	_doCalculateTags: function(groupIdPath, elementInfoPath){
		Assert.isTrue(elementInfoPath.length >= 1);
		var elementInfo= elementInfoPath[elementInfoPath.length -1];
		var isPrimary= elementInfo.getValue(PlanItem.PRIMARY_ITEM) && this.__groupProvider.isPrimaryGroup(groupIdPath, elementInfo);
		var result= isPrimary ? [ PrimaryLocationTag ] : [];
		
		var fields= this.getColumns();
		for ( var i = 0; i < fields.length; i++) {
			fields[i].setIndex(i);
		}
		result.push.apply(result, fields);
		return result;
	},

	_calculatePath: function(groupPath, groupIdPath, elementInfoPath){
		var result= [];
		result.push.apply(result, groupPath);
		for (var i= 0; i < elementInfoPath.length - 1; i++) {
			result.push(elementInfoPath[i].getPlanElement());
		}
		return result;
	},

	_getGroups : function(elementInfoPath) {
		Assert.isTrue(elementInfoPath.length >= 1);

		var includedGroups= {};
		var result= [];

		dojo.forEach(elementInfoPath, function(elementInfo) {
			if (elementInfo.getValue(PlanItem.PRIMARY_ITEM)) {
				dojo.forEach(this.__groupProvider.getGroupsIds(elementInfo), function(groupIdPath) {
					var groupId= groupIdPath.join("/"); //$NON-NLS-1$
					if (!includedGroups[groupId]) {
						result.push(groupIdPath);
						includedGroups[groupId]= true;
					}
					
				}, this);
			}
		}, this);

		return result;
	},
	

	__doAddElement: function(elementInfoPath, updateAccessor) {
		Assert.isLegal(elementInfoPath.length >= 1);
		var n= updateAccessor.getEntryNavigator(false);
		
		var element= elementInfoPath[elementInfoPath.length - 1].getPlanElement();

		var result= null;

		dojo.forEach(this._getGroups(elementInfoPath), function(groupIdPath) {
			var groupPath= this._convertToGroupElementPath(groupIdPath);
			var shouldExpandGroup= !this._isRebuilding && groupPath.length > 0 && !updateAccessor.containsElement(groupPath[groupPath.length - 1]);

			// add the entry to the model
			var newEntry= updateAccessor.addEntry(null, this._calculatePath(groupPath, groupIdPath, elementInfoPath), element);

			this.__tagEntries(newEntry, updateAccessor, groupIdPath, elementInfoPath);

			if (newEntry.hasTag(PrimaryLocationTag))
				result= newEntry;
			
			var candidateParent= newEntry;
			while (candidateParent != null && !candidateParent.isRootEntry()) {
				if (candidateParent.getElement() instanceof GroupElement) {
					// make sure all parent group gets a chance to update the count
					updateAccessor.update(candidateParent, null);
				}
				candidateParent= updateAccessor.getParent(candidateParent);
			}
			
			if (shouldExpandGroup) {
				// if the group was not yet in the model, we'll expand it automatically
				var toExpand= n.parentEntryOfType(newEntry, GroupElement);
				updateAccessor.executeAfterUpdate(dojo.hitch(this, function() {
					this.getViewModel().setEntryExpandState(toExpand, true);
				}));
			}
		}, this);
		return result;
	},
	
	__tagEntries: function(entry, updateAccessor, groupIdPath, elementInfoPath) {
		var infos= [];
		infos.push.apply(infos, elementInfoPath);
		
		var n= updateAccessor.getEntryNavigator(false);
		
		var currentEntry= entry;
		var length= infos.length;
		for ( var i = 0; i < length; i++) {
			this.__tagEntry(currentEntry, groupIdPath, infos, updateAccessor);

			infos.pop();
			if (infos.length > 0)
				currentEntry= n.parentEntry(currentEntry);
		}
	},
	
	__tagEntry: function(entry, groupIdPath, elementInfoPath, updateAccessor) {
		dojo.forEach(this._doCalculateTags(groupIdPath, elementInfoPath), function(tag){
			// 	tag the entries
			updateAccessor.setTag(entry, tag);
		}, this);
	},
	
	__doRemoveElement: function(elementInfoPath, updateAccessor) {
		Assert.isLegal(elementInfoPath.length >= 1);

		var n= updateAccessor.getEntryNavigator(false);
		var element= elementInfoPath[elementInfoPath.length - 1].getPlanElement();

		dojo.forEach(this._getGroups(elementInfoPath), function(groupIdPath) {
			var groupPath= this._convertToGroupElementPath(groupIdPath);
			var path= this._calculatePath(groupPath, groupIdPath, elementInfoPath);

			var candidateEntries= updateAccessor.getElementEntries(element);
			for (var i = 0; i < candidateEntries.length; i++) {
				var candidateEntry= candidateEntries[i];

				var pathEqual= true;
				var chainEntry= n.parentEntry(candidateEntry);
				var level= path.length - 1;
				while (pathEqual && level >= 0 && chainEntry != null) {
					pathEqual= pathEqual && (path[level--].equals(chainEntry.getElement()));
					chainEntry= n.parentEntry(chainEntry);
				}

				if (pathEqual == true && level == -1 && chainEntry.isRootEntry()) {
					
					var candidateParent= candidateEntry;
					while (candidateParent != null && !candidateParent.isRootEntry()) {
						if (candidateParent.getElement() instanceof GroupElement) {
							// make sure all parent group gets a chance to update the count
							updateAccessor.update(candidateParent, null);
						}
						candidateParent= updateAccessor.getParent(candidateParent);
					}
					
					this.__unTagEntries(candidateEntry, updateAccessor, groupIdPath, elementInfoPath);

					updateAccessor.removeEntry(candidateEntry);
					this._entryRemoved(candidateEntry, updateAccessor);
					break;
				}
			}
		}, this);
	},
	
	__unTagEntries: function(entry, updateAccessor, groupIdPath, elementInfoPath) {
		var infos= [];
		infos.push.apply(infos, elementInfoPath);
		
		var n= updateAccessor.getEntryNavigator(false);
		
		var currentEntry= entry;
		var length= infos.length;
		for ( var i = 0; i < length; i++) {
			this.__unTagEntry(currentEntry, groupIdPath, infos, updateAccessor);

			infos.pop();
			if (infos.length > 0)
				currentEntry= n.parentEntry(currentEntry);
		}
	},
	
	__unTagEntry: function(entry, groupIdPath, elementInfoPath, updateAccessor) {
		dojo.forEach(this._doCalculateTags(groupIdPath, elementInfoPath), function(tag){
			// 	untag the entries
			updateAccessor.clearTag(entry, tag);
		}, this);
	},

	
	_entryRemoved: function(entry, updateAccessor) {
	},

	__recomputeSubtree: function(oldDelta, newDelta, updateAccessor) {
		var n= updateAccessor.getEntryNavigator(false);
		var planElement= oldDelta.getPlanElement();
		var sourceEntry= n.findPrimaryEntry(planElement);
		Assert.isNotNull(sourceEntry);
		var structureSnapshot= new ModelSnapshotNode(sourceEntry, updateAccessor, this);
		
		structureSnapshot.walkSnapshot(newDelta, true, function(elementInfoPath) {
			this.__doAddElement(elementInfoPath, updateAccessor);
		}, this);

		structureSnapshot.walkSnapshot(oldDelta, false, function(elementInfoPath) {
			this.__doRemoveElement(elementInfoPath, updateAccessor);
		}, this);
	},

	__sentinel: null // terminates this class definition
});


/**
 * This helper class is used to cache the plan model structure out of the OutlineModel during
 * {@link AbstractJavaPlanModelTransformer#recomputeSubtree}. By using this helper class, w
 */

var ModelSnapshotNode= dojo.declare("com.ibm.team.apt.ui.internal.structure.TreeViewMode.ModelSnapshotNode", null, { //$NON-NLS-1$

	__modelTransformer: null,
	__isAddedExplicitly: false,
	__elementInfo: null,
	__children: null,

	constructor: function(entry, readAccessor, modelTransformer) {
		this.__modelTransformer= modelTransformer;
		this.__isAddedExplicitly= entry.isAddedExplicitly();
		this.__elementInfo= modelTransformer.__elementInfos[entry.getElement().getUuid()];
	
		var n= readAccessor.getEntryNavigator(false);
		this.__children= [];
		
		dojo.forEach(n.childEntries(entry), function(childEntry) {
			this.__children.push(new ModelSnapshotNode(childEntry, readAccessor, modelTransformer));
		}, this);
	},
	
	walkSnapshot: function(delta, newValues, visitor, thisObj) {
		Assert.isTrue(this.__elementInfo.getPlanElement().equals(delta.getPlanElement()));
		this.__accept(visitor, delta, newValues, this.__modelTransformer._getElementInfoPath(delta, newValues), thisObj);
	},

	__accept: function(visitor, delta, newValues, elementInfoPath, thisObj) {
		if (this.__isAddedExplicitly) {
			visitor.call(thisObj, elementInfoPath);
		}

		dojo.forEach(this.__children, function(childNode) {
			var childDelta= delta != null ? delta.getChild(childNode.__elementInfo.getPlanElement()) : null;
			
			var elementInfo;
			if (childDelta != null && this.__hasStructuralChange(childDelta)) {
				elementInfo= this.__modelTransformer._getElementInfo(childDelta, newValues);
			} else {
				elementInfo= childNode.__elementInfo;
			}
			
			elementInfoPath.push(elementInfo);
			childNode.__accept(visitor, childDelta, newValues, elementInfoPath, thisObj);
			elementInfoPath.pop();
		}, this);
	},

	__hasStructuralChange: function(delta) {
		var structureAttributes= this.__modelTransformer.__structureAttributes;
		for (var attributeId in structureAttributes) {
			if (delta.getAttributeDelta(structureAttributes[attributeId]))
				return true;
		}
		return false;
	},

	__sentinel: null // terminates this class definition
});

})();
 


