/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.structure.SortedViewMode"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.util.Assert"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanModel"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.shared.ui.Move"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.Create"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.structure.GroupElement"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.model.PrimaryLocationTag"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.shared.ui.internal.structure.CommonViewMode"); //$NON-NLS-1$

(function() {
var Assert						= com.ibm.jdojo.util.Assert;

var PlanElement					= com.ibm.team.apt.client.PlanElement;
var PlanItem					= com.ibm.team.apt.client.PlanItem;
var PlanModel					= com.ibm.team.apt.client.PlanModel;

var Move						= com.ibm.team.apt.shared.ui.Move;
var Create						= com.ibm.team.apt.shared.ui.Create;

var GroupElement				= com.ibm.team.apt.ui.structure.GroupElement;

var CommonViewMode				= com.ibm.team.apt.shared.ui.internal.structure.CommonViewMode;
var PrimaryLocationTag 			= com.ibm.team.apt.ui.model.PrimaryLocationTag.INSTANCE;

dojo.declare("com.ibm.team.apt.shared.ui.internal.structure.SortedViewMode", CommonViewMode, { //$NON-NLS-1$

	constructor: function(funcGetPlan, groupProvider, options) {
	},

	// ---- SortedViewMode implementation ------------------------------------------------------------------------------------

	getViewAttributes: function() {
		return this.inherited(arguments).concat( [ PlanItem.PRIMARY_ITEM ]);
	},
	
	_addPlanElements: function(planElements, updateAccessor) {
		// during rebuild, we own the model -> it won't be modified while we query it
		dojo.forEach(planElements, function(planElement) {
			if (this._isElementInitiallyIncluded(planElement)) {
				this.__doAddElement( this.__elementInfos[planElement.getUuid()], updateAccessor);
			}
		}, this);
	},

	processPlanChanged: function(delta, updateAccessor) {
		return true;
	},

	processElementAdded: function(delta, updateAccessor) {
		this.inherited(arguments);
		this.__doAddElement(this._getElementInfo(delta, true), updateAccessor);
		return true;
	},

	processElementMoved: function(removeDelta, addDelta, updateAccessor) {
		this.inherited(arguments);
		this.__doRemoveElement(this._getElementInfo(removeDelta, false), updateAccessor);
		this.__doAddElement(this._getElementInfo(addDelta, true), updateAccessor);
		return true;
	},

	processElementRemoved: function(delta, updateAccessor) {
		this.inherited(arguments);
		this.__doRemoveElement(this._getElementInfo(delta, false), updateAccessor);
		return true;
	},

	processElementChanged: function(delta, updateAccessor) {
		this.inherited(arguments);
		var visitChildren= true;
		var needsUpdate= false;
		
		if (delta.isContentChange()) {
			var isStructuralChange= dojo.some(delta.getAttributeDeltas(), function(attributeDelta) {
				return !!this.__structureAttributes[attributeDelta.getAttribute().getId()];
			}, this) && !this._getElementInfo(delta, false).equals(this._getElementInfo(delta, true));

			// TODO write down the case where we could see a certain attribute deltas,
			// but the values are not actually changed. I can't remember why the following if was required
			if (isStructuralChange) {
				this.__doAddElement(this._getElementInfo(delta, true), updateAccessor);
				this.__doRemoveElement(this._getElementInfo(delta, false), updateAccessor);
			}
			
			needsUpdate= true;
		}

		if (delta.affectsAttribute(PlanElement.PLANCHECK_REPORT)) {
			needsUpdate= true;
		}

		if (needsUpdate) {
			var updatedAttributes= dojo.map(delta.getAttributeDeltas(), function(attributeDelta) {
				return attributeDelta.getAttribute().getId();
			});
			

			dojo.forEach(updateAccessor.getElementEntries(delta.getPlanElement()), function(entry) {
				updateAccessor.update(entry, updatedAttributes);
			});
		}

		return visitChildren;
	},

	canMove: function(request, readAccessor) {
		var sourceElement= request.sourceElement;
		var targetElement= request.targetEntry.getElement();

		if (sourceElement instanceof PlanItem && targetElement instanceof PlanItem) {
			if (request.location == Move.Child) {
				return Move.Response.DENY;
			}
		}
		
		return null;
	},

	move: function(response, updateAccessor) {
	},
	
	canCreate: function(request, readAccessor) {
		if (request.targetEntry.getElement() instanceof PlanElement && request.location == Move.Child) {
			return Create.Response.DENY;
		}
		return null;
	},
	
	create: function(response, updateAccessor) {
	},


	// ---- Implementation: List support  ----------------------------------------------------------------------------------

	_doCalculateTags: function(groupIdPath, elementInfo){
		var isPrimary= elementInfo.getValue(PlanItem.PRIMARY_ITEM) && this.__groupProvider.isPrimaryGroup(groupIdPath, elementInfo);
		var result= isPrimary ? [ PrimaryLocationTag ] : [];
		
		var fields= this.getColumns();
		for ( var i = 0; i < fields.length; i++) {
			fields[i].setIndex(i);
		}
		result.push.apply(result, fields);
		return result;
	},

	_getGroups : function(elementInfo) {
		return elementInfo.getValue(PlanItem.PRIMARY_ITEM) ? this.__groupProvider.getGroupsIds(elementInfo) : [];
	},

	__doAddElement: function(elementInfo, updateAccessor) {
		var n= updateAccessor.getEntryNavigator(false);
		var result= null;

		dojo.forEach(this._getGroups(elementInfo), function(groupIdPath) {
			var groupPath= this._convertToGroupElementPath(groupIdPath);
			var shouldExpandGroup= !this._isRebuilding && groupPath.length > 0 && !updateAccessor.containsElement(groupPath[groupPath.length - 1]);

			// add the entry to the model
			var newEntry= updateAccessor.addEntry(null, groupPath, elementInfo.getPlanElement());

			dojo.forEach(this._doCalculateTags(groupIdPath, elementInfo), function(tag){
				// tag the entries
				updateAccessor.setTag(newEntry, tag);
			}, this);
			
			if (newEntry.hasTag(PrimaryLocationTag))
				result= newEntry;

			var candidateParent= newEntry;
			while (candidateParent != null && !candidateParent.isRootEntry()) {
				if (candidateParent.getElement() instanceof GroupElement) {
					// make sure all parent group gets a chance to update the count
					updateAccessor.update(candidateParent, null);
				}
				candidateParent= updateAccessor.getParent(candidateParent);
			}
			
			if (shouldExpandGroup) {
				// if the group was not yet in the model, we'll expand it automatically
				var toExpand= n.parentEntryOfType(newEntry, GroupElement);
				updateAccessor.executeAfterUpdate(dojo.hitch(this, function() {
					this.getViewModel().setEntryExpandState(toExpand, true);
				}));
			}
		}, this);
		return result;
	},

	__doRemoveElement: function(elementInfo, updateAccessor) {
		var n= updateAccessor.getEntryNavigator(false);

		dojo.forEach(this._getGroups(elementInfo), function(groupIdPath) {
			var groupPath= this._convertToGroupElementPath(groupIdPath);

			var candidateEntries= updateAccessor.getElementEntries(elementInfo.getPlanElement());
			for (var i = 0; i < candidateEntries.length; i++) {
				var candidateEntry= candidateEntries[i];

				var pathEqual= true;
				var chainEntry= n.parentEntry(candidateEntry);
				var level= groupPath.length - 1;
				while (pathEqual && level >= 0 && chainEntry != null) {
					pathEqual= pathEqual && (groupPath[level--].equals(chainEntry.getElement()));
					chainEntry= n.parentEntry(chainEntry);
				}

				if (pathEqual == true && level == -1 && chainEntry.isRootEntry()) {

					var candidateParent= candidateEntry;
					while (candidateParent != null && !candidateParent.isRootEntry()) {
						if (candidateParent.getElement() instanceof GroupElement) {
							// make sure all parent group gets a chance to update the count
							updateAccessor.update(candidateParent, null);
						}
						candidateParent= updateAccessor.getParent(candidateParent);
					}

					dojo.forEach(this._doCalculateTags(groupIdPath, elementInfo), function(tag){
						// tag the entries
						updateAccessor.clearTag(candidateEntry, tag);
					}, this);

					updateAccessor.removeEntry(candidateEntry);
					break;
				}
			}
		}, this);
	},

	__sentinel: null // terminates this class definition
});


})();
 


