/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.structure.IterationGroupProvider"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.util.Assert"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.OwnerElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.GenericElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.structure.GroupProvider"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.web.client.internal.util.Iterations"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.shared.ui.Create"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.model.PrimaryLocationTag"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.model.SecondaryLocationMarker"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.shared.ui.internal", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var Assert						= com.ibm.jdojo.util.Assert;
var PlanItem					= com.ibm.team.apt.client.PlanItem;
var GenericElement				= com.ibm.team.apt.ui.structure.GenericElement;
var GroupProvider				= com.ibm.team.apt.shared.ui.structure.GroupProvider;
var Iterations					= com.ibm.team.apt.web.client.internal.util.Iterations;
var Create						= com.ibm.team.apt.shared.ui.Create;

var SecondaryLocationMarker		= com.ibm.team.apt.ui.model.SecondaryLocationMarker;
var PrimaryLocationTag 			= com.ibm.team.apt.ui.model.PrimaryLocationTag.INSTANCE;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.shared.ui.internal", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

var ATTRIBUTE_NOT_SET= "_25Z20vj1Ed2Xy5DZdo4S0g"; //$NON-NLS-1$
var ATTRIBUTE_NOT_APPLICABLE= ATTRIBUTE_NOT_SET;

dojo.declare("com.ibm.team.apt.shared.ui.internal.structure.IterationGroupProvider", GroupProvider, { //$NON-NLS-1$

	constructor: function(funcGetPlan, options) {
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getDependantAttributes: function() {
		return [ PlanItem.TARGET ];
	},

	getDefaultGroupIds: function() {
		var root= this._getPlan().getIterationHierarchy();
		var iterations= [];
		var iter= function(node) {
			var element= node.getElement();
			if (!element.archived) {
				iterations.push(node.getElement());
			}
			dojo.forEach(node.getChildren(), iter);
		};
		iter(root);
		return dojo.map(iterations, this.__getIterationStack, this);
	},

	getGroupsIds: function(elementInfo) {
		return [ this.__getIterationStack(elementInfo.getValue(PlanItem.TARGET)) ];
	},

	isPrimaryGroup: function(groupIdPath, elementInfo) {
		Assert.isTrue(groupIdPath.length >= 1);
		return groupIdPath[groupIdPath.length - 1] == (elementInfo.getValue(PlanItem.TARGET) == null ? ATTRIBUTE_NOT_SET : elementInfo.getValue(PlanItem.TARGET).getItemId());
	},

	getGroupElement: function(groupIdPath) {
		Assert.isTrue(groupIdPath.length >= 1);
		
		var lastSegment= groupIdPath[groupIdPath.length - 1];
		if(lastSegment == ATTRIBUTE_NOT_SET){
			return new GenericElement(ATTRIBUTE_NOT_SET, Messages['iterations_other'], ATTRIBUTE_NOT_SET, { //$NON-NLS-1$
				adopt : function(planItem) {
					planItem.setAttributeValue(PlanItem.TARGET, null);
					return true;
				}});
					
		} else {
			var hierarchy= this._getPlan().getIterationHierarchy();
			var iteration= this._getPlan().getItem(lastSegment);
			return new GenericElement(iteration.getItemId(), iteration.getLabel(), iteration, {
				canAdopt: function() {
					return iteration.hasDeliverable;
				},
				adopt : function(planItem) {
					planItem.setAttributeValue(PlanItem.TARGET, iteration);
					return true;
				},
				comperator : function(o1, o2) {
					var node1= hierarchy.find(o1.getValue());
					var node2= hierarchy.find(o2.getValue());
					return node1.ordinal() - node2.ordinal(); 
				}});
		}
	},
	
	getEntryComparator: function() {
		var defaultComparator= this.inherited(arguments);

		return function(e1, e2, forceResort, readAccessor) {
			var i1= e1.getElement();
			var i2= e2.getElement();
			if (i1 instanceof GenericElement && i2 instanceof GenericElement) {
				if (i1.getValue() == ATTRIBUTE_NOT_SET || i2.getValue() == ATTRIBUTE_NOT_SET) {
					// move the "Not Applicable" folder to the end
					return (i1.getValue() == ATTRIBUTE_NOT_SET ? 1 : 0) - (i1.getValue() == ATTRIBUTE_NOT_SET ? 1 : 0);
				}
			}
			return defaultComparator(e1, e2, forceResort, readAccessor);
		};
	},
	
	calculateLocationMarker: function(entry, elementInfo) {
		if (!entry.hasTag(PrimaryLocationTag) && elementInfo != null && elementInfo.getPlanElement() instanceof PlanItem) {
			return new SecondaryLocationMarker(bind(Messages['iterations_outplace'], [ elementInfo.getValue(PlanItem.TARGET).getLabel()])); //$NON-NLS-1$
		}
		return null;
	},
	
	canCreate: function(request, readAccessor) {
		var n= readAccessor.getEntryNavigator(true);
		var groupEntry= n.parentEntryOfType(request.targetEntry, com.ibm.team.apt.ui.structure.GroupElement);

		if (groupEntry != null) {
			var groupIteration= groupEntry.getElement().getValue();
			if (groupIteration === ATTRIBUTE_NOT_SET) {
				return Create.Response.DENY;
			}

			if (!this._getPlan().canAddToIteration(request.workItemType, groupIteration)) {
				return Create.Response.DENY;
			}
		}
		
		return this.inherited(arguments);
	},
	
	// ---- implementation -------------------------------------------------------------------------------------------------
	
	__getIterationStack: function(target){
		if (target == null){
			return [ ATTRIBUTE_NOT_SET ];
		} else {
			var hierarchy= this._getPlan().getIterationHierarchy();
			var node= hierarchy.find(target);
			var result= [];
			while (node != null) {
				result.unshift(node.getElement().getItemId());
				node= node.getParent();
			}
			if(result.length == 0) {
				return [ ATTRIBUTE_NOT_APPLICABLE ];
			} else {
				return result;
			}
		}
	},
	
	__sentinel: null // terminates this class definition
});

})();



