/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.structure.FolderGroupProvider"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.util.Assert"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.common.AttributeDescription"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.SyntheticAttribute"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeType"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.Move"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.FolderElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.structure.GroupProvider"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.model.PrimaryLocationTag"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.model.SecondaryLocationMarker"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.shared.ui.internal", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var Assert						= com.ibm.jdojo.util.Assert;
var AttributeDescription		= com.ibm.team.apt.common.AttributeDescription;
var PlanItem					= com.ibm.team.apt.client.PlanItem;
var SyntheticAttribute			= com.ibm.team.apt.client.SyntheticAttribute;
var PlanningAttributeType		= com.ibm.team.apt.client.PlanningAttributeType;

var Move						= com.ibm.team.apt.shared.ui.Move;
var FolderElement				= com.ibm.team.apt.ui.structure.FolderElement;
var GroupProvider				= com.ibm.team.apt.shared.ui.structure.GroupProvider;

var SecondaryLocationMarker		= com.ibm.team.apt.ui.model.SecondaryLocationMarker;
var PrimaryLocationTag 			= com.ibm.team.apt.ui.model.PrimaryLocationTag.INSTANCE;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.shared.ui.internal", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

var TOPITEMS_FOLDER_ID= "_4zeBgNZHEdyw0aNSmwtbxQ"; //$NON-NLS-1$
var DEFECTS_FOLDER_ID= "_82-6QNZHEdyw0aNSmwtbxQ"; //$NON-NLS-1$

dojo.declare("com.ibm.team.apt.shared.ui.internal.structure.FolderGroupProvider", GroupProvider, { //$NON-NLS-1$

	__optionsStore: null,
	__folders: null,
	__mapping: null,

	constructor: function(funcGetPlan, options) {
		var attributeDescriptor= AttributeDescription.create("__NzvtcUxEd2GwsDsJ8fl7g", "UUID", null); //$NON-NLS-1$ //$NON-NLS-2$

		// TODO append planModeId to SyntheticAttribute's id to ensure that the attribute is unique  
		this.__idAttribute= new SyntheticAttribute(attributeDescriptor, function(receiver) {
			return this.__mapping[receiver.getUuid()] || DEFECTS_FOLDER_ID;
		}, function(receiver, value) {
			this.__mapping[receiver.getUuid()]= value;
			this.__optionsStore.markDirty();
		}, PlanItem, this);
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getDependantAttributes: function() {
		return [ this.__idAttribute ];
	},

	onBeginRebuild: function() {
		this._getPlan().accept(function(planElement) {
			if (planElement instanceof PlanItem) {
				// __computeFolderId respects currently assigned folders
				this.__mapping[planElement.getUuid()]= this.__computeFolderId(planElement);
			}
			return true;
		}, this);
	},

	getEntryComparator: function() {
		var defaultComparator= this.inherited(arguments);

		return function(e1, e2, forceResort, readAccessor) {
			var i1= e1.getElement();
			var i2= e2.getElement();
			if (!forceResort && i1 instanceof FolderElement && i2 instanceof FolderElement) {
				// do not enforce sort order for folder elements -> this allows moving them
				return undefined;
			}
			return defaultComparator(e1, e2, forceResort, readAccessor);
		};
	},

	loadOptions: function(optionsStore) {
		this.__optionsStore= optionsStore;
		
		var contents= optionsStore.load();
		this.__folders= contents.folders;
		if (!this.__folders) {
			this.__folders= {};
			this.__addFolder(TOPITEMS_FOLDER_ID, Messages['folders_topItems'], 1, null); //$NON-NLS-1$
			this.__addFolder(DEFECTS_FOLDER_ID,  Messages['folders_defects'], 2, null); //$NON-NLS-1$
		}
		this.__mapping= contents.mapping || {};
	},
	
	storeOptions: function(readAccessor) {
		var index= 1;
		readAccessor.accept(dojo.hitch(this, function(entry) {
			var element= entry.getElement();
			if (element instanceof FolderElement) {
				var folder= this.__folders[element.getId()];
				if (folder) {
					folder.index= index++;
				}
				return true;
			}
			return !(element instanceof PlanItem);
		}), null);

		this.__optionsStore.store({
			folders: this.__folders,
			mapping: this.__mapping
		});
	},

	getDefaultGroupIds: function() {
		var result= [];
		for (var folderId in this.__folders) {
			result.push(this.__getFolderStack(folderId));

		}
		return result;
	},

	getGroupsIds: function(elementInfo) {
		var folderId= elementInfo.getValue(this.__idAttribute);
		if (folderId && ! this.__folders[folderId]) {
			folderId= null;
		}
		
		return [ this.__getFolderStack(folderId || DEFECTS_FOLDER_ID) ]; // XXX
	},

	isPrimaryGroup: function(groupIdPath, elementInfo) {
		Assert.isTrue(groupIdPath.length >= 1);
		return groupIdPath[groupIdPath.length - 1] == elementInfo.getValue(this.__idAttribute);
	},

	getGroupElement: function(groupIdPath) {
		Assert.isTrue(groupIdPath.length >= 1);
		var folder= this.__folders[groupIdPath[groupIdPath.length - 1]];
		return new FolderElement(folder.id, folder.label, folder, {
			adopt : dojo.hitch(this, function(planItem) {
				planItem.setAttributeValue(this.__idAttribute, folder.id);
				return true;
			}),
			label: function() {
				return folder.label;
			},
			comperator : function(o1, o2) {
				return o1.getValue().index - o2.getValue().index;
			}}, folder.id == TOPITEMS_FOLDER_ID || folder.id == DEFECTS_FOLDER_ID);
	},
	
	calculateLocationMarker: function(entry, elementInfo) {
		var element= entry.getElement();
		if (element instanceof PlanItem && !entry.hasTag(PrimaryLocationTag)) {
			var folder= this.__folders[this.__mapping[element.getUuid()]];
			return new SecondaryLocationMarker(bind(Messages['folders_outplace'], [folder && folder.label || Messages['folders_nameUnknown']])); //$NON-NLS-1$ //$NON-NLS-2$
		}
		return null;
	},

	canMove: function(request, readAccessor) {
		var sourceElement= request.sourceElement;
		if (sourceElement instanceof FolderElement) {
			if (request.sourceEntry != null) {
				var n= readAccessor.getFilterEntryNavigator(function(entry) { return entry.isVisible() && entry.getElement() instanceof FolderElement; });
				if (request.location == Move.Demote) {
					var newParentFolderEntry= n.predecessorEntry(request.sourceEntry);
					if (newParentFolderEntry != null) {

						return this.__checkParentLoop(new Move.Response(request.targetEntry, request.location, {
							parentFolderId: newParentFolderEntry.getElement().getId(),
							parentFolderEntry: newParentFolderEntry,
							childFolderEntry: request.sourceEntry
						}), readAccessor);
					}
				} else if (request.location == Move.Promote) {
					if (request.sourceEntry != null) {
						var currentParentEntry= n.parentEntry(request.sourceEntry);
						if (currentParentEntry.getElement() instanceof FolderElement) {
							var newParentFolderEntry= n.parentEntry(currentParentEntry);
							var newParentFolder= newParentFolderEntry.getElement();
							var newParentFolderId= newParentFolder instanceof FolderElement ? newParentFolder.getId() : null;

							// add all visible successor entries as child of the item to promote
							// do not use Array.splice as currentSiblings is a Java array on the rich client
							var siblingFolderEntriesToMove= [];
							var currentSiblingEntries= n.siblingEntries(request.sourceEntry);
							for (var i= n.index(request.sourceEntry) + 1; i < currentSiblingEntries.length; i++) {
								siblingFolderEntriesToMove.push(currentSiblingEntries[i]);
							}

							return this.__checkParentLoop(new Move.Response(request.targetEntry, request.location, {
								parentFolderId: newParentFolderId,
								parentFolderEntry: newParentFolderId ? newParentFolderEntry : null,
								childFolderEntry: request.sourceEntry,
								childTargetIndex: currentParentEntry.getOwnIndex() + 1,
								siblingFolderEntries: siblingFolderEntriesToMove
							}), readAccessor);
						}
					}
				} else {
					var targetElement= request.targetEntry.getElement();
					if (targetElement instanceof FolderElement) {
						
						var newParentFolderEntry= null;
						var newParentFolder= null;

						var moveInfo= {};
						if (request.location == Move.Child) {
							newParentFolder= request.targetEntry.getElement();
							newParentFolderEntry= request.targetEntry;
							moveInfo['childFolderEntry']= request.sourceEntry; //$NON-NLS-1$
							moveInfo['parentFolderId']= newParentFolder.getId(); //$NON-NLS-1$
						} else if (request.location == Move.Before || request.location == Move.After) {
							var newParentEntry= n.parentEntry(request.targetEntry);
							var currentParentEntry= n.parentEntry(request.sourceEntry);

							moveInfo['childFolderEntry']= request.sourceEntry; //$NON-NLS-1$
							if (newParentEntry != currentParentEntry) {
								
								if (newParentEntry.isRootEntry()) {
									moveInfo['parentFolderId']= null; //$NON-NLS-1$
								} else if (newParentEntry.getElement() instanceof FolderElement) {
									moveInfo['parentFolderId']= newParentEntry.getElement().getId(); //$NON-NLS-1$
									newParentFolderEntry= newParentEntry;
								}
							} 
							
							var newIndex= request.targetEntry.getOwnIndex();
							if (request.location == Move.After)
								newIndex+= 1;

							moveInfo['childTargetIndex']= newIndex; //$NON-NLS-1$
						}
						moveInfo.parentFolderEntry= newParentFolderEntry;
						return this.__checkParentLoop(new Move.Response(request.targetEntry, request.location, moveInfo), readAccessor);
					}
				}
			}
		} else {
			var superResponse= this.inherited(arguments);
			if (superResponse != null) {
				if (superResponse == Move.Response.DENY)
					return Move.Response.DENY;
				
				return new Move.Response(request.targetEntry, request.location, {
					superResponse: superResponse
				});
			}
		}
		
		return null;
	},

	move: function(response, updateAccessor) {
		if (response.info.superResponse != null) {
			this.inherited("move", arguments, [response.info.superResponse, updateAccessor]); //$NON-NLS-1$
		} else {
			var moveFolderEntry= response.info.childFolderEntry;
			var moveFolder= moveFolderEntry.getElement();
			
			if (response.info.parentFolderId !== undefined) {
				var parentPath= response.info.parentFolderId != null ? this.__getFolderPath(response.info.parentFolderId) : [];
				this.__reparentFolder(moveFolder.getId(), response.info.parentFolderId);
				moveFolderEntry= updateAccessor.reparentEntry(moveFolderEntry, parentPath);
				
				if (response.info.moveChildren) {
					var movedFolderPath= this.__getFolderPath(moveFolder.getId);
					for (var i= 0; i < response.info.moveChildren.length; i++) {
						var siblingFolderEntry= response.info.siblingFolderEntries[i];
						this.__reparentFolder(siblingFolderEntries.getElement().getId(), moveFolder.getId());
						updateAccessor.reparentEntry(siblingFolderEntries, movedFolderPath);
					}
					
					
				}
			}
			
			if (response.info.childTargetIndex !== undefined) {
				updateAccessor.move(moveFolderEntry, response.info.childTargetIndex);
			}
		}
	},

	
	// ---- implementation -------------------------------------------------------------------------------------------------

	__checkParentLoop: function(response, readAccessor) {
		var toCheck= response.info.childFolderEntry; 
		var newParent= response.info.parentFolderEntry;
		
		if (toCheck && newParent) {
			if (toCheck.getElement().equals(newParent.getElement()))
				return Move.Response.DENY;
			
			while (newParent != null) {
				if (toCheck.getElement().equals(newParent.getElement()))
					return Move.Response.DENY;
				
				newParent= readAccessor.getParent(newParent);
			}
		}
		return response;
	},

	
	__addFolder: function(id, label, index, parentId) {
		return this.__folders[id]= { label: label, id: id, index: index, parentId: parentId || null};
	},
	
	__getFolderStack: function(folderId) {
		var result= [];
		while (folderId) {
			result.unshift(folderId);
			var folder= this.__folders[folderId];
			folderId= (folder && folder.parentId);
		}
		return result;
	},
	
	__computeFolderId: function(item) {
		var defaultFolderId= DEFECTS_FOLDER_ID;
		var current= item;
		while(current instanceof PlanItem) {
			var folderId= this.__mapping[current.getUuid()];
			if (folderId && this.__folders[folderId]) {
				return folderId;
			} else if (current.isTopLevelPlanItem()) {
				defaultFolderId= TOPITEMS_FOLDER_ID;
			}
			current= current.getParent();
		}
		return defaultFolderId;
	},
	
	// ---- MyFolderItemMovePolicy API for 2.0 M1 --------------------------------------------------------------------------

	__getFolderAttribute: function() {
		return this.__idAttribute;
	},
	
	__createFolderEntry: function(id, label, index, parentId, updateAccessor) {
		this.__addFolder(id, label, index, parentId);
		var folderElements= this.__getFolderPath(id);
		return updateAccessor.addEntry(null, folderElements.slice(0, folderElements.length - 1), folderElements[folderElements.length - 1]);
		this.__optionsStore.markDirty();
	},
	
	__getBugsFolder: function() {
		return this.getGroupElement(this.__getFolderStack(DEFECTS_FOLDER_ID));
	},
	
	__renameFolder: function(folderId, newName) {
		this.__folders[folderId].label= newName;
		this.__optionsStore.markDirty();
	},

	__deleteFolder: function(folderId) {
		delete this.__folders[folderId];
		for (var candidateFolderId in this.__folders) {
			if (this.__folders[candidateFolderId].parentId == folderId) {
				this.__deleteFolder(candidateFolderId);
			}
		}
		this.__optionsStore.markDirty();
	},

	__reparentFolder: function(folderId, newParentFolderId) {
		this.__folders[folderId].parentId= newParentFolderId;
		this.__optionsStore.markDirty();
	},

	__getFolderPath: function(folderId) {
		var groupIdPath= this.__getFolderStack(folderId);

		var result= [];
		for (var i= 1; i <= groupIdPath.length; i++) {
			result.push(this.getGroupElement(groupIdPath.slice(0, i)));
		}
		return result;
	},

	__sentinel: null // terminates this class definition
});

})();



