/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.structure.EnumerationGroupProvider"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.util.Assert"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeIdentifier"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.GenericElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.structure.GroupProvider"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.model.PrimaryLocationTag"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.model.SecondaryLocationMarker"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.shared.ui.internal", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var Assert						= com.ibm.jdojo.util.Assert;
var PlanItem					= com.ibm.team.apt.client.PlanItem;
var GroupElement				= com.ibm.team.apt.ui.structure.GenericElement;
var GenericElement				= com.ibm.team.apt.ui.structure.GenericElement;
var GroupProvider				= com.ibm.team.apt.shared.ui.structure.GroupProvider;

var SecondaryLocationMarker		= com.ibm.team.apt.ui.model.SecondaryLocationMarker;
var PrimaryLocationTag 			= com.ibm.team.apt.ui.model.PrimaryLocationTag.INSTANCE;

var PlanningAttributeIdentifier	= com.ibm.team.apt.client.PlanningAttributeIdentifier;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.shared.ui.internal", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

var ATTRIBUTE_NOT_SET= "_25Z20vj1Ed2Xy5DZdo4S0g"; //$NON-NLS-1$

function createComparator(ascending) {
	var direction= ascending ? 1 : -1;
	return function(o1, o2) {
		var v1= o1.getValue();
		var v2= o2.getValue();
		if (v1 == undefined || v2 == undefined) {
			// move the "Not Applicable" folder to the end
			return (v1 == undefined ? 1 : 0) - (v1 == undefined ? 1 : 0);
		}

		return v1.compareTo(v2) * direction;
	};
};

dojo.declare("com.ibm.team.apt.shared.ui.internal.structure.EnumerationGroupProvider", GroupProvider, { //$NON-NLS-1$

	__attributeId: null,
	__enumerationAttribute: null,
	__comparator: null,
	
	constructor: function(funcGetPlan, options) {
		this.__attributeId= new PlanningAttributeIdentifier(options.getParameter("attribute")); //$NON-NLS-1$
		this.__comparator= createComparator((options.getParameter("sortorder") || "ascending") != "descending"); //$NON-NLS-1$
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getDependantAttributes: function() {
		return [ this.__attributeId ];
	},

	onBeginRebuild: function() {
		this.__enumerationAttribute= this._getPlan().findAttribute(this.__attributeId);
	},

	getEntryComparator: function() {
		var defaultComparator= this.inherited(arguments);

		return function(e1, e2, forceResort, readAccessor) {
			var i1= e1.getElement();
			var i2= e2.getElement();
			if (i1 instanceof GroupElement && i2 instanceof GroupElement) {
				if (i1.getId() == ATTRIBUTE_NOT_SET || i2.getId() == ATTRIBUTE_NOT_SET) {
					// move the "Not Applicable" folder to the end
					return (i1.getId() == ATTRIBUTE_NOT_SET ? 1 : 0) - (i2.getId() == ATTRIBUTE_NOT_SET ? 1 : 0);
				}
			}
			return defaultComparator(e1, e2, forceResort, readAccessor);
		};
	},

	getDefaultGroupIds: function() {
		var result= dojo.map( this.__enumerationAttribute.getValueSet().getValues(), function(value) { return [ value.getItemId() ]; } );
		return result;
	},

	getGroupsIds: function(elementInfo) {
		return [ [ this.__getValueId(elementInfo) ] ];
	},

	isPrimaryGroup: function(groupIdPath, elementInfo) {
		Assert.isTrue(groupIdPath.length >= 1);
		return groupIdPath[groupIdPath.length - 1] == this.__getValueId(elementInfo);
	},

	getGroupElement: function(groupIdPath) {
		Assert.isTrue(groupIdPath.length >= 1);

		if (groupIdPath[groupIdPath.length - 1] == ATTRIBUTE_NOT_SET) {
			return new GenericElement(ATTRIBUTE_NOT_SET, Messages['enum_groupNotApplicable'], undefined, { //$NON-NLS-1$
				comperator: this.__comparator
			});
		} else {
			var id= groupIdPath[groupIdPath.length - 1];
			var value= this.__enumerationAttribute.getValueSet().byId(id);
			var label= value != null ? value.getLabel() : id;
			
			return new GenericElement(id, label, value, {
				adopt: dojo.hitch(this, function(planItem) {
					planItem.setAttributeValue(this.__enumerationAttribute, value);
					return true;
				}),
				canAdopt: dojo.hitch(this, function(planItem) {
					return value != null;
				}),
				comperator: this.__comparator
			});
		}
	},
	
	calculateLocationMarker: function(entry, elementInfo) {
		if (!entry.hasTag(PrimaryLocationTag) && elementInfo != null && elementInfo.getPlanElement() instanceof PlanItem) {
			var attributeValue=elementInfo.getValue(this.__enumerationAttribute);
			if (attributeValue != undefined) {
				return new SecondaryLocationMarker(bind(Messages['enum_outplace'], [ this.__enumerationAttribute.getLabel(), attributeValue.getLabel() ])); //$NON-NLS-1$
			} else {
				return new SecondaryLocationMarker(bind(Messages['enum_outplaceNotSet'], [ this.__enumerationAttribute.getLabel() ])); //$NON-NLS-1$
			}
		}
		return null;
	},

	// ---- implementation -------------------------------------------------------------------------------------------------
	
	__getValueId: function(elementInfo) {
		var value= elementInfo.getValue(this.__attributeId);
		return value != undefined ? value.getItemId() : ATTRIBUTE_NOT_SET;
	},

	__sentinel: null // terminates this class definition
});

})();



