/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.structure.CommonViewMode"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.util.Assert"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanModel"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttribute"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.model.FieldTag"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.structure.GroupElement"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.model.PrimaryLocationTag"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.model.OutplaceLocationMarker"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.structure.ViewModeTransformer"); //$NON-NLS-1$

(function() {
var Assert						= com.ibm.jdojo.util.Assert;

var PlanElement					= com.ibm.team.apt.client.PlanElement;
var PlanItem					= com.ibm.team.apt.client.PlanItem;
var PlanModel					= com.ibm.team.apt.client.PlanModel;
var PlanningAttribute			= com.ibm.team.apt.client.PlanningAttribute;

var FieldTag					= com.ibm.team.apt.ui.model.FieldTag;

var GroupElement				= com.ibm.team.apt.ui.structure.GroupElement;

var ViewModeTransformer			= com.ibm.team.apt.ui.structure.ViewModeTransformer;
var PrimaryLocationTag 			= com.ibm.team.apt.ui.model.PrimaryLocationTag.INSTANCE;
var OutplaceLocationMarker		= com.ibm.team.apt.ui.model.OutplaceLocationMarker;

var DeltaKind 					= ViewModeTransformer.DeltaKind;

var arrayAddFn= function(item) { this.push(item); };

dojo.declare("com.ibm.team.apt.shared.ui.internal.structure.CommonViewMode", ViewModeTransformer, { //$NON-NLS-1$
	
	__funcGetPlan: null,
	__structureAttributes: null,
	__elementInfos: null,
	__groupProvider: null,
	__groupCache: null,
	__options: null,

	_isRebuilding: false,
	
	constructor: function(funcGetPlan, groupProvider, options) {
		this.__funcGetPlan= funcGetPlan;
		this.__elementInfos= {};
		this.__groupCache= {};
		this.__groupProvider= groupProvider;
		this.__options= options;
	},
	
	// ---- ViewModeTransformer implementation -----------------------------------------------------------------------------

	inputChanged: function(model, newInput) {
		this.inherited(arguments);
		this.__groupProvider.inputChanged(model, newInput);
	},

	
	getEntryComparator: function() {
		return this.__groupProvider.getEntryComparator();
	},
	
	getViewAttributes: function() {
		return [];
	},

	getColumns: function() {
		if (this.__options) {
			var result= [];
			var columns= this.__options.columns;
			if(columns){
				for ( var i = 0; i < columns.length; i++) {
					result.push(new FieldTag(columns[i]));
				}
			}
			return result;
		}
		return [ ];
	},

	onBeginRebuild: function() {
		// flush the groups cache
		this.__elementInfos= {};
		this.__groupCache= {};
		this.__groupProvider.onBeginRebuild();
		this.__structureAttributes= {};
		
		function addAttribute(attributeId) {
			var attribute= attributeId instanceof PlanningAttribute ? attributeId : this._getPlan().findAttribute(attributeId);
			if(!attribute) throw new Error("Failed to laod attribute with attribute id: " + attributeId); //$NON-NLS-1$
			this.__structureAttributes[attribute.getId()]= attribute;
		};

		dojo.forEach(this.getViewAttributes(), addAttribute, this);
		dojo.forEach(this.__groupProvider.getDependantAttributes(), addAttribute, this);
	},

	rebuildModel: function(updateAccessor) {
		this._isRebuilding= true;
		try {
			dojo.forEach(this.__groupProvider.getDefaultGroupIds(), function(defaultGroupIdPath) {
				var defaultGroupPath= this._convertToGroupElementPath(defaultGroupIdPath.slice(0, defaultGroupIdPath.length - 1));
				updateAccessor.addEntry(null, defaultGroupPath, this._getGroupElement(defaultGroupIdPath));
			}, this);
	
			var planElements= this._getAllPlanElements();
			
			// first, cache all structure relevant attribute values (for ALL elements) 
			dojo.forEach(planElements, function(planElement) {
				this.__elementInfos[planElement.getUuid()]= ElementInfo.createFromPlanElement(planElement, this.__structureAttributes);
			}, this);
			
			this._addPlanElements(planElements, updateAccessor);
		} finally {
			this._isRebuilding= false;
		}
	},

	onEndRebuild: function() {
		this.__groupProvider.onEndRebuild();
	},

	computeDeltaKind: function(delta, readAccessor) {
		var result= DeltaKind.Ignore;
		if (delta.isAdded()) {
			result= DeltaKind.Added;
		} else if (delta.isRemoved()) {
			result= DeltaKind.Removed;
		} else if (delta.isChanged()) {
			result= DeltaKind.Changed;
		}

		var element= delta.getPlanElement();
		var wasIncluded= readAccessor.getElementEntries(element).length > 0;
		var isIncluded= this._isElementIncluded(element);

		if (result == DeltaKind.Added && !isIncluded) {
			result= DeltaKind.Ignore;
		} else if (result == DeltaKind.Removed && !wasIncluded) {
			result= DeltaKind.Ignore;
		} else if (result == DeltaKind.Changed) {
			var attributeDeltas= delta.getAttributeDeltas();
			var isPlanCheckChangeOnly= attributeDeltas.length == 1 && PlanElement.PLANCHECK_REPORT.equals(attributeDeltas[0].getAttribute());
			isPlanCheckChangeOnly&= !delta.isStructuralChange();

			if (wasIncluded != isIncluded && isPlanCheckChangeOnly) {
				// do not add or remove items because the plan checker sent a delta - wait for the real thing
				result= DeltaKind.Ignore;
			} else if (wasIncluded && !isIncluded) {
				result= DeltaKind.Removed;
			} else if (!wasIncluded && isIncluded) {
				result= DeltaKind.Added;
			} else if (!wasIncluded && !isIncluded) {
				result= DeltaKind.Ignore;
			}
		}
		return result;
	},

	updatePlanElementData: function(delta) {
		if (delta.getPlanElement() instanceof PlanItem) {
			this.__elementInfos[delta.getPlanElement().getUuid()]= this._getElementInfo(delta, true);
		}
	},

	getElementsToExpandInitially: function() {
		return this.getViewModel().readModel(dojo.hitch(this, function(readAccessor) {
			return this.__groupProvider.getElementsToExpandInitially(readAccessor);
		}));
	},

	calculateLocationMarker: function(entry, elementInfo) {
		var element= entry.getElement();
		var elementInfo= null;
		if (element instanceof PlanItem) {
			if (element.isAuxiliaryPlanItem()) {
				return new OutplaceLocationMarker(element);
			}
			elementInfo= this._getPlanElementInfo(element);
		}

		return this.__groupProvider.calculateLocationMarker(entry, elementInfo);
	},

	processElementAdded: function(delta, updateAccessor) {
		this.doUpdateProgress(delta, updateAccessor, true);
		return true;
	},

	processElementMoved: function(removeDelta, addDelta, updateAccessor) {
		this.doUpdateProgress(removeDelta, updateAccessor, false);
		this.doUpdateProgress(addDelta, updateAccessor, true);
		return true;
	},

	processElementRemoved: function(delta, updateAccessor) {
		this.doUpdateProgress(delta, updateAccessor, false);
		return true;
	},

	processElementChanged: function(delta, updateAccessor) {
		this.doUpdateProgress(delta, updateAccessor, true);
		return true;
	},
	
	doUpdateProgress: function(delta, updateAccessor, newValue) {
		
		var elementInfo=this._getElementInfo(delta, newValue);
		var entries= updateAccessor.getElementEntries(elementInfo.getPlanElement());
		
		var n= updateAccessor.getEntryNavigator(false);
		
		for (var i = 0; i < entries.length; i++) {
			var entry= entries[i];
			var parent= n.parentEntryOfType(entry, GroupElement);
			while(parent && !parent.isRootEntry()){
				if (parent.getElement() instanceof GroupElement)
					updateAccessor.update(parent, ["progress"]); //$NON-NLS-1$
				parent= n.parentEntry(parent);
			};
		}
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	_getPlan: function() {
		return this.__funcGetPlan();
	},

	_addPlanElements: function(planElements, updateAccessor) {
		throw new Error("_addPlanElements not implemented"); //$NON-NLS-1$
	},

	_isElementIncluded: function(element) {
		if (element instanceof PlanModel)
			return false;
		
		var elementInfo= this.__elementInfos[element.getUuid()];
		var result= this.__groupProvider.isElementIncluded(elementInfo);
		if (result == undefined) {
			result= element instanceof PlanItem;
		}
		return result;
	},
	
	_isElementInitiallyIncluded: function(element){
		return this._isElementIncluded(element) && (!(element instanceof PlanItem) || element.isPrimaryPlanItem());
	},

	_getAllPlanElements: function(){
		var result= [];
		dojo.forEach(this._getPlan().getAllPlanItems(), arrayAddFn, result);
		dojo.forEach(this._getPlan().getAbsences(), arrayAddFn, result);
		return result;
	},
	
	_getGroupElement: function(groupIdPath) {
		var groupId= groupIdPath.join("/"); //$NON-NLS-1$
		
		var result= this.__groupCache[groupId];
		if (!result) {
			result= this.__groupProvider.getGroupElement(groupIdPath);
			this.__groupCache[groupId]= result;
		}
		
		return result;
	},
	
	_convertToGroupElementPath: function(groupIdPath) {
		var result= [];
		for (var i= 1; i <= groupIdPath.length; i++) {
			var groupElement= this._getGroupElement(groupIdPath.slice(0, i));
			if (groupElement != null)
				result.push(groupElement);
		}
		return result;
	},


	_getElementInfoPath: function(delta, newValues) {
		var result= [];
		while (delta != null && !(delta.getPlanElement() instanceof PlanModel)) {
			result.unshift(this._getElementInfo(delta, newValues));
			delta= delta.getParentDelta();
		}
		return result;
	},
	
	_getElementInfo: function(delta, newValues) {
		return this._getPlanElementInfo(delta.getPlanElement()).update(delta, newValues);
	},

	_getPlanElementInfo: function(planElement) {
		var result= this.__elementInfos[planElement.getUuid()];
		if (result == undefined) {
			// TODO this here is wrong, as we access the model to query structural information
			// this happens if new items are added to the plan. The PlanDeltaBuilder will have to
			// add ALL of the PlanElements attributes to the add delta, so that we can read the 
			// values here directly from the delta rather than from the model
			result= ElementInfo.createFromPlanElement(planElement, this.__structureAttributes);
		}
		return result;
	},

	__sentinel: null // terminates this class definition
});

var ElementInfo= dojo.declare("com.ibm.team.apt.shared.ui.internal.structure.CommonViewMode.ElementInfo", null, { //$NON-NLS-1$

	__planElement: null,
	__structureValues: null,
	__structureAttributes: null,
	__children: null,
	__parent: null,

	constructor: function(planElement, structureValues, structureAttributes) {
		this.__planElement= planElement;
		this.__structureValues= structureValues;
		this.__structureAttributes= structureAttributes;
		this.__children= {};
		
		if (this.__planElement.hasChildren()) {
			var children= this.__planElement.getChildren();
			for ( var i = 0; i < children.length; i++) {
				this.__children[children[i].getUuid()]= children[i].getUuid();
			}
		}
		
		var parent= this.__planElement.getParent();
		if (parent instanceof PlanItem)
			this.__parent= parent.getUuid();
	},

	update: function(delta, newValue) {
		var deltaStructureValues= {};
		for (var attributeId in this.__structureAttributes) {
			var attributeDelta= delta.getAttributeDelta(this.__structureAttributes[attributeId]);
			if (attributeDelta != null) {
				deltaStructureValues[attributeId]= newValue ? attributeDelta.getNewValue() : attributeDelta.getOldValue();
			} else {
				deltaStructureValues[attributeId]= this.__structureValues[attributeId];
			}
		}

		var result= new ElementInfo(this.__planElement, deltaStructureValues, this.__structureAttributes);
		if (newValue) {
			var deltaChildren= delta.getChildren();
			for ( var j = 0; j < deltaChildren.length; j++) {
				var deltaChild= deltaChildren[j];
				if (deltaChild.isAdded()) {
					result.__children[deltaChild.getPlanElement().getUuid()]= deltaChild.getPlanElement().getUuid();
				} else if (deltaChild.isRemoved()) {
					delete result.__children[deltaChild.getPlanElement().getUuid()];
				}
			}
			
			var deltaParent= delta.getParentDelta();
			if (deltaParent != null) {
				if (deltaParent.isAdded() || deltaParent.isRemoved() || deltaParent.isChanged()) {
					var planElement= deltaParent.getPlanElement();
					if (planElement instanceof PlanItem)
						result.__parent= deltaParent.getPlanElement().getUuid();
				}
			}
		}
		return result;
	},
	
	getParent: function() {
		return this.__parent;
	},
	
	hasChildren: function() {
		return this.getChildren().length > 0;
	},
	
	getChildren: function() {
		var result= [];
		for ( var child in this.__children) {
			if (child != null) {
				result.push(child);
			}
		}
		return result;
	},

	getPlanElement: function() {
		return this.__planElement;
	},

	getValue: function(attributeIdentifier) {
		return this.__structureValues[attributeIdentifier.getId()];
	},
	
	getStructureValues: function() {
		return this.__structureValues;
	},

	equals: function(other) {
		if (this === other)
			return true;

		if (!this.__planElement.equals(other.__planElement))
			return false;

		for (var attributeId in this.__structureValues) {
			var thisValue= this.__structureValues[attributeId];
			var otherValue= other.__structureValues[attributeId];
	
			if (thisValue == null && otherValue != thisValue)
				return false;
			
			if (otherValue == null && otherValue != thisValue)
				return false;
			
			if (thisValue != null && otherValue != null && (thisValue.equals ? !thisValue.equals(otherValue) : thisValue != otherValue))
				return false;
		}

		return true;
	},

	__sentinel: null // terminates this class definition
});

ElementInfo.createFromPlanElement= function(planElement, structureAttributes) {
	var structureValues= {};
	for (var attributeId in structureAttributes) {
		structureValues[attributeId]= planElement.getAttributeValue(structureAttributes[attributeId]);
	}
	
	return new ElementInfo(planElement, structureValues, structureAttributes);
};

})();
 


