/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2013. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.structure.CategoryGroupProvider"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.util.Assert"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.GenericElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.structure.GroupProvider"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.model.PrimaryLocationTag"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.model.SecondaryLocationMarker"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.Create"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.shared.ui.internal", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var Assert						= com.ibm.jdojo.util.Assert;
var PlanItem					= com.ibm.team.apt.client.PlanItem;
var GenericElement				= com.ibm.team.apt.ui.structure.GenericElement;
var GroupProvider				= com.ibm.team.apt.shared.ui.structure.GroupProvider;
var Create						= com.ibm.team.apt.shared.ui.Create;

var SecondaryLocationMarker		= com.ibm.team.apt.ui.model.SecondaryLocationMarker;
var PrimaryLocationTag 			= com.ibm.team.apt.ui.model.PrimaryLocationTag.INSTANCE;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.shared.ui.internal", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

dojo.declare("com.ibm.team.apt.shared.ui.internal.structure.CategoryGroupProvider", GroupProvider, { //$NON-NLS-1$

	constructor: function(funcGetPlan, options) {
	},

	// ---- api ------------------------------------------------------------------------------------------------------------
	
	getDependantAttributes: function() {
		return [ PlanItem.CATEGORY ];
	},

	getDefaultGroupIds: function() {
		var categories= dojo.filter(this._getPlan().getPlanCategories(), function(category) { return !category.isArchived(); });
		return dojo.map(categories, this.__getCategoryStack);
	},

	getGroupsIds: function(elementInfo) {
		return [ this.__getCategoryStack(elementInfo.getValue(PlanItem.CATEGORY)) ];
	},

	isPrimaryGroup: function(groupIdPath, elementInfo) {
		Assert.isTrue(groupIdPath.length >= 1);
		return groupIdPath[groupIdPath.length - 1] == elementInfo.getValue(PlanItem.CATEGORY).getItemId();
	},

	getGroupElement: function(groupIdPath) {
		Assert.isTrue(groupIdPath.length >= 1);
		var category= this._getPlan().getItem(groupIdPath[groupIdPath.length - 1]);
		return new GenericElement(category.getItemId(), category.getLabel(), category, {
			adopt : function(planItem) {
				planItem.setAttributeValue(PlanItem.CATEGORY, category);
				return true;
			},
			canAdopt : function(planItem) {
				return !category.isArchived();
			},
			comperator : function(o1, o2) {
				return o1.getValue().compareTo(o2.getValue());
			}});
	},
	
	getElementsToExpandInitially: function(readAccessor) {
		var rootEntries= readAccessor.getChildren(readAccessor.getRootEntry(null));

		var result= dojo.map(rootEntries, function(entry) {return entry;});
		for (var i= 0; i < rootEntries.length; i++) {
			dojo.forEach(readAccessor.getChildren(rootEntries[i]), function(childEntry) {
				if (childEntry.getElement() instanceof GenericElement) {
					result.push(childEntry);
				}
			})
		}
		return result;
	},
	
	canCreate: function(request, readAccessor) {
		var n= readAccessor.getEntryNavigator(true);
		var groupEntry= n.parentEntryOfType(request.targetEntry, com.ibm.team.apt.ui.structure.GroupElement);
		
		if(groupEntry.getElement()&& !groupEntry.getElement().canAdopt(groupEntry.getElement().element)) {
			return com.ibm.team.apt.shared.ui.Create.Response.DENY;
		}
		if (groupEntry != null) {
			return new Create.Response(request.targetEntry, {
				groupEntry: groupEntry
			});
		}
		return null;	
	},
	
	create: function(response, updateAccessor) {
		var groupEntry= response.info.groupEntry;
		if (groupEntry) {
			groupEntry.getElement().adopt(response.newItem, groupEntry, null);
		}
	},
	
	calculateLocationMarker: function(entry, elementInfo) {
		if (!entry.hasTag(PrimaryLocationTag) && elementInfo != null && elementInfo.getPlanElement() instanceof PlanItem) {
			return new SecondaryLocationMarker(bind(Messages['category_outplace'], [ elementInfo.getValue(PlanItem.CATEGORY).getLabel() ])); //$NON-NLS-1$
		}
		return null;
	},

	// ---- implementation -------------------------------------------------------------------------------------------------
	
	__getCategoryStack: function(category) {
		var result= [];
		while (category != null) {
			result.unshift(category.getItemId());
			category= category.getParent();
		}
		return result;
	},

	__sentinel: null // terminates this class definition
});

})();



