/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2013. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.sortmode.RankingPlanItemSorter"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.util.Assert"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.common.Severity"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeIdentifier"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.model.EntrySorter"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.model.CustomMarkerTag"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.model.ColorizeTag"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.Move"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.Create"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.GroupElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.RowElement"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.shared.ui.internal", "SorterMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var Assert							= com.ibm.jdojo.util.Assert;

var Severity						= com.ibm.team.apt.common.Severity;
var PlanItem						= com.ibm.team.apt.client.PlanItem;
var PlanningAttributeIdentifier		= com.ibm.team.apt.client.PlanningAttributeIdentifier;
var Move							= com.ibm.team.apt.shared.ui.Move;
var Create							= com.ibm.team.apt.shared.ui.Create;
var GroupElement					= com.ibm.team.apt.ui.structure.GroupElement;
var CustomMarkerTag					= com.ibm.team.apt.ui.model.CustomMarkerTag;
var ColorizeTag						= com.ibm.team.apt.ui.model.ColorizeTag;
var RowElement						= com.ibm.team.apt.ui.structure.RowElement;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.shared.ui.internal", "SorterMessages"); //$NON-NLS-1$ //$NON-NLS-2$

function ItemIterator(entries, index, forward, toExclude) {
	var step= forward ? 1 : -1; 
	function validate() {
		while (index >= 0 && index < entries.length) {
			if (entries[index].isVisible()) {
				var element= entries[index].getElement();
				if (element != toExclude && element instanceof PlanItem)
					break;
			}
			index+= step;
		}
	};
	
	this.hasNext= function() {
		return index >= 0 && index < entries.length;
	};

	this.next= function() {
		var result= null;
		if (index >= 0 && index < entries.length) {
			result= entries[index].getElement();
			index+= step;
			validate();
		}
		return result;
	};
	
	validate();
}

dojo.declare("com.ibm.team.apt.shared.ui.internal.sortmode.RankingPlanItemSorter", com.ibm.team.apt.shared.ui.model.EntrySorter, { //$NON-NLS-1$

	__attributeId: null,
	__attributeImpl: null,
	
	__markerRunnableToken: null,
	__notRankedMarkerTag: null,
	__notRankedColorizeTag: null,
	__notRankableTag: null,
	
	constructor: function(options) {
		this.__attributeId= new PlanningAttributeIdentifier(options.getParameter("attribute")); //$NON-NLS-1$
		
		this.__notRankedMarkerTag= new CustomMarkerTag(this, Severity.INFO, Messages['ranking_notYetRanked']); //$NON-NLS-1$

		if ("true" === String(options.getParameter("colorize") || "false").toLowerCase()) { //$NON-NLS-3$ //$NON-NLS-2$ //$NON-NLS-1$
			var priority= parseInt(options.getParameter("priority") || "-1"); ///$NON-NLS-2$ //$NON-NLS-1$
			var color= options.getParameter("color") || "#FFE4C4"; ///$NON-NLS-2$ //$NON-NLS-1$
			
			if (!isNaN(priority) && color.length == 7 && color.charAt(0) == "#") { //$NON-NLS-1$
				this.__notRankedColorizeTag= new ColorizeTag(this, color, priority);
			}
		}

		this.__notRankableTag= new CustomMarkerTag(this, Severity.WARNING, Messages['ranking_notRankable']); //$NON-NLS-1$
	},

	// ---- api ------------------------------------------------------------------------------------------------------------
	
	getDependantAttributes: function() {
		return [this.__attributeId];
	},
	
	inputChanged: function(viewModel, planModel) {
		var oldModel= this._getViewModel();
		if (oldModel && this.__markerRunnableToken !== null) {
			oldModel.removePostUpdateRunnable(this.__markerRunnableToken);
			this.__markerRunnableToken= null;

			// we must cleanup all tags set while we were active
			oldModel.updateModel(dojo.hitch(this, function(updateAccessor) {
				updateAccessor.accept(dojo.hitch(this, function(entry) {
					if (entry.getElement() instanceof PlanItem) {
						this.__clearTags(entry, updateAccessor);
					}
					return true;
				}), null);
			}));
		}
		
		this.inherited(arguments);
		
		if (viewModel) {
			// do an initial update
			viewModel.updateModel(dojo.hitch(this, function(updateAccessor) {
				updateAccessor.accept(dojo.hitch(this, function(entry) {
					if (entry.getElement() instanceof PlanItem) {
						this.__setTags(entry, updateAccessor);
					}
					return true;
				}), null);
			}));
			this.__markerRunnableToken= viewModel.addPostUpdateRunnable(dojo.hitch(this, this.__updateMarker), true);
		}
	},

	canMove: function(request, readAccessor) {
		var sourceElement= request.sourceElement;
		var targetElement= request.targetEntry.getElement();

		if (sourceElement instanceof PlanItem && targetElement instanceof PlanItem && (request.location == Move.After || request.location == Move.Before)) {
			
			if (!this.__getRank(sourceElement).canRank() || !this.__getRank(targetElement).canRank()) {
				return Move.Response.DENY;
			}

			var info= this.__createRankingInfo(request.targetEntry, request.location == Move.After, sourceElement, readAccessor);
			info.toRank= sourceElement;
			return new Move.Response(request.targetEntry, request.location, info);
		}

		var superResponse= this.inherited(arguments);
		if (superResponse != null) {
			return new Move.Response(request.targetEntry, request.location, {
				superResponse: superResponse
			});
		}

		return null;
	},

	move: function(response, updateAccessor) {
		if (response.info.toRank != null) {
			this.__moveItem(response.info.toRank, response.info.predecessors, response.info.successors);
		}

		if (response.info.superResponse != null) {
			this.inherited("move", arguments, [response.info.superResponse, updateAccessor]); //$NON-NLS-1$
		}
	},

	canCreate: function(request, readAccessor) {
		var targetElement= request.targetEntry.getElement();
		if (targetElement instanceof PlanItem && (request.location == Create.After || request.location == Create.Before)) {
			if (!this.__getRank(targetElement).canRank()) {
				return Create.Response.DENY;
			}

			var info= this.__createRankingInfo(request.targetEntry, request.location == Create.After, null, readAccessor);
			info.doRank= true;
			return new Create.Response(request.targetEntry, info);
		} else if (targetElement instanceof GroupElement && request.location == Create.Child) {
			var n= readAccessor.getEntryNavigator(true);
			var childEntries= n.childEntries(request.targetEntry);
			var targetEntry= childEntries.length > 0 ? childEntries[childEntries.length - 1] : null;
			
			if (targetEntry != null) {
				targetElement= targetEntry.getElement();
				if (targetElement instanceof PlanItem && !this.__getRank(targetElement).canRank()) {
					return Create.Response.DENY;
				}
			}

			var info= this.__createRankingInfo(targetEntry, true, null, readAccessor);
			info.doRank= true;
			return new Create.Response(request.targetEntry, info);
		}

		var superResponse= this.inherited(arguments);
		if (superResponse != null) {
			return new Create.Response(request.targetEntry, request.location, {
				superResponse: superResponse
			});
		}

		return null;
	},

	create: function(response, updateAccessor) {		
		if (response.info.doRank) {
			this.__moveItem(response.newItem, response.info.predecessors, response.info.successors);
		}

		if (response.info.superResponse != null) {
			response.info.superResponse.newItem= response.newItem;
			this.inherited("create", arguments, [response.info.superResponse, updateAccessor]); //$NON-NLS-1$
		}
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	_compare: function(e1, e2, forceResort, readAccessor) {
		var i1= e1.getElement();
		var i2= e2.getElement();
		
		if (i1 instanceof RowElement) {
			i1= i1.getParent();
		}
		if (i2 instanceof RowElement) {
			i2= i2.getParent();
		}
		
		if (i1 instanceof PlanItem && i2 instanceof PlanItem) {
			var result=this.__getRank(i1).compareTo(this.__getRank(i2));
			return result != 0 ? result :  i1.getId() - i2.getId();
		} else {
			return this.inherited(arguments);
		}
	},

	__createRankingInfo: function(targetEntry, moveAfter, toExclude, readAccessor) {
		var siblings, splitIndex;
		if (targetEntry) {
			var n= readAccessor.getEntryNavigator(false);
			siblings= n.siblingEntries(targetEntry);
			splitIndex= n.index(targetEntry);
			if (splitIndex == -1)
				splitIndex= siblings.length;
			
			if (moveAfter) {
				splitIndex++;
			}
		} else {
			siblings= [];
			splitIndex= 0;
		}

		return {
			predecessors: new ItemIterator(siblings, splitIndex - 1, false, toExclude),
			successors: new ItemIterator(siblings, splitIndex, true, toExclude)
		};
	},

	__moveItem: function(item, predecessorIterator, successorIterator) {
		var toRank= [ item ];
		// find the predecessor- and successor-value of the insertion location
		var currentValue= this.__getRank(item); //$NON-NLS-1$
		var predecessorValue= this.__findUniqueValue(predecessorIterator, null, toRank, "unshift"); //$NON-NLS-1$
		var successorValue= this.__findUniqueValue(successorIterator, null, toRank, "push"); //$NON-NLS-1$
		
		if (predecessorValue != null && successorValue != null && !predecessorValue.getEnumerationValue().equals(successorValue.getEnumerationValue())) {
			// we move between between two groups
			if (currentValue.compareEnumerationValueTo(predecessorValue) <= 0) {
				// the item to rank has a higher or the same rank as the predecessor group -> append it the end of the predecessor group
				// ... but do not touch the successor group  
				successorValue= null;
			} else if (currentValue.compareEnumerationValueTo(successorValue) >= 0) {
				// the item to rank has a lower or the same rank as the successor group -> prepend it the beginning of the successor group
				// ... but do not touch the predecessor group  
				predecessorValue= null;
			} else {
				// the items's current rank is [predecessor > item > successor]. we do not touch the current rank and start a new group 
				predecessorValue= null;
				successorValue= null;
			}

			if (predecessorValue == null)
				// predecessor's value was null'ed out -> do not touch it's ranking 
				toRank.shift();

			if (successorValue == null)
				// successor's value was null'ed out -> do not touch it's ranking 
				toRank.pop();
		}

		if (predecessorValue != null && !predecessorValue.isSpecified()) {
			// the item is moved in a group of unranked items -> rank all predecessor items in the same group 
			while (predecessorIterator.hasNext()) {
				var nextItem= predecessorIterator.next();
				var candidateValue= this.__getRank(nextItem);
				if (predecessorValue.compareTo(candidateValue) != 0) {
					if (candidateValue.getEnumerationValue().equals(predecessorValue.getEnumerationValue())) {
						// if the first predecessor with a different rank belongs to the same group, 
						// use its value as seed. 
						predecessorValue= candidateValue;
					} else {
						// otherwise, we just start with the initial value
						predecessorValue= null;
					}
					break;
				}
				toRank.unshift(nextItem);
			}

			if (successorValue != null)
				// the successor is not ranked, but we do not want to touch it either,
				// as we only care about predecessors to achieve a defined sort order 
				toRank.pop();
		} else if (predecessorValue != null && successorValue != null && predecessorValue.compareTo(successorValue) == 0) {
			// the predecessor- and successor values of the insert location are equal.
			// self heal by evenly distributing all predecessors and successors with the same value
			// in the range of the first / last value of the same group which is different
			predecessorValue= this.__findUniqueValue(predecessorIterator, predecessorValue, toRank, "unshift"); //$NON-NLS-1$
			successorValue= this.__findUniqueValue(successorIterator, successorValue, toRank, "push"); //$NON-NLS-1$
			
			if (predecessorValue)
				// do not rank the first predecessor with a different value 
				toRank.shift();

			if (successorValue)
				// do not rank the first successor with a different value 
				toRank.pop();

			Assert.isTrue(predecessorValue == null || successorValue == null || predecessorValue.compareTo(successorValue) != 0);
		} else {
			toRank= [ item ];
		}

		this._getPlan().compoundChange(function() {
			this.__moveItems(toRank, predecessorValue, successorValue, 0, toRank.length - 1);
		}, this);
	},

	__moveItems: function(toRank, predecessorValue, successorValue, lowIndex, highIndex) {
		var midIndex= (lowIndex + highIndex) >> 1;
		var midItem= toRank[midIndex];
		
		var currentValue= this.__getRank(midItem);
		var midValue= this.__getAttributeImpl().calculateRank(predecessorValue, successorValue, currentValue);
		
		midItem.setAttributeValue(this.__attributeId, midValue);

		if (lowIndex < midIndex) {
			this.__moveItems(toRank, predecessorValue, midValue, lowIndex, midIndex - 1);
		}

		if (midIndex < highIndex) {
			this.__moveItems(toRank, midValue, successorValue, midIndex + 1, highIndex);
		}
	},
	
	__findUniqueValue: function(iterator, initialValue, toRank, toRankAddFn) {
		var result= null;
		while (iterator.hasNext()) {
			var nextItem= iterator.next();
			toRank[toRankAddFn](nextItem);
			var candidateValue= this.__getRank(nextItem);
			if (initialValue == null || initialValue.compareTo(candidateValue) != 0) {
				result= candidateValue;
				break;
			}
		}

		return result;
	},

	__getRank: function(planElement) {
		return planElement.getAttributeValue(this.__attributeId);
	},

	__getAttributeImpl: function() {
		return this._getPlan().findAttribute(this.__attributeId).getImplementation();
	},

	__updateMarker: function(updateAccessor) {
		updateAccessor.accept(dojo.hitch(this, function(entry) {
			if (entry.getElement() instanceof PlanItem) {
				if (updateAccessor.isModified(entry)) {
					this.__clearTags(entry, updateAccessor);
					this.__setTags(entry, updateAccessor);
				}
			}
			return true;
		}), null);
	},
	
	__clearTags: function(entry, updateAccessor) {
		if (this.__notRankedMarkerTag)
			updateAccessor.clearTag(entry, this.__notRankedMarkerTag);
		if (this.__notRankedColorizeTag)
			updateAccessor.clearTag(entry, this.__notRankedColorizeTag);
		updateAccessor.clearTag(entry, this.__notRankableTag);
	},

	__setTags: function(entry, updateAccessor) {
		if (!this.__getRank(entry.getElement()).canRank()) {
			updateAccessor.setTag(entry, this.__notRankableTag);
		} else if (!this.__getRank(entry.getElement()).isSpecified()) {
			if (this.__notRankedMarkerTag)
				updateAccessor.setTag(entry, this.__notRankedMarkerTag);
			if (this.__notRankedColorizeTag)
				updateAccessor.setTag(entry, this.__notRankedColorizeTag);
		}
	},

	__sentinel: null // terminates this class definition
});

})();
