/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2013. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights: Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 ******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.sortmode.NewRankingPlanItemSorter");
dojo.require("com.ibm.jdojo.util.Assert"); 

dojo.require("com.ibm.team.apt.client.PlanningAttributeIdentifier"); 
dojo.require("com.ibm.team.apt.client.PlanItem"); 
dojo.require("com.ibm.team.apt.client.SequenceValue");
dojo.require("com.ibm.team.apt.common.Severity"); 
dojo.require("com.ibm.team.apt.shared.ui.Move"); 
dojo.require("com.ibm.team.apt.shared.ui.Create"); 
dojo.require("com.ibm.team.apt.shared.ui.model.EntrySorter"); 
dojo.require("com.ibm.team.apt.ui.model.ColorizeTag"); 
dojo.require("com.ibm.team.apt.ui.model.CustomMarkerTag"); 
dojo.require("com.ibm.team.apt.ui.structure.GroupElement"); 
dojo.require("com.ibm.team.apt.ui.structure.RowElement"); 

dojo.require("dojo.string"); 
dojo.require("dojo.i18n"); 
dojo.requireLocalization("com.ibm.team.apt.shared.ui.internal", "SorterMessages");  

(function() {

var Assert							= com.ibm.jdojo.util.Assert;

var Severity						= com.ibm.team.apt.common.Severity;
var PlanItem						= com.ibm.team.apt.client.PlanItem;
var PlanningAttributeIdentifier		= com.ibm.team.apt.client.PlanningAttributeIdentifier;
var Move							= com.ibm.team.apt.shared.ui.Move;
var Create							= com.ibm.team.apt.shared.ui.Create;
var GroupElement					= com.ibm.team.apt.ui.structure.GroupElement;
var CustomMarkerTag					= com.ibm.team.apt.ui.model.CustomMarkerTag;
var ColorizeTag						= com.ibm.team.apt.ui.model.ColorizeTag;
var RowElement						= com.ibm.team.apt.ui.structure.RowElement;
var SequenceValue					= com.ibm.team.apt.client.SequenceValue;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.shared.ui.internal", "SorterMessages");

var SEQUENCE_ATTRIBUTE_ID_SUFFIX= "_pm7NmRYUEd6L1tNIGdz5qQ";

function ItemIterator(entries, index, forward, toExclude) {
	var step= forward ? 1 : -1;

	function validate() {
		while (index >= 0 && index < entries.length) {
			if (entries[index].isVisible()) {
				var element= entries[index].getElement();
				if (element != toExclude && element instanceof PlanItem)
					break;
			}
			index+= step;
		}
	};

	this.hasNext= function() {
		return index >= 0 && index < entries.length;
	};

	this.next= function() {
		var result= null;
		if (index >= 0 && index < entries.length) {
			result= entries[index].getElement();
			index+= step;
			validate();
		}
		return result;
	};

	validate();
}

dojo.declare("com.ibm.team.apt.shared.ui.internal.sortmode.NewRankingPlanItemSorter", com.ibm.team.apt.shared.ui.model.EntrySorter, {

	__attributeId: null,
	__secondarySelectionId: null,
	__seqAttributeId: null,
	__seqAttribute: null,

	__markerRunnableToken: null,
	__notRankedMarkerTag: null,
	__notRankedColorizeTag: null,
	__notRankableTag: null,

	constructor: function(options) {
		var attrStr= options.getParameter("attribute");
		this.__attributeId= new PlanningAttributeIdentifier(attrStr); 
		this.__secondarySelectionId= new PlanningAttributeIdentifier(options.getParameter("secondary-selection")); 
		this.__seqAttributeId= new PlanningAttributeIdentifier(attrStr + "." + SEQUENCE_ATTRIBUTE_ID_SUFFIX); 
		this.__notRankedMarkerTag= new CustomMarkerTag(this, Severity.INFO, Messages['ranking_notYetRanked']); 

		if ("true" === String(options.getParameter("colorize") || "false").toLowerCase()) {   
			var priority= parseInt(options.getParameter("priority") || "-1");
			var color= options.getParameter("color") || "#FFE4C4"; 
			
			if (!isNaN(priority) && color.length == 7 && color.charAt(0) == "#") { 
				this.__notRankedColorizeTag= new ColorizeTag(this, color, priority);
			}
		}

		this.__notRankableTag= new CustomMarkerTag(this, Severity.WARNING, Messages['ranking_notRankable']); 
	},

	// ---- api -------------------------------------------------------------------------------------------------
	
	getDependantAttributes: function() {
		return [this.__attributeId];
	},
	
	inputChanged: function(viewModel, planModel) {
		if (planModel != null) {
			this.__seqAttribute= planModel.findAttribute(this.__seqAttributeId);
		}
		var oldModel= this._getViewModel();
		if (oldModel && this.__markerRunnableToken !== null) {
			oldModel.removePostUpdateRunnable(this.__markerRunnableToken);
			this.__markerRunnableToken= null;

			// we must cleanup all tags set while we were active
			oldModel.updateModel(dojo.hitch(this, function(updateAccessor) {
				updateAccessor.accept(dojo.hitch(this, function(entry) {
					if (entry.getElement() instanceof PlanItem) {
						this.__clearTags(entry, updateAccessor);
					}
					return true;
				}), null);
			}));
		}
		
		this.inherited(arguments);
		
		if (viewModel) {
			// do an initial update
			viewModel.updateModel(dojo.hitch(this, function(updateAccessor) {
				updateAccessor.accept(dojo.hitch(this, function(entry) {
					if (entry.getElement() instanceof PlanItem) {
						this.__setTags(entry, updateAccessor);
					}
					return true;
				}), null);
			}));
			this.__markerRunnableToken= viewModel.addPostUpdateRunnable(dojo.hitch(this, this.__updateMarker), true);
		}

	},

	canMove: function(request, readAccessor) {
		var sourceElement= request.sourceElement;
		var targetElement= request.targetEntry.getElement();

		if (sourceElement instanceof PlanItem && targetElement instanceof PlanItem && (request.location == Move.After || request.location == Move.Before)) {
			
			var info= this.__createRankingInfo(request.targetEntry, request.location == Move.After, sourceElement, readAccessor);
			info.toRank= sourceElement;
			return new Move.Response(request.targetEntry, request.location, info);
		}

		var superResponse= this.inherited(arguments);
		if (superResponse != null) {
			return new Move.Response(request.targetEntry, request.location, {
				superResponse: superResponse
			});
		}

		return null;
	},

	move: function(response, updateAccessor) {
		if (response.info.toRank != null) {
			this.__moveItem(response.info.toRank, response.info.predecessors, response.info.successors);
		}

		if (response.info.superResponse != null) {
			this.inherited("move", arguments, [response.info.superResponse, updateAccessor]); 
		}
	},

	canCreate: function(request, readAccessor) {
		var targetElement= request.targetEntry.getElement();
		if (targetElement instanceof PlanItem && (request.location == Create.After || request.location == Create.Before)) {
			var navigator= readAccessor.getEntryNavigator(true);
			var targetEntry= navigator.lastSiblingEntry(request.targetEntry);
	
			return new Create.Response(targetEntry, {
				location: Create.After
			});
		} else if (targetElement instanceof GroupElement && request.location == Create.Child) {
			var navigator= readAccessor.getEntryNavigator(true);
			var childEntries= navigator.childEntries(request.targetEntry);
			var targetEntry= childEntries.length > 0 ? childEntries[childEntries.length - 1] : request.targetEntry;

			return new Create.Response(targetEntry, {
				location: Create.After
			});
		}

		var superResponse= this.inherited(arguments);
		if (superResponse != null) {
			return new Create.Response(request.targetEntry, request.location, {
				superResponse: superResponse
			});
		}

		return null;
	},
	
	create: function(response, updateAccessor) {		
		if (response.newItem instanceof PlanItem) {
			response.newItem.setAttributeValue(this.__attributeId, SequenceValue.NEW);
		}
		this.inherited("create", arguments, [response, updateAccessor]); 
	},

	// ---- implementation -------------------------------------------------------------------------------

	_compareSecondarySelection: function(v1, v2) {
		var result= 0;
		if (v1 && v2) {
			result= v2.compareTo(v1);
		} else if (v1 && !v2) {
			result= -1;
		} else if (!v1 && v2) {
			result= 1;
		}
		return result;
	},
	
	_compare: function(e1, e2, forceResort, readAccessor) {
		var result=0;
		var i1= e1.getElement();
		var i2= e2.getElement();
		
		if (i1 instanceof RowElement) {
			i1= i1.getParent();
		}
		if (i2 instanceof RowElement) {
			i2= i2.getParent();
		}
		
		if (i1 instanceof PlanItem && i2 instanceof PlanItem) {
			
			var result= this.__getSequence(i1).compareTo(this.__getSequence(i2));
			
			if (result == 0) {
				result= this._compareSecondarySelection(i1.getAttributeValue(this.__secondarySelectionId), i2.getAttributeValue(this.__secondarySelectionId));
			}
			if (result == 0) {
				var id1= i1.getId() == -1 ? Number.MAX_VALUE : i1.getId();
				var id2= i2.getId() == -1 ? Number.MAX_VALUE : i2.getId();
				result= id1 - id2;
			}
		} else {
			result= this.inherited(arguments);
		}
		return result;
	},

	__getSequence : function(planItem) {
		return SequenceValue.FACTORY.valueOf(planItem.getAttributeValue(this.__seqAttribute), this.__attributeId.getId());
	},
	
	__createRankingInfo: function(targetEntry, moveAfter, toExclude, readAccessor) {
		var siblings, splitIndex;
		if (targetEntry) {
			var navigator= readAccessor.getEntryNavigator(false);
			siblings= navigator.siblingEntries(targetEntry);
			splitIndex= navigator.index(targetEntry);
			if (splitIndex == -1)
				splitIndex= siblings.length;
			
			if (moveAfter) {
				splitIndex++;
			}
		} else {
			siblings= [];
			splitIndex= 0;
		}

		return {
			predecessors: new ItemIterator(siblings, splitIndex - 1, false, toExclude),
			successors: new ItemIterator(siblings, splitIndex, true, toExclude)
		};
	},

	__moveItem: function(item, predecessorIterator, successorIterator) {
		var toRank= [ item ];
		// find the predecessor- and successor-value of the insertion location
		var predecessorValue= this.__findUniqueValue(predecessorIterator, null, toRank, "unshift"); 
		var successorValue= this.__findUniqueValue(successorIterator, null, toRank, "push"); 
		
		if (predecessorValue != null && !predecessorValue.isNew()) {
			// the item is moved in a group of unranked items -> rank all predecessor items in the same group
			while (predecessorIterator.hasNext()) {
				var nextItem= predecessorIterator.next();
				var candidateValue= this.__getSequence(nextItem);
				if (predecessorValue.compareTo(candidateValue) != 0) {
					predecessorValue= candidateValue;
					break;
				}
				toRank.unshift(nextItem);
			}

			if (successorValue != null)
				// the successor is not ranked, but we do not want to touch it
				// either, as we only care about predecessors to achieve a defined sort
				// order
				toRank.pop();
		} else if (predecessorValue != null && successorValue != null && predecessorValue.compareTo(successorValue) == 0) {
			// the predecessor- and successor values of the insert location are equal.
			// self heal by evenly distributing all predecessors and successors
			// with the same value in the range of the first / last value of the same group which is
			// different
			predecessorValue= this.__findUniqueValue(predecessorIterator, predecessorValue, toRank, "unshift"); 
			successorValue= this.__findUniqueValue(successorIterator, successorValue, toRank, "push"); 
			
			if (predecessorValue)
				// do not rank the first predecessor with a different value
				toRank.shift();

			if (successorValue)
				// do not rank the first successor with a different value
				toRank.pop();

			Assert.isTrue(predecessorValue == null || successorValue == null || predecessorValue != successorValue);
		} else {
			toRank= [ item ];
		}

		this._getPlan().compoundChange(function() {
			this.__moveItems(toRank, predecessorValue, successorValue, 0, toRank.length - 1);
		}, this);
	},

	__moveItems: function(toRank, predecessorValue, successorValue, lowIndex, highIndex) {
		var midIndex= (lowIndex + highIndex) >> 1;
		var midItem= toRank[midIndex];
		
		var currentValue= this.__getSequence(midItem);
		var midValue= this.__getAttributeImpl().calculateRank(predecessorValue, successorValue, currentValue);
		midItem.setAttributeValue(this.__attributeId, midValue);

		if (lowIndex < midIndex) {
			this.__moveItems(toRank, predecessorValue, midValue, lowIndex, midIndex - 1);
		}

		if (midIndex < highIndex) {
			this.__moveItems(toRank, midValue, successorValue, midIndex + 1, highIndex);
		}
	},
	
	__findUniqueValue: function(iterator, initialValue, toRank, toRankAddFn) {
		var result= null;
		while (iterator.hasNext()) {
			var nextItem= iterator.next();
			toRank[toRankAddFn](nextItem);
			var candidateValue= this.__getSequence(nextItem);
			if (initialValue == null || initialValue.compareTo(candidateValue) != 0) {
				result= candidateValue;
				break;
			}
		}

		return result;
	},
	
	__getAttributeImpl: function() {
		return this._getPlan().findAttribute(this.__attributeId).getImplementation();
	},

	__updateMarker: function(updateAccessor) {
		updateAccessor.accept(dojo.hitch(this, function(entry) {
			if (entry.getElement() instanceof PlanItem) {
				if (updateAccessor.isModified(entry)) {
					this.__clearTags(entry, updateAccessor);
					this.__setTags(entry, updateAccessor);
				}
			}
			return true;
		}), null);
	},
	
	__clearTags: function(entry, updateAccessor) {
		if (this.__notRankedMarkerTag)
			updateAccessor.clearTag(entry, this.__notRankedMarkerTag);
		if (this.__notRankedColorizeTag)
			updateAccessor.clearTag(entry, this.__notRankedColorizeTag);
		updateAccessor.clearTag(entry, this.__notRankableTag);
	},

	__setTags: function(entry, updateAccessor) {
		if (this.__getSequence(entry.getElement()).isNew()) {
			if (this.__notRankedMarkerTag)
				updateAccessor.setTag(entry, this.__notRankedMarkerTag);
			if (this.__notRankedColorizeTag)
				updateAccessor.setTag(entry, this.__notRankedColorizeTag);
		}
	},

	__sentinel: null // terminates this class definition
});

})();
