/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.sortmode.GenericPlanItemSorter"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanningAttributeIdentifier"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.model.EntrySorter"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.RowElement"); //$NON-NLS-1$

(function() {

var PlanItem						= com.ibm.team.apt.client.PlanItem;
var RowElement						= com.ibm.team.apt.ui.structure.RowElement;
var PlanningAttributeIdentifier		= com.ibm.team.apt.client.PlanningAttributeIdentifier;

dojo.declare("com.ibm.team.apt.shared.ui.internal.sortmode.GenericPlanItemSorter", com.ibm.team.apt.shared.ui.model.EntrySorter, { //$NON-NLS-1$

	constructor: function(options) {
		this.__attributeId= new PlanningAttributeIdentifier(options.getParameter("attribute")); //$NON-NLS-1$
		this.__direction= ((options.getParameter("sortorder") || "ascending") != "descending") ? 1 : -1; //$NON-NLS-1$
	},

	// ---- api ------------------------------------------------------------------------------------------------------------
	
	getDependantAttributes: function() {
		return [this.__attributeId];
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	_compare: function(e1, e2, forceResort, readAccessor) {
		var i1= e1.getElement();
		var i2= e2.getElement();
		
		if (i1 instanceof RowElement) {
			i1= i1.getParent();
		}
		if (i2 instanceof RowElement) {
			i2= i2.getParent();
		}
		
		if (forceResort && i1 instanceof PlanItem && i2 instanceof PlanItem) {
			var attribute= i1.getPlanModel().findAttribute(this.__attributeId);
			
			var v1= i1.getAttributeValue(attribute);
			var v2= i2.getAttributeValue(attribute);

			var result= 0;
			if (v1 === undefined || v2 === undefined) {
				result= (v1 === undefined ? 1 : 0) - (v2 === undefined ? 1 : 0);
			} else {
				result= attribute.getAttributeType().compareValues(v1, v2) * this.__direction;
			}

			return result != 0 ? result : i2.getId() - i1.getId();
		} else {
			return this.inherited(arguments);
		}
	},
	
	__sentinel: null // terminates this class definition
});

})();
