/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.quickquery.Term"); //$NON-NLS-1$

(function() {

var AND= "AND"; //$NON-NLS-1$
var OR= "OR"; //$NON-NLS-1$
var NOT= "NOT"; //$NON-NLS-1$

dojo.declare("com.ibm.team.apt.shared.ui.internal.quickquery.Term", null, { //$NON-NLS-1$

	__operator: null,
	__expressions: null,
	
	constructor: function(operator) {
		this.__operator= operator;
		this.__expressions= [];
		for (var i= 1; i < arguments.length; i++) {
			this.__expressions.push(arguments[i]);
		}
	},
	
	// ---- API ------------------------------------------------------------------------------------------------------------

	evaluate: function(planItem) {
		if (this.__expressions.length == 0)
			return false;
		
		var i;
		
		switch (this.__operator) {
			case NOT:
				return !this.__expressions[0].evaluate(planItem);
			case OR:
				for (i = 0; i < this.__expressions.length; i++) {
					if (this.__expressions[i].evaluate(planItem))
						return true;
				}
				return false;
			case AND:
				for (i = 0; i < this.__expressions.length; i++) {
					if (!this.__expressions[i].evaluate(planItem))
						return false;
				}
				return true;
			default:
				throw new Error("unexpected operator for Term"); //$NON-NLS-1$
		}
	},
	
	add: function(expression) {
		this.__expressions.push(expression);
	},
	
	equals: function(other) {
		if (this === other)
			return true;

		if (other == null)
			return false;

		if (this.declaredClass !== other.declaredClass)
			return false;

		if (this.__operator != other.__operator)
			return false;
		
		if (this.__expressions.length != other.__expressions.length)
			return false;
			
		for (var i= 0; i < this.__expressions.length; i++) {
			if (!this.__expressions[i].equals(other.__expressions[i]))
				return false;
		}

		return true;
	},
	
	__sentinel: null // terminates this class definition
});

com.ibm.team.apt.shared.ui.internal.quickquery.Term.AND= AND;
com.ibm.team.apt.shared.ui.internal.quickquery.Term.OR= OR;
com.ibm.team.apt.shared.ui.internal.quickquery.Term.NOT= NOT;

})();
