/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.quickquery.QuickQueryDefinition"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeType"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.internal.quickquery.Term"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.internal.quickquery.AttributeCondition"); //$NON-NLS-1$

(function() {

var PlanItem						= com.ibm.team.apt.client.PlanItem;
var PlanningAttributeType			= com.ibm.team.apt.client.PlanningAttributeType;
var Term							= com.ibm.team.apt.shared.ui.internal.quickquery.Term;
var AttributeCondition				= com.ibm.team.apt.shared.ui.internal.quickquery.AttributeCondition;

var OR_ATTRIBUTE_TYPES= [
	PlanningAttributeType.INTEGER,
	PlanningAttributeType.BOOLEAN,
	PlanningAttributeType.INSTANT,
	PlanningAttributeType.DURATION,
	PlanningAttributeType.TIMESPAN,
	PlanningAttributeType.WORKITEM_TYPE,
	PlanningAttributeType.ITEM,
	PlanningAttributeType.ENUMERATION
];

dojo.declare("com.ibm.team.apt.shared.ui.internal.quickquery.QuickQueryDefinition", null, { //$NON-NLS-1$

	__getPlanFn: null,
	
	constructor: function(getPlanFn) {
		this.__getPlanFn= getPlanFn;
	},
	
	// ---- API ------------------------------------------------------------------------------------------------------------

	getWordExpression: function(keyword) {
		var result= new Term(Term.OR);

		var plan= this.__getPlanFn();
		
		result.add(new AttributeCondition(this.__findAttribute(PlanItem.SUMMARY), "=", keyword, plan)); //$NON-NLS-1$
		result.add(new AttributeCondition(this.__findAttribute(PlanItem.DESCRIPTION), "=", keyword, plan)); //$NON-NLS-1$
		
		if (!isNaN(Number(keyword))) {
			result.add(new AttributeCondition(this.__findAttribute(PlanItem.ID), "=", keyword, plan)); //$NON-NLS-1$
		}

		return result;
	},
	
	getAttributeExpression: function(attribute, operator, parameters) {
		var planAttribute= this.__findAttributeByQueryId(attribute);
		return planAttribute ? new AttributeCondition(planAttribute, operator, parameters, this.__getPlanFn()) : null;
	},
	
	getAttributeCombination: function(attribute) {
		var result= Term.AND;
		var planAttribute= this.__findAttributeByQueryId(attribute);

		if (planAttribute) {
			if (dojo.some(OR_ATTRIBUTE_TYPES, function(type) { return type.equals(planAttribute.getAttributeType()); } )) {
				result= Term.OR;
			}
		}

		return result;
	},

	getAllAttributes: function() {
		return this.__getPlanFn().getAllAttributes();
	},

	getAttribute: function(attribute) {
		return this.__findAttributeByQueryId(attribute);
	},
	
	getPlan: function() {
		return this.__getPlanFn();
	},

	// ---- implementation -------------------------------------------------------------------------------------------------
	
	__findAttributeByQueryId: function(attributeQueryId) {
		var attributes= this.__getPlanFn().getAllAttributes();
		for (var i= 0; i < attributes.length; i++) {
			if (attributeQueryId == attributes[i].getQueryId()) {
				return attributes[i];
			}
		}
		return null;
	},
	
	__findAttribute: function(attributeId) {
		return this.__getPlanFn().findAttribute(attributeId);
	},
	
	__sentinel: null // terminates this class definition
});


})();
