/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.quickquery.ProposalMatcher"); //$NON-NLS-1$

dojo.require("dojo.regexp"); //$NON-NLS-1$

(function() {

dojo.declare("com.ibm.team.apt.shared.ui.internal.quickquery.ProposalMatcher", null, { //$NON-NLS-1$

	__input: null,
	__camelCaseMatcher: null,
	
	constructor: function(input) {
		if (input != null && input.length > 0) {
			var camelCaseRegExp= "^"; //$NON-NLS-1$
			for (var i= 0; i < input.length; i++) {
				var start= i;
				while (++i < input.length && input.charAt(i) === input.charAt(i).toLowerCase()) {
					/* intentionally empty */
				}
				camelCaseRegExp+= dojo.regexp.escapeString(input.substring(start, i--));
				camelCaseRegExp+= "[^A-Z]*"; //$NON-NLS-1$
			}
			camelCaseRegExp+= ".*$"; //$NON-NLS-1$
	
			this.__camelCaseMatcher= new RegExp(camelCaseRegExp);
			this.__input= input.toLowerCase();
		} 
	},
	
	// ---- API ------------------------------------------------------------------------------------------------------------

	matches: function(proposal) {
		if (this.__input == null)
			return true;
		
		if (proposal.toLowerCase().indexOf(this.__input) == 0)
			return true;
		
		return this.__camelCaseMatcher.test(proposal);
	},

	
	__sentinel: null // terminates this class definition
});

})();

