/******************************************************************************
 Licensed Materials - Property of IBM
 © Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 
 Note to U.S. Government Users Restricted Rights:
 Use, duplication or disclosure restricted by GSA ADP Schedule
 Contract with IBM Corp.
 ******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.ui.internal.quickqueries.Term");

dojo.require("com.ibm.jdojo.util.Assert");

(function() {
var Assert= com.ibm.jdojo.util.Assert;

dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries.Term", null, {
	"-chains-": { constructor: "manual" },

	//fOperator: null,

	//fExpressions: null,

	constructor: function(operator /*, subterms... */ ) {
		var subterms= Array.prototype.slice.call(arguments, 1);
		this.fExpressions= [];
		this.fOperator= operator;
		var $subject= subterms;
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var subterm= $subject[$count];
			this.fExpressions.push(subterm);
		}
	},

	evaluate: function(planItem) {
		if (this.fExpressions.length === 0) 
			return false;
		switch(this.fOperator) {
			case Operator.NOT:
				if (!this.fExpressions[0].canEvaluate(planItem)) {
					return false;
				}
				return !this.fExpressions[0].evaluate(planItem);
			case Operator.OR:
				for (var i= 0; i < this.fExpressions.length; i++){
					if (this.fExpressions[i].evaluate(planItem)) 
						return true;
				}
				return false;
			case Operator.AND:
				for (var i= 0; i < this.fExpressions.length; i++){
					if (!this.fExpressions[i].evaluate(planItem)) 
						return false;
				}
				return true;
		}
		if (!(false)) Assert.fail("unexpected operator for Term", "Term:60");
		return false;
	},

	add: function(expression) {
		this.fExpressions.push(expression);
	},

	isEqual: function(other) {
		if (this === other) 
			return true;
		if (other == null) 
			return false;
		if (this.constructor !== other.constructor) 
			return false;
		if (this.fOperator !== other.fOperator) 
			return false;
		if (this.fExpressions.length !== other.fExpressions.length) 
			return false;
		for (var i= 0; i < this.fExpressions.length; i++){
			if (!this.fExpressions[i].isEqual(other.fExpressions[i])) 
				return false;
		}
		return true;
	},

	getDependentAttributes: function() {
		var result= [];
		var $subject2= this.fExpressions;
		var $length2= $subject2.length;
		for (var $count2= 0; $count2 < $length2; $count2++){
			var evaluatable= $subject2[$count2];
			Array.prototype.push.apply(result, evaluatable.getDependentAttributes());
		}
		return result;
	},

	getOperator: function() {
		return this.fOperator;
	},

	getSubConditions: function() {
		return this.fExpressions;
	},

	canEvaluate: function(planItem) {
		return true;
	},

	$interfaces: {
		'com.ibm.team.apt.api.client.IPlanningAttributeDependent': true,
		'com.ibm.team.apt.api.ui.quickquery.IQuickQueryCondition': true
	}
});
var Operator= dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries.Term.Operator", null, {

	compareTo: function(other) {
		return this.ordinal - other.ordinal;
	}
});

Operator.values= [
	dojo.mixin(new Operator(), {
		name: 'AND',
		ordinal: 0
	}),
	dojo.mixin(new Operator(), {
		name: 'OR',
		ordinal: 1
	}),
	dojo.mixin(new Operator(), {
		name: 'NOT',
		ordinal: 2
	})
];
Operator.AND= Operator.values[0];
Operator.OR= Operator.values[1];
Operator.NOT= Operator.values[2];

})();
