/*******************************************************************************
 * Licensed Materials - Property of IBM
 * © Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp. 
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryProposal");

dojo.require("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryUtil");

(function() {
var QuickQueryUtil= com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryUtil;

var QuickQueryProposal= dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryProposal", null, {
	"-chains-": { constructor: "manual" },

	//fAttribute: null,

	//fOperator: null,

	//fParameter: null,

	fStart: 0,

	fEnd: 0,

	//fAttributeMatched: null,

	constructor: function(attribute, operator, parameter, start, end, attributeMatched) {
		this.fAttribute= attribute;
		this.fOperator= operator == null ? QuickQueryProposal.DEFAULT_OPERATIOR : operator;
		this.fParameter= parameter;
		this.fStart= start;
		this.fEnd= end;
		this.fAttributeMatched= attributeMatched;
	},

	getStart: function() {
		return this.fStart;
	},

	getEnd: function() {
		return this.fEnd;
	},

	compareTo: function(other) {
		var value= (this.fParameter == null ? 0 : 1) - (other.fParameter == null ? 0 : 1);
		if (value === 0) {
			if (this.fAttribute.getId() !== other.fAttribute.getId()) {
				value= this.fAttribute.getDescription().getLabel().localeCompare(other.fAttribute.getDescription().getLabel());
			}
		}
		return value;
	},

	getLabel: function() {
		return this.withParameter(QuickQueryUtil.getLabel(this.fAttribute));
	},

	withParameter: function(text) {
		if (this.fAttributeMatched && this.fParameter != null) 
			return this.fParameter;
		var result= text;
		result+= this.fOperator;
		if (this.fParameter != null) {
			result+= this.fParameter;
		}
		return result;
	},

	getCursorPosition: function() {
		return this.getLabel().length;
	}
});

QuickQueryProposal.DEFAULT_OPERATIOR= ":";

})();
