/******************************************************************************
 Licensed Materials - Property of IBM
 © Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 
 Note to U.S. Government Users Restricted Rights:
 Use, duplication or disclosure restricted by GSA ADP Schedule
 Contract with IBM Corp.
 ******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryParser");

dojo.require("com.ibm.jdojo.lang.Runtime");
dojo.require("com.ibm.jdojo.lang.RuntimeException");
dojo.require("com.ibm.team.apt.api.common.planning.PlanningAttributeType");
dojo.require("com.ibm.team.apt.api.ui.quickquery.IQuickQueryCondition");
dojo.require("com.ibm.team.apt.shared.ui.internal.quickqueries.ParameterProposalBuilder");
dojo.require("com.ibm.team.apt.shared.ui.internal.quickqueries.ProposalMatcher");
dojo.require("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryProposal");
dojo.require("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryUtil");
dojo.require("com.ibm.team.apt.shared.ui.internal.quickqueries.Term");
dojo.require("dojo.i18n");

dojo.requireLocalization("com.ibm.team.apt.shared.ui.internal.quickqueries", "Messages");

(function() {
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.shared.ui.internal.quickqueries", "Messages");

var lang= com.ibm.jdojo.lang;
var jdojo= lang.Runtime;
var RuntimeException= lang.RuntimeException;
var apt= com.ibm.team.apt;
var api= apt.api;
var PlanningAttributeType= api.common.planning.PlanningAttributeType;
var IQuickQueryCondition= api.ui.quickquery.IQuickQueryCondition;
var quickqueries= apt.shared.ui.internal.quickqueries;
var ParameterProposalBuilder= quickqueries.ParameterProposalBuilder;
var ProposalMatcher= quickqueries.ProposalMatcher;
var QuickQueryProposal= quickqueries.QuickQueryProposal;
var QuickQueryUtil= quickqueries.QuickQueryUtil;
var Term= quickqueries.Term;
var Operator= Term.Operator;

var QuickQueryParser= dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryParser", null, {
	"-chains-": { constructor: "manual" },

	//fSampleCallback: null,

	//fIsErrorFlow: null,

	//fQuickQueryDefinition: null,

	constructor: function(quickQueryDefinition) {
		this.fQuickQueryDefinition= quickQueryDefinition;
	},

	getExpression: function(input) {
		return this.getExpressionForExclusion(input, false);
	},

	getExpressionForExclusion: function(input, isExclusion) {
		var result= new Term(Operator.AND);
		var hasExpressions= false;
		var parsed= this.doParse(input);
		var expressionByAttribute= {};
		for (var i= 0; i < parsed.length; i++){
			var element= parsed[i];
			if (element instanceof ParsedKeyword) {
				var expression= this.fQuickQueryDefinition.getWordExpression(element.keyword);
				result.add(element.negate ? new Term(Operator.NOT, expression) : expression);
				hasExpressions= true;
			} else if (element instanceof ParsedAttribute) {
				var expression= this.fQuickQueryDefinition.getAttributeExpression(element.attribute, element.operator, element.parameterKey, element.parameterValue);
				if (expression != null) {
					if (element.negate) 
						expression= new Term(Operator.NOT, expression);
					var expressions= expressionByAttribute[element.attribute];
					if (expressions == null) {
						expressions= [];
						expressionByAttribute[element.attribute]= expressions;
					}
					expressions.push(expression);
				} else {
				}
			} else {
			}
		}
		var keys= jdojo.getProperties(expressionByAttribute);
		var $subject= keys;
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var attributeId= $subject[$count];
			var expressions= expressionByAttribute[attributeId];
			var expressionRoot= result;
			if (this.fQuickQueryDefinition.getAttributeCombinationForExclusion(attributeId, isExclusion) === Operator.OR && expressions.length > 1) {
				expressionRoot= new Term(Operator.OR);
				result.add(expressionRoot);
			}
			var $subject2= expressions;
			var $length2= $subject2.length;
			for (var $count2= 0; $count2 < $length2; $count2++){
				var expression= $subject2[$count2];
				expressionRoot.add(expression);
			}
			hasExpressions= true;
		}
		return hasExpressions ? result : null;
	},

	evaluateExpression: function(input) {
		this.fIsErrorFlow= true;
		var parsed= this.doParse(input);
		this.fIsErrorFlow= false;
		for (var i= 0; i < parsed.length; i++){
			var element= parsed[i];
			if (element instanceof ParsedAttribute) {
				var attribute= this.fQuickQueryDefinition.getAttribute(element.attribute);
				if (attribute != null) {
					switch(attribute.getDescription().getAttributeType()) {
						case PlanningAttributeType.INSTANT:
							var value= this.validateDateExpressions(element.parameterValue);
							if (value == null) 
								continue;
							else 
								return value;
					}
				}
			}
		}
		return null;
	},

	isLessThanExpression: function(expression) {
		return expression.indexOf("<") >= 0;
	},

	isGreaterThanExpression: function(expression) {
		return expression.indexOf(">") >= 0;
	},

	validateDateExpressions: function(expression) {
		if (expression != null && expression.length > 0) {
			var validationTokens= expression.match(QuickQueryParser.RELATIVE_DATE_REGEX);
			validationTokens= (validationTokens == null) ? expression.match(QuickQueryParser.ABSOLUTE_DATE_REGEX) : validationTokens;
			if (validationTokens == null) {
				return Messages.QuickQueryParser_ERROR_MESSAGE + "<br />" + "(" + Messages.QuickQueryParser_SAMPLE_DATE_EXPRESSION_TEXT_1 + QuickQueryParser.ERROR_MESSAGE_SAMPLE + ")";
			}
		}
		return null;
	},

	getContentProposals: function(input, position) {
		var parsed= this.doParse(input);
		var currentPredicate= null;
		for (var i= 0; i < parsed.length; i++){
			var element= parsed[i];
			if (element.start < position && element.end >= position) {
				currentPredicate= element;
				break;
			}
		}
		var result= [];
		if (currentPredicate != null) {
			var attributeStart= currentPredicate.start;
			var attributeEnd= currentPredicate.end;
			if (currentPredicate instanceof ParsedAttribute) {
				attributeStart= currentPredicate.attributeStart;
				attributeEnd= currentPredicate.attributeEnd;
			}
			if (position <= attributeEnd) {
				var attributeMatcher= new ProposalMatcher(input.substring(attributeStart, position));
				this.withQueryableAttributes(function(attribute) {
					if (attributeMatcher.matches(QuickQueryUtil.getLabel(attribute))) {
						var proposal= new QuickQueryProposal(attribute, null, null, currentPredicate.start, currentPredicate.end, true);
						result.push(proposal);
						if (attribute.getDescription().getAttributeType() === PlanningAttributeType.INSTANT) {
							result.push(new QuickQueryProposal(attribute, "<", null, currentPredicate.start, currentPredicate.end, true));
							result.push(new QuickQueryProposal(attribute, ">", null, currentPredicate.start, currentPredicate.end, true));
						}
					}
					var candidates= new ParameterProposalBuilder().getProposals(attribute);
					var $subject3= candidates;
					var $length3= $subject3.length;
					for (var $count3= 0; $count3 < $length3; $count3++){
						var candidate= $subject3[$count3];
						if (attributeMatcher.matches(String(candidate))) {
							var proposal= new QuickQueryProposal(attribute, null, String(candidate), currentPredicate.start, currentPredicate.end, false);
							result.push(proposal);
						}
					}
				});
			} else if (currentPredicate instanceof ParsedAttribute) {
				var parsedAttribute= currentPredicate;
				this.withQueryableAttributes(dojo.hitch(this, function(attribute) {
					if (QuickQueryUtil.getLabel(attribute) === parsedAttribute.attribute) {
						var candidates= new ParameterProposalBuilder().getProposals(attribute);
						var prefix= null;
						if (position > parsedAttribute.parameterStart) {
							prefix= input.substring(parsedAttribute.parameterStart, position);
						}
						var matcher= new ProposalMatcher(prefix);
						var $subject4= candidates;
						var $length4= $subject4.length;
						for (var $count4= 0; $count4 < $length4; $count4++){
							var candiate= $subject4[$count4];
							if (matcher.matches(String(candiate))) {
								var proposal;
								if (this.isLessThanExpression(input)) {
									proposal= new QuickQueryProposal(attribute, "<", String(candiate), currentPredicate.start, currentPredicate.end, false);
								} else if (this.isGreaterThanExpression(input)) {
									proposal= new QuickQueryProposal(attribute, ">", String(candiate), currentPredicate.start, currentPredicate.end, false);
								} else {
									proposal= new QuickQueryProposal(attribute, null, String(candiate), currentPredicate.start, currentPredicate.end, false);
								}
								result.push(proposal);
							}
						}
					}
				}));
			}
		} else {
			this.withQueryableAttributes(function(attribute) {
				var proposal= new QuickQueryProposal(attribute, null, null, position, position, false);
				result.push(proposal);
			});
		}
		result.sort(function(left, right) {
			return left.compareTo(right);
		});
		return result;
	},

	withQueryableAttributes: function(code) {
		var $subject5= this.fQuickQueryDefinition.getAllAttributes();
		var $length5= $subject5.length;
		for (var $count5= 0; $count5 < $length5; $count5++){
			var attribute= $subject5[$count5];
			if (QuickQueryUtil.getLabel(attribute) != null) {
				code(attribute);
			}
		}
	},

	setSampleCallback: function(sampleCallback) {
		this.fSampleCallback= sampleCallback;
	},

	doParse: function(input) {
		var result= [];
		var chars= new _CharSequenceIterator(input);
		var attribute;
		var negate= false;
		var posElementStart= -1;
		var maxLoops= input.length;
		while(chars.hasNext()){
			if (maxLoops-- === 0) {
				break;
			}
			if (QuickQueryParser.skipWhitespace(chars)) 
				continue;
			if (posElementStart === -1) 
				posElementStart= chars.getIndex();
			var c= chars.next();
			if (c === "!" || c === "-" || c === "+") {
				negate= c === "-" || c === "!";
				continue;
			} else {
				chars.pushback();
			}
			var foundOperation= false;
			var posOperationNameStart= chars.getIndex();
			var keyword= QuickQueryParser.parseWord(chars);
			if (keyword != null && chars.hasNext()) {
				var posOperationNameEnd= chars.getIndex();
				var operator= null;
				var operatorChar= String(chars.next());
				var $subject6= Operators.values;
				var $length6= $subject6.length;
				for (var $count6= 0; $count6 < $length6; $count6++){
					var candidateOperator= $subject6[$count6];
					if (candidateOperator.fToken === operatorChar) {
						if ((operatorChar === Operators.Default.fToken) && chars.hasNext()) {
							if (input.indexOf(":<") > 0) {
								operator= Operators.Lt;
							} else if (input.indexOf(":>") > 0) {
								operator= Operators.Gt;
							} else {
								operator= Operators.Default;
							}
							break;
						}
						operator= candidateOperator;
						break;
					}
				}
				if (operator != null) {
					var posAfterColon= chars.getIndex();
					var parameterKey= IQuickQueryCondition.DEFAULT_KEY;
					var parameterValue= QuickQueryParser.parseString(chars);
					if (parameterValue == null) {
						chars.reset(posAfterColon);
						var tuple= QuickQueryParser.parseParameter(chars);
						if (tuple == null) {
							result.push(new ParsedError(Messages.QuickQueryParser_ERROR_INVALID_EXPRESSION, input, posAfterColon, chars.getIndex()));
						} else {
							parameterKey= tuple[0];
							parameterValue= tuple[1];
						}
					}
					var parseResult= new ParsedAttribute(keyword, operator, parameterKey, parameterValue, negate, input, posOperationNameStart, chars.getIndex());
					parseResult.attributeStart= posElementStart;
					parseResult.attributeEnd= posOperationNameEnd;
					parseResult.parameterStart= posAfterColon;
					parseResult.parameterEnd= chars.getIndex();
					attribute= this.fQuickQueryDefinition.getAttribute(parseResult.attribute);
					if (!this.fIsErrorFlow) {
						if (this.fSampleCallback != null && attribute != null) {
							switch(attribute.getDescription().getAttributeType()) {
								case PlanningAttributeType.INSTANT:
									if (this.isLessThanExpression(input)) {
										this.fSampleCallback(Messages.QuickQueryParser_SAMPLE_DATE_EXPRESSION_TEXT_1 + QuickQueryParser.SAMPLE_DATE_EXPRESSION_TEXT_2);
									} else if (this.isGreaterThanExpression(input)) {
										this.fSampleCallback(Messages.QuickQueryParser_SAMPLE_DATE_EXPRESSION_TEXT_1 + QuickQueryParser.SAMPLE_DATE_EXPRESSION_TEXT_3);
									} else {
										this.fSampleCallback(Messages.QuickQueryParser_SAMPLE_DATE_EXPRESSION_TEXT_1 + QuickQueryParser.SAMPLE_DATE_EXPRESSION_TEXT_4);
									}
									break;
								default:
									this.fSampleCallback(null);
							}
						}
					}
					result.push(parseResult);
					foundOperation= true;
				} else {
					chars.pushback();
				}
			} else if (keyword == null) {
				chars.reset(posOperationNameStart);
				keyword= QuickQueryParser.parseString(chars);
			}
			if (!foundOperation) {
				if (keyword != null) {
					result.push(new ParsedKeyword(keyword, negate, input, posOperationNameStart, chars.getIndex()));
				} else if (chars.hasNext()) {
					chars.next();
					result.push(new ParsedError(Messages.QuickQueryParser_ERROR_PARAMETER_EXPECTED, input, posOperationNameStart, chars.getIndex()));
				}
			}
			negate= false;
			posElementStart= -1;
		}
		return result;
	},

	replaceInSegments: function(segments, valueToReplace, replacementValue) {
		var regExStr= "(^|\\W)" + valueToReplace + "($|\\W)";
		var regExp= new RegExp(regExStr);
		for (var i= 0; i < segments.length; i++){
			var segment= segments[i];
			if (regExp.test(segment)) {
				segments[i]= segment.replace(valueToReplace, replacementValue);
			}
		}
	},

	idLabelSwitcher: function(expression, direction) {
		if (expression == null) {
			return null;
		}
		var segments= expression.split((new RegExp("\\s", "g")));
		this.withQueryableAttributes(dojo.hitch(this, function(attribute) {
			if (attribute.getDescription().getAttributeType() === PlanningAttributeType.REFERENCE) {
				var label= QuickQueryUtil.getLabel(attribute);
				var queryId= attribute.getDescription().getQueryId();
				if (queryId != null && label !== queryId) {
					var replacement= direction === LabelSwitcher.TO_LABEL ? label : queryId;
					var valueToReplace= direction === LabelSwitcher.TO_LABEL ? queryId : label;
					this.replaceInSegments(segments, valueToReplace, replacement);
				}
			}
		}));
		return segments.join(" ");
	}
});
var Operators= dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryParser.Operators", null, {

	//fToken: null,

	constructor: function(token) {
		this.fToken= token;
	},

	compareTo: function(other) {
		return this.ordinal - other.ordinal;
	}
});
var ParsedCommon= dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryParser.ParsedCommon", null, {
	"-chains-": { constructor: "manual" },

	start: 0,

	end: 0,

	//text: null,

	constructor: function(input, start, end) {
		this.start= start;
		this.end= end;
		this.text= input.substring(start, end);
	}
});
var ParsedError= dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryParser.ParsedError", ParsedCommon, {

	//errorMessage: null,

	constructor: function(errorMessage, input, start, end) {
		this.inherited(arguments, [input, start, end]);
		this.errorMessage= errorMessage;
	}
});
var ParsedAttribute= dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryParser.ParsedAttribute", ParsedCommon, {

	//attribute: null,

	//operator: null,

	//parameterKey: null,

	//parameterValue: null,

	//negate: null,

	attributeStart: 0,

	attributeEnd: 0,

	parameterStart: 0,

	parameterEnd: 0,

	constructor: function(attribute, operator, parameterKey, parameterValue, negate, input, start, end) {
		this.inherited(arguments, [input, start, end]);
		this.attribute= attribute;
		this.operator= operator;
		this.parameterKey= parameterKey;
		this.parameterValue= parameterValue;
		this.negate= negate;
	}
});
var ParsedKeyword= dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryParser.ParsedKeyword", ParsedCommon, {

	//keyword: null,

	//negate: null,

	constructor: function(keyword, negate, input, start, end) {
		this.inherited(arguments, [input, start, end]);
		this.keyword= keyword;
		this.negate= negate;
	}
});
var LabelSwitcher= dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryParser.LabelSwitcher", null, {

	compareTo: function(other) {
		return this.ordinal - other.ordinal;
	}
});
var _CharSequenceIterator= dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries._CharSequenceIterator", null, {
	"-chains-": { constructor: "manual" },

	//fInput: null,

	fLength: 0,

	fIndex: 0,

	constructor: function(input) {
		this.fInput= input;
		this.fLength= input.length;
		this.fIndex= 0;
	},

	substring: function(start, end) {
		return this.fInput.substring(start, end !== -1 ? end : this.fIndex);
	},

	getIndex: function() {
		return this.fIndex;
	},

	hasNext: function() {
		return this.fIndex < this.fLength;
	},

	next: function() {
		if (this.fIndex >= this.fLength) 
			throw new RuntimeException("StringOutOfBoundsException");
		return this.fInput.charAt(this.fIndex++);
	},

	pushback: function() {
		if (this.fIndex === 0) 
			throw new RuntimeException("StringOutOfBoundsException");
		this.fIndex--;
	},

	reset: function(position) {
		if (position < 0 || position > this.fLength) 
			throw new RuntimeException("StringOutOfBoundsException");
		this.fIndex= position;
	}
});

QuickQueryParser.RELATIVE_DATE_REGEX= new RegExp("^[<|>]?(today([+-][0-9]+)?$)", "g");
QuickQueryParser.ABSOLUTE_DATE_REGEX= new RegExp("^[<|>]?(19|20)[0-9]{2}-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])$", "g");
QuickQueryParser.ERROR_MESSAGE_SAMPLE= " 2013-10-21; <2013-10-21; today-1; >today+1";
QuickQueryParser.SAMPLE_DATE_EXPRESSION_TEXT_2= " &lt;2013-10-21; &lt;today+1";
QuickQueryParser.SAMPLE_DATE_EXPRESSION_TEXT_3= " &gt;2013-10-21; &gt;today+1";
QuickQueryParser.SAMPLE_DATE_EXPRESSION_TEXT_4= " :2013-10-21; :today-1;";
QuickQueryParser.__buildCharMap= function(characters, baseMap) {
	var result= baseMap != null ? dojo.mixin({}, baseMap) : {};
	for (var i= 0; i < characters.length; i++){
		result[String(characters.charAt(i))]= true;
	}
	return result;
};
QuickQueryParser.whitespaceMap= QuickQueryParser.__buildCharMap(" \f\n\r\t", null);
QuickQueryParser.stopCharacterMap= QuickQueryParser.__buildCharMap(":~=<>\"", QuickQueryParser.whitespaceMap);
QuickQueryParser.IDENTIFIER= new RegExp("[a-zA-Z_][\\w]*");
QuickQueryParser.skipWhitespace= function(chars) {
	var result= false;
	while(chars.hasNext()){
		if (!(String(chars.next()) in QuickQueryParser.whitespaceMap)) {
			chars.pushback();
			break;
		}
		result= true;
	}
	return result;
};
QuickQueryParser.parseWord= function(chars) {
	var start= chars.getIndex();
	while(chars.hasNext()){
		if ((String(chars.next()) in QuickQueryParser.stopCharacterMap)) {
			chars.pushback();
			break;
		}
	}
	return start !== chars.getIndex() ? chars.substring(start, -1) : null;
};
QuickQueryParser.parseParameter= function(chars) {
	if (!chars.hasNext()) 
		return null;
	var start= chars.getIndex();
	var first= chars.next();
	if (chars.hasNext()) {
		var key= null;
		var value= null;
		var second= chars.next();
		if (first === "$" && second === "{") {
			var valueStart= start;
			while(chars.hasNext()){
				var next= chars.next();
				if (next === ":") {
					key= chars.substring(start + 2, chars.getIndex() - 1);
					valueStart= chars.getIndex();
					break;
				} else if ((String(next) in QuickQueryParser.whitespaceMap)) {
					break;
				}
			}
			if (key == null) {
				chars.reset(start);
				return null;
			}
			while(chars.hasNext()){
				var next= chars.next();
				if (next === "}") {
					value= chars.substring(valueStart, chars.getIndex() - 1);
					break;
				} else if ((String(next) in QuickQueryParser.whitespaceMap)) {
					break;
				}
			}
			if (value == null) {
				chars.reset(start);
				return null;
			}
			return [key, value];
		} else {
			chars.reset(start);
			return QuickQueryParser.parseLabelParameter(chars);
		}
	} else {
		chars.reset(start);
		return QuickQueryParser.parseLabelParameter(chars);
	}
};
QuickQueryParser.parseLabelParameter= function(chars) {
	var start= chars.getIndex();
	while(chars.hasNext()){
		if ((String(chars.next()) in QuickQueryParser.whitespaceMap)) {
			chars.pushback();
			break;
		}
	}
	return start !== chars.getIndex() ? [IQuickQueryCondition.DEFAULT_KEY, chars.substring(start, -1)] : null;
};
QuickQueryParser.parseString= function(chars) {
	if (!chars.hasNext()) 
		return null;
	var c= chars.next();
	if (c !== "\"") {
		chars.pushback();
		return null;
	}
	var result= "";
	var foundEnd= false;
	while(chars.hasNext()){
		c= chars.next();
		if (c === "\"") {
			foundEnd= true;
			break;
		} else if (c === "\\") {
			if (!chars.hasNext()) 
				return null;
			switch(chars.next()) {
				case "\\":
					result+= "\\";
					break;
				case "\"":
					result+= "\"";
					break;
				case "\'":
					result+= "\'";
					break;
				case "r":
					result+= "\r";
					break;
				case "n":
					result+= "\n";
					break;
				case "t":
					result+= "\t";
					break;
				default:
			}
		} else {
			result+= c;
		}
	}
	return foundEnd ? result : null;
};
Operators.values= [
	dojo.mixin(new Operators(":"), {
		name: 'Default',
		ordinal: 0
	}),
	dojo.mixin(new Operators("~"), {
		name: 'Subtree',
		ordinal: 1
	}),
	dojo.mixin(new Operators("="), {
		name: 'Eq',
		ordinal: 2
	}),
	dojo.mixin(new Operators("<"), {
		name: 'Lt',
		ordinal: 3
	}),
	dojo.mixin(new Operators(">"), {
		name: 'Gt',
		ordinal: 4
	})
];
Operators.Default= Operators.values[0];
Operators.Subtree= Operators.values[1];
Operators.Eq= Operators.values[2];
Operators.Lt= Operators.values[3];
Operators.Gt= Operators.values[4];
LabelSwitcher.values= [
	dojo.mixin(new LabelSwitcher(), {
		name: 'TO_LABEL',
		ordinal: 0
	}),
	dojo.mixin(new LabelSwitcher(), {
		name: 'TO_ID',
		ordinal: 1
	})
];
LabelSwitcher.TO_LABEL= LabelSwitcher.values[0];
LabelSwitcher.TO_ID= LabelSwitcher.values[1];

})();
