/******************************************************************************
 Licensed Materials - Property of IBM
 © Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 
 Note to U.S. Government Users Restricted Rights:
 Use, duplication or disclosure restricted by GSA ADP Schedule
 Contract with IBM Corp.
******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryDefinition");

dojo.require("com.ibm.jdojo.lang.Runtime");
dojo.require("com.ibm.team.apt.api.client.ICmChangeRequest");
dojo.require("com.ibm.team.apt.api.client.IPlanItem");
dojo.require("com.ibm.team.apt.api.common.planning.PlanningAttributeType");
dojo.require("com.ibm.team.apt.api.ui.quickquery.IQuickQueryCondition");
dojo.require("com.ibm.team.apt.shared.ui.internal.quickqueries.AttributeCondition");
dojo.require("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryParser");
dojo.require("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryUtil");
dojo.require("com.ibm.team.apt.shared.ui.internal.quickqueries.Term");

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;
var apt= com.ibm.team.apt;
var api= apt.api;
var client= api.client;
var ICmChangeRequest= client.ICmChangeRequest;
var IPlanItem= client.IPlanItem;
var PlanningAttributeType= api.common.planning.PlanningAttributeType;
var IQuickQueryCondition= api.ui.quickquery.IQuickQueryCondition;
var quickqueries= apt.shared.ui.internal.quickqueries;
var AttributeCondition= quickqueries.AttributeCondition;
var Operators= quickqueries.QuickQueryParser.Operators;
var QuickQueryUtil= quickqueries.QuickQueryUtil;
var Term= quickqueries.Term;
var Operator= Term.Operator;

var QuickQueryDefinition= dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryDefinition", null, {
	"-chains-": { constructor: "manual" },

	//fContext: null,

	//fAttributes: null,

	constructor: function(context) {
		this.fContext= context;
	},

	getWordExpression: function(keyword) {
		var result= new Term(Operator.OR);
		var plan= this.fContext.getPlanModel();
		result.add(new AttributeCondition(plan.findAttribute(IPlanItem.SUMMARY), Operators.Eq, IQuickQueryCondition.DEFAULT_KEY, keyword));
		result.add(new AttributeCondition(plan.findAttribute(IPlanItem.DESCRIPTION), Operators.Eq, IQuickQueryCondition.DEFAULT_KEY, keyword));
		result.add(new AttributeCondition(plan.findAttribute(ICmChangeRequest.DC_TITLE), Operators.Eq, IQuickQueryCondition.DEFAULT_KEY, keyword));
		if (!isNaN(parseInt(keyword))) {
			result.add(new AttributeCondition(plan.findAttribute(IPlanItem.ID), Operators.Eq, IQuickQueryCondition.DEFAULT_KEY, keyword));
		}
		return result;
	},

	getAttributeExpression: function(queryName, operator, key, value) {
		var planAttribute= this.getAttribute(queryName);
		return planAttribute != null ? new AttributeCondition(planAttribute, operator, key, value) : null;
	},

	getAttributeCombination: function(queryName) {
		return this.getAttributeCombinationForExclusion(queryName, false);
	},

	getAttributeCombinationForExclusion: function(queryName, isExclusion) {
		var planAttribute= this.getAttribute(queryName);
		if (planAttribute != null) {
			var orAttributeTypes;
			if (isExclusion) {
				orAttributeTypes= this.getOrAttributeTypesForExclusion();
			} else {
				orAttributeTypes= this.getOrAttributeTypes();
			}
			var $subject= orAttributeTypes;
			var $length= $subject.length;
			for (var $count= 0; $count < $length; $count++){
				var type= $subject[$count];
				if (type === planAttribute.getDescription().getAttributeType()) {
					return Operator.OR;
				}
			}
		}
		return Operator.AND;
	},

	getOrAttributeTypes: function() {
		return QuickQueryDefinition.OR_ATTRIBUTE_TYPES;
	},

	getOrAttributeTypesForExclusion: function() {
		return QuickQueryDefinition.OR_ATTRIBUTE_TYPES_FOR_EXCLUSION;
	},

	shouldReplace: function(existing, newAttr) {
		return (existing.getDescription().getQueryId() == null && newAttr.getDescription().getQueryId() != null);
	},

	getAllAttributes: function() {
		if (this.fAttributes == null) {
			var map= {};
			var $subject2= this.fContext.getPlanModel().getAllAttributes();
			var $length2= $subject2.length;
			for (var $count2= 0; $count2 < $length2; $count2++){
				var attribute= $subject2[$count2];
				var label= QuickQueryUtil.getLabel(attribute);
				if (label != null) {
					if (!(label in map) || this.shouldReplace(map[label], attribute)) {
						map[label]= attribute;
					}
				}
			}
			this.fAttributes= jdojo.getValues(map);
		}
		return this.fAttributes;
	},

	getAttribute: function(attributeQueryId) {
		if (attributeQueryId == null) {
			return null;
		}
		var attributes= this.getAllAttributes();
		var $subject3= attributes;
		var $length3= $subject3.length;
		for (var $count3= 0; $count3 < $length3; $count3++){
			var attribute= $subject3[$count3];
			if (attribute.getDescription().getAttributeType() === PlanningAttributeType.REFERENCE) {
				if (attributeQueryId === QuickQueryUtil.getLabel(attribute)) {
					return attribute;
				}
			}
		}
		var $subject4= attributes;
		var $length4= $subject4.length;
		for (var $count4= 0; $count4 < $length4; $count4++){
			var attribute= $subject4[$count4];
			if (attribute.getDescription().getQueryId() === attributeQueryId) {
				return attribute;
			}
		}
		return null;
	}
});

QuickQueryDefinition.OR_ATTRIBUTE_TYPES= [PlanningAttributeType.INTEGER, PlanningAttributeType.BOOLEAN, PlanningAttributeType.INSTANT, PlanningAttributeType.DURATION, PlanningAttributeType.TIMESPAN, PlanningAttributeType.WORKITEM_TYPE, PlanningAttributeType.ITEM, PlanningAttributeType.ENUMERATION, PlanningAttributeType.TAGS];
QuickQueryDefinition.OR_ATTRIBUTE_TYPES_FOR_EXCLUSION= [PlanningAttributeType.INTEGER, PlanningAttributeType.BOOLEAN, PlanningAttributeType.INSTANT, PlanningAttributeType.DURATION, PlanningAttributeType.TIMESPAN, PlanningAttributeType.WORKITEM_TYPE, PlanningAttributeType.ITEM, PlanningAttributeType.ENUMERATION];

})();
