/******************************************************************************
 Licensed Materials - Property of IBM
 (c) Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 
 Note to U.S. Government Users Restricted Rights:
 Use, duplication or disclosure restricted by GSA ADP Schedule
 Contract with IBM Corp.
******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.ui.internal.quickqueries.ProposalMatcher");

dojo.require("dojo.regexp");

(function() {
var regexp= dojo.regexp;

dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries.ProposalMatcher", null, {
	"-chains-": { constructor: "manual" },

	//fInput: null,

	//fCamelCaseMatcher: null,

	constructor: function(input) {
		if (input != null && input.length > 0) {
			var camelCaseRegExp= "^";
			for (var i= 0; i < input.length; i++){
				var start= i;
				while(++i < input.length && String(input.charAt(i)) === String(input.charAt(i)).toLowerCase()){
				}
				camelCaseRegExp+= regexp.escapeString(input.substring(start, i--));
				camelCaseRegExp+= "[^A-Z]*";
			}
			camelCaseRegExp+= ".*$";
			this.fCamelCaseMatcher= new RegExp(camelCaseRegExp);
			this.fInput= input.toLowerCase();
		}
	},

	matches: function(proposal) {
		if (this.fInput == null) 
			return true;
		if (proposal.toLowerCase().indexOf(this.fInput) === 0) 
			return true;
		return this.fCamelCaseMatcher.test(proposal);
	}
});

})();
