/*******************************************************************************
 * Licensed Materials - Property of IBM
 * © Copyright IBM Corporation 2015, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp. 
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.ui.internal.quickqueries.ParameterProposalBuilder");

dojo.require("com.ibm.jdojo.lang.Runtime");
dojo.require("com.ibm.team.apt.api.common.planning.PlanningAttributeType");
dojo.require("dojo.string");

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;
var PlanningAttributeType= com.ibm.team.apt.api.common.planning.PlanningAttributeType;
var string= dojo.string;

var ParameterProposalBuilder= dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries.ParameterProposalBuilder", null, {
	"-chains-": { constructor: "manual" },

	getProposals: function(attribute) {
		var result= this.getProposalsByType(attribute);
		return (result == null) ? ParameterProposalBuilder.NO_PROPOSALS : result;
	},

	considerOnlyUIItems: function(values) {
		var items= dojo.filter(values, function(element, index, array) {
			return (jdojo.implementsInterface(element, "com.ibm.team.apt.api.common.IUIItem"));
		});
		return items;
	},

	containsWhitespace: function(label) {
		var catchWhitespace= new RegExp("\\s");
		var matches= label.match(catchWhitespace);
		return (matches != null && matches.length > 0);
	},

	getProposalsByType: function(attribute) {
		var type= this.getType(attribute);
		switch(type) {
			case PlanningAttributeType.ITEM:
			case PlanningAttributeType.WORKITEM_TYPE:
			case PlanningAttributeType.ENUMERATION:
			case PlanningAttributeType.WORKFLOW_STATE:
				return this.handleValueSetProposals(attribute);
			case PlanningAttributeType.REFERENCE:
				return ParameterProposalBuilder.REFERENCE_PROPOSALS;
			case PlanningAttributeType.BOOLEAN:
				return ParameterProposalBuilder.BOOLEAN_PROPOSALS;
			case PlanningAttributeType.INSTANT:
				return ParameterProposalBuilder.INSTANT_PROPOSALS;
		}
		return null;
	},

	getProposalFromUIItem: function(item) {
		var label= item.getLabel();
		return (label == null) ? null : this.wrapLabelIfMultiWord(label);
	},

	getType: function(attribute) {
		if (attribute.getDescription() != null) {
			return attribute.getDescription().getAttributeType();
		}
		return null;
	},

	handleValueSetProposals: function(attribute) {
		var valueSet= attribute.getValueSet(null);
		return (valueSet == null) ? null : this.mapValueSetToProposals(valueSet);
	},

	mapUIItemsToProposals: function(items) {
		var result= [];
		var visited= {};
		var $subject= items;
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var item= $subject[$count];
			var proposal= this.getProposalFromUIItem(item);
			if (proposal != null && !(proposal in visited)) {
				visited[proposal]= true;
				result.push(proposal);
			}
		}
		return result;
	},

	mapValueSetToProposals: function(valueSet) {
		var allValues= valueSet.getAllValues();
		return (allValues == null) ? null : this.mapValuesToProposals(allValues);
	},

	mapValuesToProposals: function(values) {
		var items= this.considerOnlyUIItems(values);
		return this.mapUIItemsToProposals(items);
	},

	wrapLabelIfMultiWord: function(label) {
		if (label != null && this.containsWhitespace(label)) {
			return string.substitute(ParameterProposalBuilder.QUOTE_FORMAT, [label ]);
		}
		return label;
	}
});

ParameterProposalBuilder.BOOLEAN_PROPOSALS= [String(true), String(false)];
ParameterProposalBuilder.INSTANT_PROPOSALS= ["today", "today+", "today-"];
ParameterProposalBuilder.REFERENCE_PROPOSALS= [String(1), "set", "unset"];
ParameterProposalBuilder.NO_PROPOSALS= [];
ParameterProposalBuilder.QUOTE_FORMAT= "\"${0}\"";

})();
