/******************************************************************************
 Licensed Materials - Property of IBM
 © Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 
 Note to U.S. Government Users Restricted Rights:
 Use, duplication or disclosure restricted by GSA ADP Schedule
 Contract with IBM Corp.
******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.ui.internal.quickqueries.AttributeCondition");

dojo.require("com.ibm.jdojo.lang.Runtime");
dojo.require("com.ibm.jdojo.util.Assert");
dojo.require("com.ibm.team.apt.api.common.planning.PlanningAttributeType");
dojo.require("com.ibm.team.apt.api.ui.quickquery.IQuickQueryCondition");
dojo.require("com.ibm.team.apt.shared.client.internal.model.attributes.DirtyAttribute");
dojo.require("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryParser");
dojo.require("com.ibm.team.workitem.shared.common.BigDecimal");

(function() {
var jdojo2= com.ibm.jdojo;
var jdojo= jdojo2.lang.Runtime;
var Assert= jdojo2.util.Assert;
var team= com.ibm.team;
var apt= team.apt;
var api= apt.api;
var PlanningAttributeType= api.common.planning.PlanningAttributeType;
var IQuickQueryCondition= api.ui.quickquery.IQuickQueryCondition;
var shared= apt.shared;
var DirtyAttributes= shared.client.internal.model.attributes.DirtyAttribute.DirtyAttributes;
var QuickQueryParser= shared.ui.internal.quickqueries.QuickQueryParser;
var Operators= QuickQueryParser.Operators;
var BigDecimal= team.workitem.shared.common.BigDecimal;

var AttributeCondition= dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries.AttributeCondition", null, {
	"-chains-": { constructor: "manual" },

	//fAttribute: null,

	//fOperator: null,

	//fValue: null,

	//fEvaluator: null,

	//fKey: null,

	//fStringValue: null,

	constructor: function(attribute, operator, key, value) {
		this.fAttribute= attribute;
		this.fOperator= operator;
		this.fKey= key;
		this.fStringValue= value;
		this.fEvaluator= this.getEvaluator();
	},

	evaluate: function(planItem) {
		if (this.fValue == null) {
			this.fValue= this.fEvaluator.convertQueryValue(this.fAttribute, this.fStringValue != null ? this.fStringValue : AttributeCondition.EMPTY);
			if (this.fValue == null) 
				return false;
		}
		var itemValue= planItem.getAttributeValue(this.fAttribute);
		return itemValue !== undefined ? this.fEvaluator.doEvaluate(this.fOperator, this.fKey, this.fValue, itemValue, planItem) : false;
	},

	canEvaluate: function(planItem) {
		return planItem.getAttributeValue(this.fAttribute) !== undefined;
	},

	getDependentAttributes: function() {
		return [this.fAttribute];
	},

	getOperator: function() {
		return this.fOperator;
	},

	getValue: function() {
		return this.fStringValue;
	},

	getEvaluator: function() {
		switch(this.fAttribute.getDescription().getAttributeType()) {
			case PlanningAttributeType.STRING:
			case PlanningAttributeType.HTML:
				return Evaluators.String;
			case PlanningAttributeType.TAGS:
				return Evaluators.Tags;
			case PlanningAttributeType.INTEGER:
			case PlanningAttributeType.FLOAT:
				return Evaluators.Number;
			case PlanningAttributeType.DECIMAL:
				return Evaluators.Decimal;
			case PlanningAttributeType.BOOLEAN:
				return Evaluators.Boolean;
			case PlanningAttributeType.INSTANT:
				return Evaluators.Instant;
			case PlanningAttributeType.DURATION:
				return Evaluators.Duration;
			case PlanningAttributeType.ITEM:
			case PlanningAttributeType.WORKITEM_TYPE:
				return Evaluators.Item;
			case PlanningAttributeType.WORKFLOW_STATE:
				return Evaluators.State;
			case PlanningAttributeType.WORKFLOW_RESOLUTION:
				return Evaluators.Resolution;
			case PlanningAttributeType.ENUMERATION:
				return Evaluators.Enumeration;
			case PlanningAttributeType.CHECKERREPORT:
				return Evaluators.ProblemReport;
			case PlanningAttributeType.REFERENCE:
				return Evaluators.Reference;
			default:
				return Evaluators.False;
		}
	},

	/** 
	 * Return an empty list; an attribute condition is always a leaf
	 */
	getSubConditions: function() {
		return [];
	},

	isEqual: function(other) {
		if (this === other) 
			return true;
		if (this.constructor !== other.constructor) 
			return false;
		if (this.fAttribute.getId() === other.fAttribute.getId()) 
			return false;
		if (this.fOperator !== other.fOperator) 
			return false;
		if (this.fEvaluator !== other.fEvaluator) 
			return false;
		if (this.fAttribute.getDescription().getAttributeType() === PlanningAttributeType.ENUMERATION) {
			return this.fValue.getLabel() === other.fValue.getLabel();
		} else {
			return this.fValue === other.fValue;
		}
	},

	$interfaces: {
		'com.ibm.team.apt.api.client.IPlanningAttributeDependent': true,
		'com.ibm.team.apt.api.ui.quickquery.IQuickQueryCondition': true
	}
});
var InstantExpressionOperation= dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries.AttributeCondition.InstantExpressionOperation", null, {

	//fOperationType: null,

	constructor: function(operationType) {
		this.fOperationType= operationType;
	},

	getOperationType: function() {
		return this.fOperationType;
	},

	compareTo: function(other) {
		return this.ordinal - other.ordinal;
	}
});
var Evaluators= dojo.declare("com.ibm.team.apt.shared.ui.internal.quickqueries.AttributeCondition.Evaluators", null, {

	doEvaluate: function(operator, key, queryValue, itemValue, planItem) {
		Assert.isTrue(false, "Abstract method 'doEvaluate' invoked");
	},

	convertQueryValue: function(attribute, value) {
		Assert.isTrue(false, "Abstract method 'convertQueryValue' invoked");
	},

	compareTo: function(other) {
		return this.ordinal - other.ordinal;
	}
});

AttributeCondition.ID_KEY= "id";
AttributeCondition.EMPTY= "";
AttributeCondition.CURRENT_USER= "currentuser";
InstantExpressionOperation.values= [
	dojo.mixin(new InstantExpressionOperation("="), {
		name: 'Equal',
		ordinal: 0
	}),
	dojo.mixin(new InstantExpressionOperation("<"), {
		name: 'LessThan',
		ordinal: 1
	}),
	dojo.mixin(new InstantExpressionOperation(">"), {
		name: 'GreaterThan',
		ordinal: 2
	})
];
InstantExpressionOperation.Equal= InstantExpressionOperation.values[0];
InstantExpressionOperation.LessThan= InstantExpressionOperation.values[1];
InstantExpressionOperation.GreaterThan= InstantExpressionOperation.values[2];
Evaluators.values= [
	dojo.mixin(new Evaluators(), {
		name: 'Boolean',
		ordinal: 0,
		doEvaluate: function(operator, key, queryValue, itemValue, planItem) {
			if (itemValue instanceof DirtyAttributes) {
				return (itemValue.isDirty()) === queryValue;
			} else if (jdojo.implementsInterface(itemValue, "com.ibm.team.apt.api.common.planning.IPlanInclusion")) {
				return itemValue.isIncluded() === queryValue;
			}
			return queryValue === itemValue;
		},
		convertQueryValue: function(attribute, value) {
			return value != null && value.toLowerCase() === "true";
		}
	}),
	dojo.mixin(new Evaluators(), {
		name: 'Duration',
		ordinal: 1,
		doEvaluate: function(operator, key, queryValue, itemValue, planItem) {
			var numberValue= queryValue;
			if (numberValue === -1) 
				return !itemValue.isSpecified();
			if (numberValue === -2) 
				return itemValue.isSpecified();
			if (!isNaN(queryValue) && itemValue != null && itemValue.isSpecified()) {
				var ms= itemValue.getMilliseconds();
				switch(operator) {
					case Operators.Default:
					case Operators.Eq:
						return ms === numberValue;
					case Operators.Lt:
						return ms < numberValue;
					case Operators.Gt:
						return ms > numberValue;
				}
			}
			return false;
		},
		convertQueryValue: function(attribute, value) {
			if (value == null) 
				return -3;
			if (value.toLowerCase() === "set") 
				return -2;
			if (value.toLowerCase() === "unset") 
				return -1;
			return parseInt(value) * 60 * 60 * 1000;
		}
	}),
	dojo.mixin(new Evaluators(), {
		name: 'Enumeration',
		ordinal: 2,
		doEvaluate: function(operator, key, queryValue, itemValue, planItem) {
			if (queryValue == null || itemValue == null) {
				return false;
			}
			var compared= itemValue.compareTo(queryValue);
			if (operator === Operators.Default || operator === Operators.Eq) {
				return compared === 0;
			} else if (operator === Operators.Lt) {
				return compared < 0;
			} else if (operator === Operators.Gt) {
				return compared > 0;
			}
			return false;
		},
		convertQueryValue: function(attribute, value) {
			if (value == null) {
				return null;
			}
			var valueSet= attribute.getValueSet(null).getValues();
			for (var i= 0; i < valueSet.length; i++){
				if (valueSet[i].getLabel().toLowerCase() === value.toLowerCase()) {
					return valueSet[i];
				}
			}
			return null;
		}
	}),
	dojo.mixin(new Evaluators(), {
		name: 'Reference',
		ordinal: 3,
		convertQueryValue: function(attribute, value) {
			if (value == null) 
				return -3;
			if (value.toLowerCase() === "set") 
				return -1;
			if (value.toLowerCase() === "unset") 
				return -2;
			var number= parseInt(value);
			if (isNaN(number)) 
				return -3;
			return number;
		},
		doEvaluate: function(operator, key, queryValue, itemValue, planItem) {
			var queryNumber= queryValue;
			if (queryNumber === -3) {
				return false;
			}
			var references= itemValue;
			var length= references.getReferences().length;
			if (operator === Operators.Default && queryNumber < 0) {
				return (queryNumber === -1 && length !== 0) || (queryNumber === -2 && length === 0);
			}
			if (operator === Operators.Eq || operator === Operators.Default) {
				return queryNumber === length;
			} else if (operator === Operators.Gt) {
				return length > queryNumber;
			} else if (operator === Operators.Lt) {
				return length > queryNumber;
			}
			return false;
		}
	}),
	dojo.mixin(new Evaluators(), {
		name: 'False',
		ordinal: 4,
		doEvaluate: function(operator, key, queryValue, itemValue, planItem) {
			return false;
		},
		convertQueryValue: function(attribute, value) {
			return value;
		}
	}),
	dojo.mixin(new Evaluators(), {
		name: 'Instant',
		ordinal: 5,
		convertQueryValue: function(attribute, value) {
			if (value.indexOf("<") === 0 || value.indexOf(">") === 0) 
				value= value.substring(1);
			if (value.indexOf("-") !== -1 && value.indexOf("-") < 4) {
				return null;
			}
			var queryValue= this.checkIfPrefixExpression(value);
			if (queryValue != null) {
				return queryValue;
			} else if (this.checkIfAbsoluteDateExpression(value)) {
				var formatDate= new RegExp("-", "g");
				var convertedString= value.replace(formatDate, "/");
				return new Date(convertedString);
			}
			return null;
		},
		doEvaluate: function(operator, key, queryValue, itemValue, planItem) {
			var MILLISECONDSINADAY= 86400000;
			var dateCompareResult;
			var itemDate= (itemValue != null) ? new Date(itemValue.getTime()) : null;
			if (queryValue instanceof Date) {
				dateCompareResult= this.compareDates(itemDate, queryValue);
				if (itemDate != null) {
					if (operator === Operators.Lt) {
						return (dateCompareResult < 0);
					} else if (operator === Operators.Gt) {
						return (dateCompareResult > 0);
					} else {
						return (dateCompareResult === 0);
					}
				}
			} else {
				var today= queryValue;
				var timeDifference= new Date().getTime() + (today * MILLISECONDSINADAY);
				var differenceDate= new Date(timeDifference);
				dateCompareResult= this.compareDates(itemDate, differenceDate);
				if (itemDate != null) {
					if (operator === Operators.Lt) {
						return (dateCompareResult < 0);
					} else if (operator === Operators.Gt) {
						return (dateCompareResult > 0);
					} else {
						return (dateCompareResult === 0);
					}
				}
			}
			return false;
		},
		checkIfPrefixExpression: function(value) {
			var PREFIX= "today";
			var PREFIXFORWARD= "today+";
			var PREFIXBACKWARD= "today-";
			var nonNumericElements;
			var EXTRACT_NON_NUMERIC= new RegExp("[^(0-9)]", "g");
			if ((value === PREFIX)) {
				return Number(0);
			}
			if ((value.substring(0, 6) === PREFIXFORWARD)) {
				nonNumericElements= value.substring(6).match(EXTRACT_NON_NUMERIC);
				return (nonNumericElements != null && nonNumericElements.length > 0) ? null : parseInt(value.substring(6));
			} else if ((value.substring(0, 6) === PREFIXBACKWARD)) {
				nonNumericElements= value.substring(6).match(EXTRACT_NON_NUMERIC);
				return (nonNumericElements != null && nonNumericElements.length > 0) ? null : parseInt(value.substring(6)) * -1;
			}
			return null;
		},
		checkIfAbsoluteDateExpression: function(value) {
			return (value.match(QuickQueryParser.ABSOLUTE_DATE_REGEX) != null);
		},
		compareDates: function(date1, date2) {
			if (date1 != null && date2 != null) {
				var yearDifference= date1.getFullYear() - date2.getFullYear();
				if (yearDifference === 0) {
					var monthDifference= date1.getMonth() - date2.getMonth();
					if (monthDifference === 0) {
						return date1.getDate() - date2.getDate();
					} else {
						return monthDifference;
					}
				} else {
					return yearDifference;
				}
			}
			return -1;
		}
	}),
	dojo.mixin(new Evaluators(), {
		name: 'Item',
		ordinal: 6,
		doEvaluate: function(operator, key, queryValue, itemValue, planItem) {
			if (itemValue == null) 
				return queryValue === "unset";
			var value= false;
			if (dojo.isString(queryValue)) {
				var s= queryValue;
				if (s.charAt(0) === "\'" && s.charAt(s.length - 1) === "\'") {
					queryValue= s.substring(1, s.length - 2);
				}
			}
			if (operator === Operators.Subtree && jdojo.implementsInterface(itemValue, "com.ibm.team.apt.api.common.workitem.ICategory") && dojo.isString(queryValue)) {
				value= this.isSubCategory(queryValue, itemValue);
			} else if (jdojo.implementsInterface(itemValue, "com.ibm.team.apt.api.common.repository.IContributor") && this.checkIfCurrentUserExpression(queryValue)) {
				value= this.isCurrentUser(itemValue);
			} else if (key == null || (IQuickQueryCondition.DEFAULT_KEY === key)) {
				value= itemValue.getLabel().toLowerCase() === queryValue;
			} else if ((AttributeCondition.ID_KEY === key)) {
				value= itemValue.getItemId().toLowerCase() === queryValue;
			}
			return value;
		},
		isSubCategory: function(qvs, category) {
			qvs= ("/" + qvs + "/").toLowerCase();
			var categoryId= category.getCategoryId().toLowerCase();
			return categoryId.indexOf(qvs) !== -1;
		},
		checkIfCurrentUserExpression: function(value) {
			return (value === AttributeCondition.CURRENT_USER);
		},
		isCurrentUser: function(contributor) {
			return com.ibm.team.repository.web.client.internal.AUTHENTICATED_CONTRIBUTOR.itemId === contributor.getItemId();
		},
		convertQueryValue: function(attribute, value) {
			return value.toLowerCase();
		}
	}),
	dojo.mixin(new Evaluators(), {
		name: 'Number',
		ordinal: 7,
		doEvaluate: function(operator, key, queryValue, itemValue, planItem) {
			if (queryValue == null) {
				return false;
			}
			switch(operator) {
				case Operators.Default:
				case Operators.Eq:
					return itemValue === queryValue;
				case Operators.Lt:
					return itemValue <= queryValue;
				case Operators.Gt:
					return itemValue >= queryValue;
			}
			return false;
		},
		convertQueryValue: function(attribute, value) {
			return value != null ? parseFloat(value) : null;
		}
	}),
	dojo.mixin(new Evaluators(), {
		name: 'Decimal',
		ordinal: 8,
		doEvaluate: function(operator, key, queryValue, itemValue, planItem) {
			if (queryValue == null) {
				return false;
			}
			var itemDecimal= itemValue;
			var queryDecimal= queryValue;
			var compared= itemDecimal.compareTo(queryDecimal);
			switch(operator) {
				case Operators.Default:
				case Operators.Eq:
					return compared === 0;
				case Operators.Lt:
					return compared === -1;
				case Operators.Gt:
					return compared === 1;
			}
			return false;
		},
		convertQueryValue: function(attribute, value) {
			return value != null ? new BigDecimal(value) : null;
		}
	}),
	dojo.mixin(new Evaluators(), {
		name: 'ProblemReport',
		ordinal: 9,
		doEvaluate: function(operator, key, queryValue, itemValue, planItem) {
			return false;
		},
		convertQueryValue: function(attribute, value) {
			return value;
		}
	}),
	dojo.mixin(new Evaluators(), {
		name: 'State',
		ordinal: 10,
		doEvaluate: function(operator, key, queryValue, itemValue, planElement) {
			if (jdojo.implementsInterface(itemValue, "com.ibm.team.apt.api.common.workitem.IWorkflowState") && jdojo.implementsInterface(queryValue, "com.ibm.team.apt.api.common.workitem.IWorkflowState")) {
				var itemState= itemValue;
				var queryState= queryValue;
				var itemStateLabel= itemState.getLabel();
				var queryStateLabel= queryState.getLabel();
				return queryStateLabel.toLowerCase() === itemStateLabel.toLowerCase();
			}
			return false;
		},
		convertQueryValue: function(attribute, value) {
			if (value != null) {
				var loweredValue= value.toLowerCase();
				var values= attribute.getValueSet(null);
				var $subject= values.getValues();
				var $length= $subject.length;
				for (var $count= 0; $count < $length; $count++){
					var element= $subject[$count];
					if (jdojo.implementsInterface(element, "com.ibm.team.apt.api.common.workitem.IWorkflowState")) {
						if (element.getLabel().toLowerCase() === loweredValue) {
							return element;
						}
					}
				}
			}
			return null;
		}
	}),
	dojo.mixin(new Evaluators(), {
		name: 'Resolution',
		ordinal: 11,
		doEvaluate: function(operator, key, queryValue, itemValue, planElement) {
			if (jdojo.implementsInterface(itemValue, "com.ibm.team.apt.api.common.workitem.IWorkflowResolution")) {
				var state= itemValue;
				var label= state.getLabel();
				label= label == null ? AttributeCondition.EMPTY : label.toLowerCase();
				var isLabelEmpty= label === AttributeCondition.EMPTY;
				return queryValue === AttributeCondition.EMPTY ? !isLabelEmpty : label === queryValue;
			}
			return false;
		},
		convertQueryValue: function(attribute, value) {
			return value != null ? value.toLowerCase() : AttributeCondition.EMPTY;
		}
	}),
	dojo.mixin(new Evaluators(), {
		name: 'String',
		ordinal: 12,
		doEvaluate: function(operator, key, queryValue, itemValue, planItem) {
			if (queryValue == null || itemValue == null) {
				return false;
			}
			return itemValue.toLowerCase().indexOf(queryValue) !== -1;
		},
		convertQueryValue: function(attribute, value) {
			return value != null ? value.toLowerCase() : null;
		}
	}),
	dojo.mixin(new Evaluators(), {
		name: 'Tags',
		ordinal: 13,
		doEvaluate: function(operator, key, queryValue, itemValue, planItem) {
			var tags= itemValue;
			if (queryValue === AttributeCondition.EMPTY) {
				return tags.length > 0;
			}
			return dojo.indexOf(tags, String(queryValue)) !== -1;
		},
		convertQueryValue: function(attribute, value) {
			return value.toLowerCase();
		}
	})
];
Evaluators.Boolean= Evaluators.values[0];
Evaluators.Duration= Evaluators.values[1];
Evaluators.Enumeration= Evaluators.values[2];
Evaluators.Reference= Evaluators.values[3];
Evaluators.False= Evaluators.values[4];
Evaluators.Instant= Evaluators.values[5];
Evaluators.Item= Evaluators.values[6];
Evaluators.Number= Evaluators.values[7];
Evaluators.Decimal= Evaluators.values[8];
Evaluators.ProblemReport= Evaluators.values[9];
Evaluators.State= Evaluators.values[10];
Evaluators.Resolution= Evaluators.values[11];
Evaluators.String= Evaluators.values[12];
Evaluators.Tags= Evaluators.values[13];

})();
