/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.load.LoadLabelProvider"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.shared.ui.internal", "LoadMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.shared.ui.internal", "LoadMessages"); //$NON-NLS-1$ //$NON-NLS-2$
var HOUR= 1000 * 60 * 60;

dojo.declare("com.ibm.team.apt.shared.ui.internal.load.LoadLabelProvider", null, { //$NON-NLS-1$
	
	
	// ---- implementation -------------------------------------------------------------------------------------------------
	
	constructor: function(options){
	
	},
	
	getFillLevel: function(element){
		return element ? element.getQualityOfPlanning() : 0;
	},
	
	getDoneRange: function(element){
		if (element.getRealTimeLeft() == 0)
			return [0, 0];
		var stepsProgress= element.getStepsLeft() / element.getRealTimeLeft();
		if(stepsProgress > 1) {
			stepsProgress= 1 / stepsProgress;
		}
		return [0, stepsProgress];
	},
	
	getProjectionRange: function(element){
		if(this.getDeltaDirection(element) < 0){
			var delta= this.getDoneRange(element)[1];
			return [delta, 1 - delta];
		} else {
			return [-1, -1];
		}
	},
		
	getDeltaDirection: function(element){
		return element.getStepsLeft() == element.getRealTimeLeft() ? 0 : element.getStepsLeft() > element.getRealTimeLeft() ? -1 : 1;
	},
	
	getMessage: function(element){
		if(!element){
			return Messages['load_computing']; // XXX don't abuse null //$NON-NLS-1$
		} else if (element.getRealTimeLeft() == 0) {
			return Messages['load_noWorkTimeLeft']; //$NON-NLS-1$
		} else if (element.getCount() == 0) {
			return Messages['load_noWork']; //$NON-NLS-1$
		} else if (element.getEstimatedCount() == 0 && element.getOpenCount() > 0) {
			return Messages['load_noWorkEstimated']; //$NON-NLS-1$
		}
		return null;
	},
	
	getProgressText: function(element){
		var result= ""; //$NON-NLS-1$
		result+= this._toHours(element.getStepsLeft());
		result+= "/"; //$NON-NLS-1$
		result+= this._toHours(element.getRealTimeLeft());
		
		var diff= element.getRealTimeLeft() - element.getStepsLeft();
		if(this._toHours(diff) != "0") { //$NON-NLS-1$
			result+= " | "; //$NON-NLS-1$
			result+= "<span class=\"" + (diff < 0 ? "behind" : "ahead") + "\">"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			if(diff > 0)
				result+= "+"; //$NON-NLS-1$
			result+= this._toHours(diff);
			result+= Messages['load_ProgressHours']; //$NON-NLS-1$
			result+= "</span>"; //$NON-NLS-1$
		}
		
		result= bind(Messages['load_ProgressLabel'], [ result ]); //$NON-NLS-1$
		return result;
	},
	
    getOpenCloseText: function(element){
		var result;
        if(element && !element.isAllWorkDone()){
        	result= bind(Messages['load_ClosedPercentage'], [ Math.round(element.getClosedRatio() * 100) ]); //$NON-NLS-1$
        } else {
        	result= Messages['load_ClosedDone']; //$NON-NLS-1$
        }

		result= bind(Messages['load_ClosedLabel'], [ result ]); //$NON-NLS-1$
        return result;
    },
    
	getQualityText: function(element){
		var result;
		if (element && element.getCount() != 0 && !element.isAllWorkDone()) {
        	result= bind(Messages['load_EstimatedPercentage'], [ Math.round(element.getQualityOfPlanning() * 100) ]); //$NON-NLS-1$
		} else {
        	result= Messages['load_EstimatedNone']; //$NON-NLS-1$
		}

		result= bind(Messages['load_EstimatedLabel'], [ result ]); //$NON-NLS-1$
		return result;
	},
	
	getTooltipText: function(element) {
		var lines= [];
		lines.push("<span class=\"header\">" + Messages['load_tooltipTitle'] + "</span>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		
		lines.push(""); //$NON-NLS-1$
		lines.push(bind(Messages['load_tooltipTotalHoursAvailable'], [ this._toHours(element.getRealTimeLeft()) ])); //$NON-NLS-1$
		lines.push(bind(Messages['load_tooltipTotalHoursEstimated'], [ this._toHours(element.getStepsLeft()) ])); //$NON-NLS-1$
		if(this.getDeltaDirection(element) < 0) {
			lines.push(bind(Messages['load_tooltipTotalHoursOverbooked'], [ this._toHours(element.getStepsLeft() - element.getRealTimeLeft()) ])); //$NON-NLS-1$
		}
		
		var value= element.getQualityOfPlanning() * 100;
		var label= ""; //$NON-NLS-1$
		if(value < 33) {
			label= Messages['load_tooltipItemQualityPoor']; //$NON-NLS-1$
		} else if(value >= 33 && value < 66) {
			label= Messages['load_tooltipItemQualityFair']; //$NON-NLS-1$
		} else if(value >= 66 && value < 95) {
			label= Messages['load_tooltipItemQualityGood']; //$NON-NLS-1$
		} else if(value >= 95) {
			label= Messages['load_tooltipItemQualityExcellent']; //$NON-NLS-1$
		}
		
		lines.push(""); //$NON-NLS-1$
		lines.push(bind(Messages['load_tooltipItemsEstimated'], [ element.getEstimatedCount(), element.getOpenCount(), Math.round(value) ])); //$NON-NLS-1$
		lines.push(bind(Messages['load_tooltipItemQuality'], [ label ])); //$NON-NLS-1$
					
		return lines.join("<br />"); //$NON-NLS-1$
	},
	
	// ----- implementation ------------------------------------------------------------------------------------------------
	
	_toHours: function(value, n){
		n= n == undefined ? 2 : n; 
		var fac= Math.pow(10, n);
		var neg= value < 0;
		value= Math.abs(value); //negative numbers are rounded in the same way positive are
		var result= Math.round((value / HOUR) * fac) / fac;
		var fraction= result - Math.floor(result);
		result-= fraction;
		if(fraction <= 0.125){
			fraction= 0;
		} else if(fraction > 0.125 && fraction <= 0.25){
			fraction= 0.25;
		} else if(fraction > 0.25 && fraction <= 0.5){
			fraction= 0.5;
		} else if(fraction > 0.5 && fraction <= 0.75){
			fraction= 0.75;
		} else if(fraction > 0.75){
			fraction= 1;
		}
		return dojo.number.format((result + fraction) * (neg ? -1 : 1));
	},
	
	_hasWork: function(element) {
		return element.getCount() > 0;
	},

	_hasEstimatedWork: function(element) {
		return this._hasWork(element) && element.getEstimatedCount() > 0;
	},
	
	__sentinel: null // terminates this class definition
});

})();
