/******************************************************************************
 Licensed Materials - Property of IBM
 © Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 
 Note to U.S. Government Users Restricted Rights:
 Use, duplication or disclosure restricted by GSA ADP Schedule
 Contract with IBM Corp.
******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.ui.internal.filters.QuickQueryFilter");

dojo.require("com.ibm.jdojo.util.Assert");
dojo.require("com.ibm.team.apt.api.client.IPlanItem");
dojo.require("com.ibm.team.apt.shared.ui.internal.filters.AbstractPlanElementFilter");
dojo.require("com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryParser");

(function() {
var Assert= com.ibm.jdojo.util.Assert;
var apt= com.ibm.team.apt;
var IPlanItem= apt.api.client.IPlanItem;
var internal= apt.shared.ui.internal;
var AbstractPlanElementFilter= internal.filters.AbstractPlanElementFilter;
var QuickQueryParser= internal.quickqueries.QuickQueryParser;

dojo.declare("com.ibm.team.apt.shared.ui.internal.filters.QuickQueryFilter", AbstractPlanElementFilter, {

	//fCondition: null,

	constructor: function(filter, definition) {
		this.inherited(arguments, []);
		if (!(filter != null && definition != null)) Assert.fail("filter != null && definition != null", "QuickQueryFilter:28");
		var expression= filter.getParameter("expression");
		if (expression != null) {
			var parser= new QuickQueryParser(definition);
			this.fCondition= parser.getExpressionForExclusion(expression, true);
		}
	},

	getDependentAttributes: function() {
		var attributeIdentifiers= [];
		attributeIdentifiers.push(IPlanItem.DIRTY);
		if (this.fCondition != null) {
			Array.prototype.push.apply(attributeIdentifiers, this.fCondition.getDependentAttributes());
		}
		return attributeIdentifiers;
	},

	isFilterProperty: function(entry, property) {
		if (this.fCondition == null) 
			return false;
		var dependentAttributes= this.fCondition.getDependentAttributes();
		var $subject= dependentAttributes;
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var identifier= $subject[$count];
			if ((property === identifier.getId())) {
				return true;
			}
		}
		return false;
	},

	doSelect: function(entry, readAccessor) {
		return this.fCondition == null || !this.fCondition.evaluate(entry.getElement());
	}
});

})();
