/******************************************************************************
 Licensed Materials - Property of IBM
 © Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 
 Note to U.S. Government Users Restricted Rights:
 Use, duplication or disclosure restricted by GSA ADP Schedule
 Contract with IBM Corp.
******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.ui.internal.filters.AbstractPlanElementFilter");

dojo.require("com.ibm.jdojo.lang.Runtime");
dojo.require("com.ibm.team.apt.api.client.IPlanItem");
dojo.require("com.ibm.team.rtc.foundation.api.ui.tags.PrimaryLocationTag");

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;
var team= com.ibm.team;
var IPlanItem= team.apt.api.client.IPlanItem;
var PrimaryLocationTag= team.rtc.foundation.api.ui.tags.PrimaryLocationTag;

dojo.declare("com.ibm.team.apt.shared.ui.internal.filters.AbstractPlanElementFilter", null, {
	"-chains-": { constructor: "manual" },

	//fDependentAttrs: null,

	//fFilterProperty: null,

	constructor: function( /*, more... */ ) {
		var more= Array.prototype.slice.call(arguments, 0);
		this.fFilterProperty= [];
		Array.prototype.push.apply(this.fFilterProperty, more);
		this.fDependentAttrs= [IPlanItem.DIRTY];
		Array.prototype.push.apply(this.fDependentAttrs, this.fFilterProperty);
	},

	getDependentAttributes: function() {
		return this.fDependentAttrs;
	},

	isFilterProperty: function(entry, property) {
		for (var i= 0; i < this.fFilterProperty.length; i++){
			if (property === this.fFilterProperty[i].getId()) 
				return true;
		}
		return false;
	},

	isDirty: function(element) {
		var dirtyAttributes= element.getAttributeValue(IPlanItem.DIRTY);
		return dirtyAttributes == null || dirtyAttributes.isDirty();
	},

	select: function(entry, readAccessor) {
		var element= entry.getElement();
		if (!(jdojo.implementsInterface(element, "com.ibm.team.apt.api.client.IPlanElement"))) 
			return true;
		if (this.isDirty(element)) 
			return true;
		var selected= this.doSelect(entry, readAccessor);
		return this.applyContextToSelection(entry, readAccessor, selected);
	},

	applyContextToSelection: function(entry, readAccessor, entrySelected) {
		if (entry.hasTag(PrimaryLocationTag.INSTANCE) || !entrySelected) 
			return entrySelected;
		var parent= readAccessor.getParent(entry);
		if (!(jdojo.implementsInterface(parent.getElement(), "com.ibm.team.apt.api.ui.structure.IGroupElement")) && !parent.isRootEntry()) 
			return true;
		var $subject= readAccessor.getChildren(entry);
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var child= $subject[$count];
			if (child.isVisible()) {
				return true;
			}
		}
		return false;
	},

	doSelect: function(entry, readAccessor) {
		return true;
	},

	$interfaces: {
		'com.ibm.team.apt.api.client.IPlanningAttributeDependent': true,
		'com.ibm.team.rtc.foundation.api.ui.model.IViewEntryFilter': true
	}
});

})();
