/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.filter.WorkItemTypeFilter"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.shared.ui.model.EntryFilter"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.ui.Create"); //$NON-NLS-1$

(function() {

var PlanItem						= com.ibm.team.apt.client.PlanItem;
var FilterType						= com.ibm.team.apt.shared.ui.model.EntryFilter.FilterType;
var Create							= com.ibm.team.apt.shared.ui.Create;

dojo.declare("com.ibm.team.apt.shared.ui.internal.filter.WorkItemTypeFilter", com.ibm.team.apt.shared.ui.model.EntryFilter, { //$NON-NLS-1$

	fIncludedTypes: null,

	fExcludedTypes: null,

	constructor: function(getPlanFn, options) {
		this.fIncludedTypes= {};
		this.fExcludedTypes= {};
		var parameter= options.getParameter("types");
		this.fetchTypes(parameter, this.fIncludedTypes);
		parameter= options.getParameter("include-types");
		this.fetchTypes(parameter, this.fIncludedTypes);
		parameter= options.getParameter("exclude-types");
		this.fetchTypes(parameter, this.fExcludedTypes);
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getDependantAttributes: function() {
		return [PlanItem.ITEM_TYPE];
	},
	
	isFilterType: function(filterType) {
		return filterType == FilterType.Regular;
	},

    isFilterProperty: function(entry, property) {
		return property === PlanItem.ITEM_TYPE.getId();
    },

	select: function(entry, readAccessor) {
		var element= entry.getElement();
		if (!(element instanceof PlanItem)) 
			return true;
		var pe= element;
		var type= pe.getAttributeValue(PlanItem.ITEM_TYPE);
		return this.selectType(type.getItemId());
    },
    
	canCreate: function(request, readAccessor) {
		var type= request.workItemType;
		if (this.selectType(type.getItemId())) {
			return new CreateResponse(type);
		} else {
			return CreateResponse.DENY;
		}
	},

	fetchTypes: function(parameter, types) {
		if (parameter != null) {
			var start= 0;
			do {
				var end= parameter.indexOf(";", start);
				if (end === -1) {
					var key= parameter.substring(start);
					if ((key !== "") && !(key in types)) {
						types[key]= true;
					}
					start= parameter.length;
				} else {
					var key= parameter.substring(start, end);
					if (!(key in types)) {
						types[key]= true;
					}
					start= end + 1;
				}
			} while(start < parameter.length)
		}
	},
	
	selectType: function(identifier) {
		if (identifier in this.fIncludedTypes) {
			return (identifier in this.fIncludedTypes);
		}
		if (identifier in this.fExcludedTypes) {
			return !(identifier in this.fExcludedTypes);
		}
		return true;
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});

})();
