/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2014. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.filter.TopLevelTypeFilter"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.shared.ui.model.EntryFilter"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$

(function() {

var PlanItem						= com.ibm.team.apt.client.PlanItem;
var FilterType						= com.ibm.team.apt.shared.ui.model.EntryFilter.FilterType;

dojo.declare("com.ibm.team.apt.shared.ui.internal.filter.TopLevelTypeFilter", com.ibm.team.apt.shared.ui.model.EntryFilter, { //$NON-NLS-1$

	fInverse: false,

	constructor: function(getPlanFn, options) {
		fInverse= options.getParameter("invert");
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	isFilterType: function(filterType) {
		return filterType == FilterType.Regular;
	},

    isFilterProperty: function(entry, property) {
		return true; // XXX this should actually check the property
    },

	select: function(entry, readAccessor) {
		var element= entry.getElement();
		if (fInverse) {
			return !(element instanceof PlanItem) || !element.isTopLevelPlanItem();
		}
		return !(element instanceof PlanItem) || element.isTopLevelPlanItem(); 
    },

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});

})();
