/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.filter.SubIterationFilter"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.shared.ui.model.EntryFilter"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$

(function() {

var PlanItem						= com.ibm.team.apt.client.PlanItem;
var FilterType						= com.ibm.team.apt.shared.ui.model.EntryFilter.FilterType;

dojo.declare("com.ibm.team.apt.shared.ui.internal.filter.SubIterationFilter", com.ibm.team.apt.shared.ui.model.EntryFilter, { //$NON-NLS-1$

	constructor: function(getPlanFn, options) {
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getDependantAttributes: function() {
		return [PlanItem.TARGET];
	},
	
	isFilterType: function(filterType) {
		return filterType == FilterType.Regular;
	},

    isFilterProperty: function(entry, property) {
		return PlanItem.TARGET.getId() === property;
    },

	select: function(entry, readAccessor) {
		var element= entry.getElement();
		if (!(element instanceof PlanItem))
			return true;
		var plan= element.getPlanModel();
		var rootIteration= plan.getIterationHierarchy().getElement();
		return rootIteration.equals(element.getAttributeValue(PlanItem.TARGET)); 
    },

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});

})();
