/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.filter.OddIdFilter"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.shared.ui.model.EntryFilter"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$

(function() {

var PlanItem						= com.ibm.team.apt.client.PlanItem;
var FilterType						= com.ibm.team.apt.shared.ui.model.EntryFilter.FilterType;

dojo.declare("com.ibm.team.apt.shared.ui.internal.filter.OddIdFilter", com.ibm.team.apt.shared.ui.model.EntryFilter, { //$NON-NLS-1$

	constructor: function(getPlanFn, options) {
	},

	// ---- api ------------------------------------------------------------------------------------------------------------
	getDependantAttributes: function() {
		return [PlanItem.ID];
	},
	
	isFilterType: function(filterType) {
		return filterType == FilterType.Regular;
	},

	select: function(entry, readAccessor) {
		var element= entry.getElement();
		return !(element instanceof PlanItem) || (element.getAttributeValue(PlanItem.ID) % 2 == 0); 
    },

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});

})();
