/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.internal.filter.EmptyGroupsFilter"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.shared.ui.model.EntryFilter"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.GroupElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.ColumnElement"); //$NON-NLS-1$

(function() {

var FilterType						= com.ibm.team.apt.shared.ui.model.EntryFilter.FilterType;
var GroupElement					= com.ibm.team.apt.ui.structure.GroupElement;
var ColumnElement					= com.ibm.team.apt.ui.structure.ColumnElement;

dojo.declare("com.ibm.team.apt.shared.ui.internal.filter.EmptyGroupsFilter", com.ibm.team.apt.shared.ui.model.EntryFilter, { //$NON-NLS-1$

	constructor: function(getPlanFn, options) {
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	isFilterType: function(filterType) {
		return filterType === FilterType.Regular || filterType === FilterType.Post;
	},

    isFilterProperty: function(entry, property) {
		return false;
    },

	select: function(entry, readAccessor) {
    	var element= entry.getElement();
    	if (!(element instanceof GroupElement) || element instanceof ColumnElement)
    		return true;
    	
    	return readAccessor.getEntryNavigator(true).childEntries(entry).length > 0;
    },

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});

})();
