/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.ui.Create"); //$NON-NLS-1$

(function() {

dojo.declare("com.ibm.team.apt.shared.ui.Create.Request", null, { //$NON-NLS-1$

	constructor: function(targetEntry, workItemType, location) {
		this.targetEntry= targetEntry;
		this.workItemType= workItemType;
		this.location= location;
	},

	// ---- implementation -------------------------------------------------------------------------------------------------
	targetEntry: null,
	workItemType: null,
	location: null,
	
	__sentinel: null // terminates this class definition
});

dojo.declare("com.ibm.team.apt.shared.ui.Create.Response", null, { //$NON-NLS-1$

	constructor: function(targetEntry, info) {
		this.targetEntry= targetEntry;
		this.info= info;
	},
	
	canCreate: function() {
		return this.targetEntry != null;
	},
	
	setNewItem: function(newItem) {
		this.newItem= newItem;
	},
	
	// ---- implementation -------------------------------------------------------------------------------------------------

	targetEntry: null,
	newItem: null,
	info: null,

	__sentinel: null // terminates this class definition
});

com.ibm.team.apt.shared.ui.Create.Response.DENY= new com.ibm.team.apt.shared.ui.Create.Response(null, false);

com.ibm.team.apt.shared.ui.Create.After= 1;
com.ibm.team.apt.shared.ui.Create.Before= 2;
com.ibm.team.apt.shared.ui.Create.Child= 3;

})();
