/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.ui.internal.quickqueries;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSArray;
import com.ibm.jdojo.util.JSArrays;
import com.ibm.team.apt.api.client.IPlanElement;
import com.ibm.team.apt.api.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.api.ui.quickquery.IQuickQueryCondition;

public class Term
extends DojoObject
implements IQuickQueryCondition {
    private Operator fOperator;
    private JSArray<IQuickQueryCondition> fExpressions = new JSArray();

    public Term(Operator operator, IQuickQueryCondition ... subterms) {
        this.fOperator = operator;
        IQuickQueryCondition[] iQuickQueryConditionArray = subterms;
        int n = subterms.length;
        int n2 = 0;
        while (n2 < n) {
            IQuickQueryCondition subterm = iQuickQueryConditionArray[n2];
            this.fExpressions.push((Object)subterm);
            ++n2;
        }
    }

    public boolean evaluate(IPlanElement planItem) {
        if (this.fExpressions.length == 0) {
            return false;
        }
        switch (this.fOperator) {
            case NOT: {
                if (!((IQuickQueryCondition)this.fExpressions.get(0)).canEvaluate(planItem)) {
                    return false;
                }
                return !((IQuickQueryCondition)this.fExpressions.get(0)).evaluate(planItem);
            }
            case OR: {
                int i = 0;
                while (i < this.fExpressions.length) {
                    if (((IQuickQueryCondition)this.fExpressions.get(i)).evaluate(planItem)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case AND: {
                int i = 0;
                while (i < this.fExpressions.length) {
                    if (!((IQuickQueryCondition)this.fExpressions.get(i)).evaluate(planItem)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        assert (false) : "unexpected operator for Term";
        return false;
    }

    public void add(IQuickQueryCondition expression) {
        this.fExpressions.push((Object)expression);
    }

    public boolean isEqual(IQuickQueryCondition other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        if (this.fOperator != ((Term)other).fOperator) {
            return false;
        }
        if (this.fExpressions.length != ((Term)other).fExpressions.length) {
            return false;
        }
        int i = 0;
        while (i < this.fExpressions.length) {
            if (!((IQuickQueryCondition)this.fExpressions.get(i)).isEqual((IQuickQueryCondition)((Term)other).fExpressions.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IPlanningAttributeIdentifier[] getDependentAttributes() {
        Object[] result = new IPlanningAttributeIdentifier[]{};
        IQuickQueryCondition[] iQuickQueryConditionArray = (IQuickQueryCondition[])this.fExpressions.toArray();
        int n = iQuickQueryConditionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IQuickQueryCondition evaluatable = iQuickQueryConditionArray[n2];
            JSArrays.pushArray((Object[])result, (Object[])evaluatable.getDependentAttributes());
            ++n2;
        }
        return result;
    }

    public Operator getOperator() {
        return this.fOperator;
    }

    public IQuickQueryCondition[] getSubConditions() {
        return (IQuickQueryCondition[])this.fExpressions.toArray();
    }

    public boolean canEvaluate(IPlanElement planItem) {
        return true;
    }

    public static enum Operator {
        AND,
        OR,
        NOT;

    }
}

