/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.ui.internal.quickqueries;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.team.apt.api.client.IPlanningAttribute;
import com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryUtil;

public class QuickQueryProposal
extends DojoObject {
    public static final String DEFAULT_OPERATIOR = ":";
    private final IPlanningAttribute<?> fAttribute;
    private final String fOperator;
    private final String fParameter;
    private final int fStart;
    private final int fEnd;
    private final boolean fAttributeMatched;

    public QuickQueryProposal(IPlanningAttribute<?> attribute, String operator, String parameter, int start, int end, boolean attributeMatched) {
        this.fAttribute = attribute;
        this.fOperator = operator == null ? DEFAULT_OPERATIOR : operator;
        this.fParameter = parameter;
        this.fStart = start;
        this.fEnd = end;
        this.fAttributeMatched = attributeMatched;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getEnd() {
        return this.fEnd;
    }

    public int compareTo(QuickQueryProposal other) {
        int value = (this.fParameter == null ? 0 : 1) - (other.fParameter == null ? 0 : 1);
        if (value == 0 && this.fAttribute.getId() != other.fAttribute.getId()) {
            value = this.fAttribute.getDescription().getLabel().compareTo(other.fAttribute.getDescription().getLabel());
        }
        return value;
    }

    public String getLabel() {
        return this.withParameter(QuickQueryUtil.getLabel(this.fAttribute));
    }

    private String withParameter(String text) {
        if (this.fAttributeMatched && this.fParameter != null) {
            return this.fParameter;
        }
        String result = text;
        result = String.valueOf(result) + this.fOperator;
        if (this.fParameter != null) {
            result = String.valueOf(result) + this.fParameter;
        }
        return result;
    }

    public int getCursorPosition() {
        return this.getLabel().length();
    }
}

